/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.view;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.ColumnInfo;
import asandatabasebrowser.model.ITableInfo;
import asandatabasebrowser.model.ResultInfo;
import asandatabasebrowser.model.ResultSetInfo;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.DbColumnNameRenderer;
import asandatabasebrowser.view.DbColumnValueRenderer;
import asandatabasebrowser.view.RitchTable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.table.DefaultTableModel;

public class DbRecordView
extends RitchTable {
    static final Object NO_RECORD;
    ITableInfo tableInfo = null;
    private Object[] rec = null;
    private DefaultTableModel model = new DefaultTableModel();
    private DbColumnNameRenderer columnNameRenderer;
    private DbColumnValueRenderer columnValueRenderer;
    static final /* synthetic */ boolean $assertionsDisabled;

    DbRecordView(VvDatabase db) {
        if (!$assertionsDisabled && db == null) {
            throw new AssertionError();
        }
        this.setModel(this.model);
        this.addMouseListener(new RecordMouseListener());
        this.getTableHeader().setReorderingAllowed(false);
        this.setSelectionMode(2);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.model.addColumn("name");
        this.model.addColumn("value");
        this.setToolTipText("\u308c\u3053\u30fc\u3069");
        this.columnNameRenderer = new DbColumnNameRenderer(db);
        this.columnValueRenderer = new DbColumnValueRenderer();
        this.getColumnModel().getColumn(0).setCellRenderer(this.columnNameRenderer);
        this.getColumnModel().getColumn(1).setCellRenderer(this.columnValueRenderer);
    }

    public void setRecord(ITableInfo tableInfo, Object[] rec) {
        if (!$assertionsDisabled && tableInfo == null) {
            throw new AssertionError();
        }
        this.tableInfo = tableInfo;
        this.rec = rec;
        this.model.setRowCount(tableInfo.getColumnCount());
        for (int i = 0; i < tableInfo.getColumnCount(); ++i) {
            String name = tableInfo.getColumnName(i);
            this.model.setValueAt(name, i, 0);
            this.model.setValueAt(rec != null ? rec[i] : NO_RECORD, i, 1);
        }
    }

    public String getToolTipText(MouseEvent e) {
        int col = this.columnAtPoint(e.getPoint());
        if (col == -1) {
            return null;
        }
        int row = this.rowAtPoint(e.getPoint());
        if (row == -1) {
            return null;
        }
        if (col == 0) {
            if (this.tableInfo instanceof TableInfo) {
                TableInfo table = (TableInfo)this.tableInfo;
                ColumnInfo info = table.getColumnInfo(row);
                return table.getDatabase().getToolTipText(table, info);
            }
            ResultSetInfo table = (ResultSetInfo)this.tableInfo;
            ResultInfo info = table.getResultInfo(row);
            return table.getDatabase().getToolTipText(info);
        }
        if (this.rec == null) {
            return null;
        }
        Object value = this.model.getValueAt(row, col);
        if (value == null) {
            return "<html><font color=\"GRAY\">NULL</font></html>";
        }
        return value.toString();
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    static {
        $assertionsDisabled = !DbRecordView.class.desiredAssertionStatus();
        NO_RECORD = "NO_RECORD";
    }

    class RecordMouseListener
    extends MouseAdapter {
        RecordMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            try {
                if (e.getClickCount() == 2 && (e.getModifiers() & 0x10) != 0) {
                    int col = DbRecordView.this.columnAtPoint(e.getPoint());
                    if (col == -1) {
                        return;
                    }
                    int row = DbRecordView.this.rowAtPoint(e.getPoint());
                    if (row == -1) {
                        return;
                    }
                    if (col == 1) {
                        Object data = DbRecordView.this.getValueAt(row, col);
                        AsanDatabaseBrowser.theApp.openLargeObject(data, DbRecordView.this.tableInfo, DbRecordView.this.rec, row);
                    }
                }
            }
            catch (Exception ex) {
                AsanDatabaseBrowser.theApp.showMessage(DbRecordView.this, "\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", ex, 0);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.mousePopup(e);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.mousePopup(e);
            }
        }

        void mousePopup(MouseEvent e) {
            JPopupMenu popup = new JPopupMenu();
            popup.add(new RitchTable.CopyClipboardAction(DbRecordView.this, DbRecordView.this));
            popup.add(new RitchTable.SelectAllAction(DbRecordView.this, DbRecordView.this));
            popup.show(DbRecordView.this, e.getX(), e.getY());
        }
    }
}

