/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.view;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.action.CreateInsertAction;
import asandatabasebrowser.action.CreateUpdateAction;
import asandatabasebrowser.model.DbData;
import asandatabasebrowser.model.ITableInfo;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.DbColumnValueRenderer;
import asandatabasebrowser.view.RitchTable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import javax.swing.JPopupMenu;
import javax.swing.table.DefaultTableModel;

public class DbResultSetView
extends RitchTable {
    static final int FONT_WIDTH = 8;
    static final int MAX_HEADER_WIDTH = 300;
    public DbData data;
    private final DefaultTableModel model = new DefaultTableModel();
    private final DbColumnValueRenderer columnValueRenderer;

    DbResultSetView() {
        this.setModel(this.model);
        this.setAutoResizeMode(0);
        this.getTableHeader().addMouseListener(new DbTableHeaderMouseListener());
        this.getTableHeader().setReorderingAllowed(false);
        this.setSelectionMode(2);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setToolTipText("\u3066\u30fc\u3076\u308b");
        this.columnValueRenderer = new DbColumnValueRenderer();
        this.setDefaultRenderer(Object.class, this.columnValueRenderer);
        this.addMouseListener(new RecordMouseListener());
        this.updateHeader();
    }

    void updateHeader() {
        this.model.setColumnCount(0);
        if (this.data != null) {
            for (int i = 0; i < this.data.tableInfo.getColumnCount(); ++i) {
                this.model.addColumn(this.data.tableInfo.getColumnName(i));
            }
            for (int c = 0; c < this.getColumnModel().getColumnCount(); ++c) {
                int w = this.getFitWidth(c);
                this.getColumnModel().getColumn(c).setPreferredWidth(w);
            }
        }
    }

    void updateData(DbData data) {
        boolean changed = false;
        if (this.data == null != (data == null)) {
            changed = true;
        }
        if (this.data != null && data != null && !((Object)this.data.tableInfo).equals(data.tableInfo)) {
            changed = true;
        }
        this.data = data;
        if (changed) {
            this.updateHeader();
        }
        this.model.setRowCount(data.getRecordCount());
        for (int r = 0; r < data.getRecordCount(); ++r) {
            Object[] record = data.getRecord(r);
            for (int c = 0; c < record.length; ++c) {
                this.setValueAt(record[c], r, c);
            }
        }
    }

    private int getFitWidth(int col) {
        Object[] record;
        int len;
        int size;
        int prefWidth = 0;
        int len2 = this.data.tableInfo.getColumnName(col).length();
        prefWidth = len2 * 8 + 4;
        for (int r = 0; r < this.data.getRecordCount() && ((size = (len = (record = this.data.getRecord(r))[col] != null ? record[col].toString().length() : 4) * 8 + 4) <= prefWidth || (prefWidth = size) < 300); ++r) {
        }
        return Math.min(prefWidth, 300);
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public String getToolTipText(MouseEvent e) {
        int col = this.columnAtPoint(e.getPoint());
        if (col == -1) {
            return null;
        }
        int row = this.rowAtPoint(e.getPoint());
        if (row == -1) {
            return null;
        }
        Object value = this.model.getValueAt(row, col);
        if (value == null) {
            return "<html><font color=\"GRAY\">NULL</font></html>";
        }
        return value.toString();
    }

    private int getHeaderBorder(int x) {
        int total = 0;
        for (int c = 0; c < this.getColumnModel().getColumnCount(); ++c) {
            int w = this.getColumnModel().getColumn(c).getWidth();
            if (Math.abs((total += w) - x) > 3) continue;
            return c;
        }
        return -1;
    }

    class RecordMouseListener
    extends MouseAdapter {
        RecordMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            try {
                if (e.getClickCount() == 2 && (e.getModifiers() & 0x10) != 0) {
                    int col = DbResultSetView.this.columnAtPoint(e.getPoint());
                    if (col == -1) {
                        return;
                    }
                    int row = DbResultSetView.this.rowAtPoint(e.getPoint());
                    if (row == -1) {
                        return;
                    }
                    ITableInfo table = DbResultSetView.this.data.getTableInfo();
                    Object value = DbResultSetView.this.getValueAt(row, col);
                    AsanDatabaseBrowser.theApp.openLargeObject(value, table, DbResultSetView.this.data.getRecord(row), col);
                }
            }
            catch (Exception ex) {
                AsanDatabaseBrowser.theApp.showMessage(DbResultSetView.this, "\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", ex, 0);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.mousePopup(e);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.mousePopup(e);
            }
        }

        void mousePopup(MouseEvent e) {
            JPopupMenu popup = new JPopupMenu();
            popup.add(new RitchTable.CopyClipboardAction(DbResultSetView.this, DbResultSetView.this));
            popup.add(new RitchTable.SelectAllAction(DbResultSetView.this, DbResultSetView.this));
            if (DbResultSetView.this.data.tableInfo instanceof TableInfo) {
                popup.addSeparator();
                VvDatabase db = DbResultSetView.this.data.tableInfo.getDatabase();
                popup.add(new CreateInsertAction(AsanDatabaseBrowser.theApp, db, DbResultSetView.this));
                popup.add(new CreateUpdateAction(AsanDatabaseBrowser.theApp, db, DbResultSetView.this));
            }
            popup.show(DbResultSetView.this, e.getX(), e.getY());
        }
    }

    class DbTableHeaderMouseListener
    extends MouseAdapter
    implements Comparator {
        private int lastCol = -1;
        private boolean asc = false;

        DbTableHeaderMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            System.out.println(e);
            if (e.isConsumed()) {
                return;
            }
            if (e.getClickCount() == 1 && (e.getModifiers() & 0x10) != 0) {
                if (DbResultSetView.this.getHeaderBorder(e.getX()) != -1) {
                    return;
                }
                int col = DbResultSetView.this.getTableHeader().columnAtPoint(e.getPoint());
                if (col != -1) {
                    if (col == this.lastCol) {
                        this.asc = !this.asc;
                    } else {
                        this.lastCol = col;
                        this.asc = true;
                    }
                    DbResultSetView.this.data.sort(this);
                    DbResultSetView.this.updateData(DbResultSetView.this.data);
                    DbResultSetView.this.model.fireTableDataChanged();
                    DbResultSetView.this.getSelectionModel().clearSelection();
                    e.consume();
                }
            } else if (e.getClickCount() == 2 && e.getButton() == 1) {
                int col = DbResultSetView.this.getHeaderBorder(e.getX());
                System.out.println(col);
                if (col != -1) {
                    int w = DbResultSetView.this.getFitWidth(col);
                    DbResultSetView.this.getColumnModel().getColumn(col).setPreferredWidth(w);
                    DbResultSetView.this.getColumnModel().getColumn(col).setWidth(w);
                }
                e.consume();
            }
        }

        public int compare(Object o1, Object o2) {
            return this.asc ? this.compare0(o1, o2) : -this.compare0(o1, o2);
        }

        public int compare0(Object o1, Object o2) {
            Object[] rec1 = (Object[])o1;
            Object fld1 = rec1[this.lastCol];
            Object[] rec2 = (Object[])o2;
            Object fld2 = rec2[this.lastCol];
            if (fld1 == fld2) {
                return 0;
            }
            if (fld1 == null) {
                return -1;
            }
            if (fld2 == null) {
                return 1;
            }
            if (fld1 instanceof Comparable) {
                Comparable c1 = (Comparable)fld1;
                Comparable c2 = (Comparable)fld2;
                return c1.compareTo(c2);
            }
            System.out.println("\u6bd4\u8f03\u3067\u304d\u306a\u3044\u578b\u3067\u3059 " + fld1.getClass());
            return 0;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    }
}

