/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.view;

import asandatabasebrowser.Global;
import asandatabasebrowser.action.ExecuteQueryAction;
import asandatabasebrowser.action.FavoriteSqlAction;
import asandatabasebrowser.action.TabAddAction;
import asandatabasebrowser.action.TabRemoveAction;
import asandatabasebrowser.model.DbData;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.DbRecordView;
import asandatabasebrowser.view.DbResultSetView;
import asandatabasebrowser.view.JTabbedTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class DbSqlFrame
extends JFrame {
    public final VvDatabase db;
    public DbData data = null;
    DbResultSetView tableView = null;
    DbRecordView recordView = null;
    public JTabbedTextArea textarea;
    ExecuteQueryAction queryAction = new ExecuteQueryAction(this);
    static final /* synthetic */ boolean $assertionsDisabled;

    public DbSqlFrame(VvDatabase db) throws DbException {
        if (!$assertionsDisabled && db == null) {
            throw new AssertionError();
        }
        this.setIconImage(Global.getImage("/resources/SQLView.png"));
        this.db = db;
        this.tableView = new DbResultSetView();
        this.recordView = new DbRecordView(db);
        this.textarea = new JTabbedTextArea(db, new SqlKeyListener());
        JSplitPane sp2 = new JSplitPane(1);
        sp2.setLeftComponent(new JScrollPane(this.tableView));
        sp2.setRightComponent(new JScrollPane(this.recordView));
        sp2.setDividerLocation(400);
        sp2.setOneTouchExpandable(true);
        JSplitPane sp1 = new JSplitPane(0);
        sp1.setTopComponent(this.textarea);
        sp1.setBottomComponent(sp2);
        sp1.setDividerLocation(100);
        sp1.setOneTouchExpandable(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)sp1, "Center");
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        toolbar.add(this.queryAction);
        toolbar.addSeparator();
        toolbar.add(new TabAddAction(this.textarea));
        toolbar.add(new TabRemoveAction(this.textarea));
        if (System.getProperty("debug") != null) {
            toolbar.addSeparator();
            toolbar.add(new FavoriteSqlAction(this));
        }
        this.getContentPane().add((Component)toolbar, "North");
        this.tableView.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        this.setTitle(db.name);
        this.setSize(640, 480);
    }

    public void addSqlTab(String sql) {
        this.textarea.addTextArea(sql);
    }

    public String getCurrentSql() {
        return this.textarea.getCurrentText();
    }

    public void updateData(DbData data) {
        boolean changed = false;
        if (this.data == null != (data == null)) {
            changed = true;
        }
        if (this.data != null && data != null && !((Object)this.data.tableInfo).equals(data.tableInfo)) {
            changed = true;
        }
        this.data = data;
        this.tableView.updateData(data);
        if (changed) {
            int index = this.tableView.getSelectionModel().getAnchorSelectionIndex();
            Object[] rec = index != -1 ? data.getRecord(index) : null;
            this.recordView.setRecord(data.tableInfo, rec);
        }
        this.setTitle(this.db.name + "(" + data.getRecordCount() + " records)");
    }

    public void refresh() {
        ((AbstractTableModel)this.tableView.getModel()).fireTableStructureChanged();
        ((AbstractTableModel)this.recordView.getModel()).fireTableDataChanged();
    }

    static {
        $assertionsDisabled = !DbSqlFrame.class.desiredAssertionStatus();
    }

    class TableSelectionListener
    implements ListSelectionListener {
        TableSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                int index = DbSqlFrame.this.tableView.getSelectionModel().getAnchorSelectionIndex();
                if (0 <= index && index < DbSqlFrame.this.data.getRecordCount()) {
                    Object[] rec = DbSqlFrame.this.data.getRecord(index);
                    DbSqlFrame.this.recordView.setRecord(DbSqlFrame.this.data.tableInfo, rec);
                } else if (DbSqlFrame.this.data.getRecordCount() == 0) {
                    DbSqlFrame.this.recordView.setRecord(DbSqlFrame.this.data.tableInfo, null);
                } else {
                    Object[] rec = DbSqlFrame.this.data.getRecord(0);
                    DbSqlFrame.this.recordView.setRecord(DbSqlFrame.this.data.tableInfo, rec);
                }
            }
        }
    }

    class SqlKeyListener
    extends KeyAdapter {
        SqlKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10 && e.isShiftDown()) {
                DbSqlFrame.this.queryAction.executeQuery();
            }
        }
    }
}

