/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.view;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.Global;
import asandatabasebrowser.action.ExecuteQueryAction;
import asandatabasebrowser.action.TabAddAction;
import asandatabasebrowser.action.TabRemoveAction;
import asandatabasebrowser.model.DbData;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.view.DbRecordView;
import asandatabasebrowser.view.DbResultSetView;
import asandatabasebrowser.view.JTabbedTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import net.sourceforge.swingx.SxUtilities;

public class DbTableFrame
extends JFrame {
    public final TableInfo tableInfo;
    String defaultSql;
    DbResultSetView tableView = null;
    DbRecordView recordView = null;
    JTabbedTextArea textarea;
    ExecuteQueryAction refreshAction = new ExecuteQueryAction(this);
    static final /* synthetic */ boolean $assertionsDisabled;

    public DbTableFrame(TableInfo tableInfo) throws DbException {
        if (!$assertionsDisabled && tableInfo == null) {
            throw new AssertionError();
        }
        this.tableInfo = tableInfo;
        tableInfo.updateColumnInfoList();
        this.setIconImage(Global.getImage("/resources/TableView.png"));
        this.defaultSql = "select * from " + tableInfo.getSqlTableName();
        DbData data = tableInfo.db.queryTable(tableInfo, this.defaultSql, true);
        this.tableView = new DbResultSetView();
        this.tableView.updateData(data);
        this.recordView = new DbRecordView(tableInfo.db);
        this.textarea = new JTabbedTextArea(tableInfo.db, new SqlKeyListener());
        this.textarea.addTextArea("-- \u3053\u3053\u306bwhere\u53e5\u4ee5\u964d\u3092\u8a18\u8ff0\u3057\u3066\u304f\u3060\u3055\u3044");
        JSplitPane sp2 = new JSplitPane(1);
        sp2.setLeftComponent(new JScrollPane(this.tableView));
        sp2.setRightComponent(new JScrollPane(this.recordView));
        sp2.setOneTouchExpandable(true);
        sp2.setResizeWeight(0.7);
        JSplitPane sp1 = new JSplitPane(0);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel top = new JPanel(new BorderLayout());
        JTextField label = new JTextField(this.defaultSql);
        label.setEditable(false);
        label.setBorder(null);
        SxUtilities.addPopupMenuMouseListener(label);
        label.setFont(AsanDatabaseBrowser.theApp.doc.getFont());
        top.add((Component)label, "North");
        top.add((Component)this.textarea, "Center");
        sp1.setTopComponent(top);
        sp1.setBottomComponent(sp2);
        sp1.setOneTouchExpandable(true);
        sp1.setResizeWeight(0.25);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)sp1, "Center");
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        toolbar.add(this.refreshAction);
        toolbar.addSeparator();
        toolbar.add(new OpenSqlFrameAction(AsanDatabaseBrowser.theApp));
        toolbar.addSeparator();
        toolbar.add(new TabAddAction(this.textarea));
        toolbar.add(new TabRemoveAction(this.textarea));
        this.getContentPane().add((Component)toolbar, "North");
        this.tableView.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        this.setTitle(tableInfo.getSqlTableName() + " (" + data.getRecordCount() + " records)");
        this.setSize(640, 480);
    }

    public String getSql() {
        return this.defaultSql + " " + this.textarea.getCurrentText();
    }

    public void setData(DbData data) {
        this.tableView.updateData(data);
        ((AbstractTableModel)this.recordView.getModel()).fireTableDataChanged();
        this.setTitle(this.tableInfo.getSqlTableName() + " (" + data.getRecordCount() + " records)");
    }

    public void refresh() {
        ((AbstractTableModel)this.tableView.getModel()).fireTableStructureChanged();
        ((AbstractTableModel)this.recordView.getModel()).fireTableDataChanged();
    }

    static {
        $assertionsDisabled = !DbTableFrame.class.desiredAssertionStatus();
    }

    class OpenSqlFrameAction
    extends AbstractAction {
        AsanDatabaseBrowser tools;

        public OpenSqlFrameAction(AsanDatabaseBrowser tools) {
            super("SQL\u30a6\u30a3\u30f3\u30c9\u30a6");
            this.putValue("ShortDescription", "SQL\u30a6\u30a3\u30f3\u30c9\u30a6\u3092\u958b\u304d\u307e\u3059");
            this.putValue("LongDescription", "SQL\u30a6\u30a3\u30f3\u30c9\u30a6\u30eb\u3092\u958b\u304d\u307e\u3059");
            this.putValue("SmallIcon", Global.getImageIcon("/resources/SQLView.png"));
            this.tools = tools;
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                String sql = DbTableFrame.this.defaultSql + " " + DbTableFrame.this.textarea.getCurrentText();
                this.tools.openSqlFrame(DbTableFrame.this.tableInfo.db, sql);
            }
            catch (Exception e) {
                this.tools.showMessage(DbTableFrame.this, "\u30c6\u30fc\u30d6\u30eb\u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093", e, 0);
            }
        }
    }

    class TableSelectionListener
    implements ListSelectionListener {
        TableSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                DbData data = DbTableFrame.this.tableView.data;
                int index = DbTableFrame.this.tableView.getSelectionModel().getAnchorSelectionIndex();
                if (0 <= index && index < data.getRecordCount()) {
                    Object[] rec = data.getRecord(index);
                    DbTableFrame.this.recordView.setRecord(data.tableInfo, rec);
                } else {
                    DbTableFrame.this.recordView.setRecord(data.tableInfo, null);
                }
            }
        }
    }

    class SqlKeyListener
    extends KeyAdapter {
        SqlKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10 && e.isShiftDown()) {
                DbTableFrame.this.refreshAction.executeQuery();
            }
        }
    }
}

