/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.view;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.Global;
import asandatabasebrowser.action.ExecuteCommitAction;
import asandatabasebrowser.action.ExecuteQueryAction;
import asandatabasebrowser.action.RecordDeleteAction;
import asandatabasebrowser.action.RecordEditCancelAction;
import asandatabasebrowser.action.RecordExecuteAction;
import asandatabasebrowser.action.RecordInsertAction;
import asandatabasebrowser.action.RecordInsertSelectAction;
import asandatabasebrowser.action.RecordUpdateAction;
import asandatabasebrowser.action.TabAddAction;
import asandatabasebrowser.action.TabRemoveAction;
import asandatabasebrowser.model.DbData;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.view.DbRecordView;
import asandatabasebrowser.view.DbTableView;
import asandatabasebrowser.view.IMenuEnable;
import asandatabasebrowser.view.JTabbedTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import net.sourceforge.swingx.SxUtilities;
import net.sourceforge.swingx.jspread.JSpreadSelectionEvent;
import net.sourceforge.swingx.jspread.JSpreadSelectionListener;

public class DbTableFrame2
extends JFrame
implements IMenuEnable {
    public final TableInfo tableInfo;
    final String defaultSql;
    public final DbTableView tableView;
    DbRecordView recordView = null;
    JTabbedTextArea textarea;
    ExecuteQueryAction queryAction;
    Action recordInsertAction;
    Action recordInsertSelectAction;
    Action recordUpdateAction;
    Action recordDeleteAction;
    Action recordEditCancelAction;
    Action recordExecuteAction;
    Action executeCommitAction;
    Action executeRollbackAction;
    Action openSqlFrameAction;
    Action tabAddAction;
    Action tabRemoveAction;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DbTableFrame2(TableInfo tableInfo) throws DbException {
        if (!$assertionsDisabled && tableInfo == null) {
            throw new AssertionError();
        }
        this.tableInfo = tableInfo;
        tableInfo.updateColumnInfoList();
        this.setIconImage(Global.getImage("/resources/TableView.png"));
        this.defaultSql = "select * from " + tableInfo.getSqlTableName();
        DbData data = tableInfo.db.queryTable(tableInfo, this.defaultSql, true);
        this.tableView = new DbTableView(data);
        this.recordView = new DbRecordView(data.tableInfo.getDatabase());
        this.recordView.setRecord(tableInfo, null);
        this.textarea = new JTabbedTextArea(tableInfo.db, new SqlKeyListener());
        this.textarea.addTextArea("-- \u3053\u3053\u306bwhere\u53e5\u4ee5\u964d\u3092\u8a18\u8ff0\u3057\u3066\u304f\u3060\u3055\u3044");
        JSplitPane sp2 = new JSplitPane(1);
        sp2.setLeftComponent(this.tableView);
        sp2.setRightComponent(new JScrollPane(this.recordView));
        sp2.setOneTouchExpandable(true);
        sp2.setResizeWeight(0.7);
        JSplitPane sp1 = new JSplitPane(0);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel top = new JPanel(new BorderLayout());
        JTextField label = new JTextField(this.defaultSql);
        label.setEditable(false);
        label.setBorder(null);
        SxUtilities.addPopupMenuMouseListener(label);
        label.setFont(AsanDatabaseBrowser.theApp.doc.getFont());
        top.add((Component)label, "North");
        top.add((Component)this.textarea, "Center");
        sp1.setTopComponent(top);
        sp1.setBottomComponent(sp2);
        sp1.setOneTouchExpandable(true);
        sp1.setResizeWeight(0.25);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)sp1, "Center");
        this.queryAction = new ExecuteQueryAction(this);
        this.recordInsertAction = new RecordInsertAction(this);
        this.recordInsertSelectAction = new RecordInsertSelectAction(this);
        this.recordUpdateAction = new RecordUpdateAction(this);
        this.recordDeleteAction = new RecordDeleteAction(this);
        this.recordEditCancelAction = new RecordEditCancelAction(this);
        this.recordExecuteAction = new RecordExecuteAction(this);
        this.executeCommitAction = new ExecuteCommitAction(this, tableInfo.db, "commit", null);
        this.executeRollbackAction = new ExecuteCommitAction(this, tableInfo.db, "rollback", null);
        this.openSqlFrameAction = new OpenSqlFrameAction(AsanDatabaseBrowser.theApp);
        this.tabAddAction = new TabAddAction(this.textarea);
        this.tabRemoveAction = new TabRemoveAction(this.textarea);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        toolbar.add(this.queryAction);
        toolbar.addSeparator();
        toolbar.add(this.recordInsertAction);
        toolbar.add(this.recordInsertSelectAction);
        toolbar.add(this.recordUpdateAction);
        toolbar.add(this.recordDeleteAction);
        toolbar.add(this.recordEditCancelAction);
        toolbar.addSeparator();
        toolbar.add(this.recordExecuteAction);
        toolbar.addSeparator();
        toolbar.add(this.executeCommitAction);
        toolbar.add(this.executeRollbackAction);
        toolbar.addSeparator();
        toolbar.add(this.openSqlFrameAction);
        toolbar.addSeparator();
        toolbar.add(this.tabAddAction);
        toolbar.add(this.tabRemoveAction);
        this.getContentPane().add((Component)toolbar, "North");
        this.tableView.addSelectionListener(new TableSelectionListener());
        this.setTitle(tableInfo.getSqlTableName() + " (" + data.getRecordCount() + " records)");
        this.setSize(640, 480);
        this.updateActionState();
        this.tableView.getComponent("CellPane").grabFocus();
        System.out.println("FocusCol=" + this.tableView.getFocusColumn() + " FocusRow=" + this.tableView.getFocusRow() + " CurCol=" + this.tableView.getCurrentColumn() + " CurRow=" + this.tableView.getCurrentRow());
    }

    public String getSql() {
        return this.defaultSql + " " + this.textarea.getCurrentText();
    }

    public void setData(DbData data) {
        this.tableView.updateData(data);
        ((AbstractTableModel)this.recordView.getModel()).fireTableDataChanged();
        this.setTitle(this.tableInfo.getSqlTableName() + " (" + data.getRecordCount() + " records)");
    }

    public void refresh() {
        ((AbstractTableModel)this.recordView.getModel()).fireTableDataChanged();
    }

    public void updateActionState() {
        System.out.println("updateActionState() enter");
        boolean isSelectedEditingRecord = false;
        boolean existsEditingRecord = false;
        boolean hasSelect = false;
        boolean[] sel = this.tableView.getSheet().getSelectionArray(1);
        DbData data = this.tableView.data;
        for (int i = 0; i < data.getRecordCount(); ++i) {
            boolean is_select = sel[i];
            if (data.getMode(i) != -1) {
                existsEditingRecord = true;
                if (is_select) {
                    isSelectedEditingRecord = true;
                }
            }
            if (!is_select) continue;
            hasSelect = true;
        }
        this.queryAction.setEnabled(!existsEditingRecord);
        this.recordInsertAction.setEnabled(true);
        this.recordInsertSelectAction.setEnabled(hasSelect && !isSelectedEditingRecord);
        this.recordUpdateAction.setEnabled(hasSelect && !isSelectedEditingRecord);
        this.recordDeleteAction.setEnabled(hasSelect && !isSelectedEditingRecord);
        this.recordEditCancelAction.setEnabled(hasSelect && isSelectedEditingRecord);
        this.recordExecuteAction.setEnabled(existsEditingRecord);
        this.executeCommitAction.setEnabled(true);
        this.executeRollbackAction.setEnabled(true);
        this.openSqlFrameAction.setEnabled(true);
        this.tabAddAction.setEnabled(true);
        this.tabRemoveAction.setEnabled(this.textarea.getTabCount() > 1);
    }

    static {
        $assertionsDisabled = !DbTableFrame2.class.desiredAssertionStatus();
    }

    class OpenSqlFrameAction
    extends AbstractAction {
        AsanDatabaseBrowser tools;

        public OpenSqlFrameAction(AsanDatabaseBrowser tools) {
            super("SQL\u30a6\u30a3\u30f3\u30c9\u30a6");
            this.putValue("ShortDescription", "SQL\u30a6\u30a3\u30f3\u30c9\u30a6\u3092\u958b\u304d\u307e\u3059");
            this.putValue("LongDescription", "SQL\u30a6\u30a3\u30f3\u30c9\u30a6\u30eb\u3092\u958b\u304d\u307e\u3059");
            this.putValue("SmallIcon", Global.getImageIcon("/resources/SQLView.png"));
            this.tools = tools;
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                String sql = DbTableFrame2.this.defaultSql + " " + DbTableFrame2.this.textarea.getCurrentText();
                this.tools.openSqlFrame(DbTableFrame2.this.tableInfo.db, sql);
                DbTableFrame2.this.updateActionState();
            }
            catch (Exception e) {
                this.tools.showMessage(DbTableFrame2.this, "\u30c6\u30fc\u30d6\u30eb\u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093", e, 0);
            }
        }
    }

    class TableSelectionListener
    implements JSpreadSelectionListener {
        TableSelectionListener() {
        }

        public void valueChanged(JSpreadSelectionEvent e) {
            DbData data = DbTableFrame2.this.tableView.data;
            int index = e.nextCurRow;
            if (0 <= index && index < data.getRecordCount()) {
                Object[] rec = data.getRecord(index);
                DbTableFrame2.this.recordView.setRecord(data.tableInfo, rec);
            } else {
                DbTableFrame2.this.recordView.setRecord(data.tableInfo, null);
            }
            DbTableFrame2.this.updateActionState();
        }
    }

    class SqlKeyListener
    extends KeyAdapter {
        SqlKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10 && e.isShiftDown()) {
                DbTableFrame2.this.queryAction.executeQuery();
            }
        }
    }
}

