/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.view;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.Global;
import asandatabasebrowser.action.CreateInsertAction;
import asandatabasebrowser.action.CreateUpdateAction;
import asandatabasebrowser.model.ColumnInfo;
import asandatabasebrowser.model.DbData;
import asandatabasebrowser.model.ITableInfo;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.VvDatabase;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.border.LineBorder;
import net.sourceforge.swingx.Logger;
import net.sourceforge.swingx.SxMouseAdapter;
import net.sourceforge.swingx.jspread.JSpread;
import net.sourceforge.swingx.jspread.JSpreadCellEditor;
import net.sourceforge.swingx.jspread.JSpreadCellRenderer;

public class DbTableView
extends JSpread {
    private static Logger logger;
    static final int FONT_WIDTH = 8;
    static final int MAX_HEADER_WIDTH = 300;
    public DbData data;
    private CellRenderer2 renderer = new CellRenderer2();
    static JSpreadCellEditor numericEditor;
    static JSpreadCellEditor charEditor;
    static JSpreadCellEditor dateEditor;
    static JSpreadCellEditor timeEditor;
    static JSpreadCellEditor timestampEditor;
    static JSpreadCellEditor bitEditor;
    static final /* synthetic */ boolean $assertionsDisabled;

    DbTableView(DbData data) {
        this.data = data;
        this.getSheet().allowAutoRowHeaderResize = false;
        this.updateData(data);
        this.fitAll();
        this.setToolTipEnabled("CellPane", true);
        this.setToolTipEnabled("ColumnHeaderPane", true);
        this.getComponent("CellPane").addMouseListener(new CellMouseListener());
        this.getComponent("ColumnHeaderPane").addMouseListener(new HeaderMouseListener());
        this.getComponent("RowHeaderPane").addMouseListener(new RowMouseListener());
    }

    public boolean isCellEditable(int row, int column) {
        int mode = this.data.getMode(row);
        return mode == 0 || mode == 1;
    }

    public JSpreadCellEditor getCellEditor(Object value, int rowDataIndex, int colDataIndex) {
        TableInfo table = (TableInfo)this.data.tableInfo;
        short dataType = table.getColumnInfo((int)colDataIndex).dataType;
        switch (dataType) {
            case -7: {
                return bitEditor;
            }
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: {
                System.out.println("dataType=" + dataType + " typeName=" + table.getColumnInfo((int)colDataIndex).typeName);
                AsanDatabaseBrowser.theApp.showMessage(this, "\u3053\u306e\u578b\u306e\u30a8\u30c7\u30a3\u30bf\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\ndataType=" + dataType + " typeName=" + table.getColumnInfo((int)colDataIndex).typeName, null, 2);
                return null;
            }
            case 1: 
            case 12: {
                return charEditor;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return numericEditor;
            }
            case 16: 
            case 70: {
                System.out.println("dataType=" + dataType + " typeName=" + table.getColumnInfo((int)colDataIndex).typeName);
                AsanDatabaseBrowser.theApp.showMessage(this, "\u3053\u306e\u578b\u306e\u30a8\u30c7\u30a3\u30bf\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\ndataType=" + dataType + " typeName=" + table.getColumnInfo((int)colDataIndex).typeName, null, 2);
                return null;
            }
            case 91: {
                return dateEditor;
            }
            case 92: {
                return timeEditor;
            }
            case 93: {
                return timestampEditor;
            }
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                System.out.println("dataType=" + dataType + " typeName=" + table.getColumnInfo((int)colDataIndex).typeName);
                AsanDatabaseBrowser.theApp.showMessage(this, "\u3053\u306e\u578b\u306e\u30a8\u30c7\u30a3\u30bf\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\ndataType=" + dataType + " typeName=" + table.getColumnInfo((int)colDataIndex).typeName, null, 2);
                return null;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError(dataType);
        }
        return null;
    }

    public Object getValueAt(int rowDataIndex, int colDataIndex) {
        return this.data.getRecord(rowDataIndex)[colDataIndex];
    }

    public void setValueAt(Object value, int rowDataIndex, int colDataIndex) {
        if (!$assertionsDisabled && 0 > rowDataIndex) {
            throw new AssertionError(rowDataIndex);
        }
        if (!$assertionsDisabled && 0 > colDataIndex) {
            throw new AssertionError(colDataIndex);
        }
        int mode = this.data.getMode(rowDataIndex);
        if (!$assertionsDisabled && mode != 0 && mode != 1) {
            throw new AssertionError();
        }
        super.setValueAt(value, rowDataIndex, colDataIndex);
        this.data.getRecord((int)rowDataIndex)[colDataIndex] = value;
        this.repaint();
    }

    public Object getHeaderValueAt(int header, int dataIndex) {
        switch (header) {
            case 1: {
                switch (this.data.getMode(dataIndex)) {
                    case 0: {
                        return Global.recordInsertIcon;
                    }
                    case 1: {
                        return Global.recordUpdateIcon;
                    }
                    case 2: {
                        return Global.recordDeleteIcon;
                    }
                    case -1: {
                        return "" + (dataIndex + 1);
                    }
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError(this.data.getMode(dataIndex));
                }
                return null;
            }
            case 2: {
                return this.data.tableInfo.getColumnName(dataIndex);
            }
            case 3: {
                return null;
            }
        }
        return null;
    }

    public JSpreadCellRenderer getCellRenderer(Object value, int rowDataIndex, int columnDataIndex) {
        if (!$assertionsDisabled && 0 > rowDataIndex) {
            throw new AssertionError(rowDataIndex);
        }
        if (!$assertionsDisabled && 0 > columnDataIndex) {
            throw new AssertionError(columnDataIndex);
        }
        return this.renderer;
    }

    void updateData(DbData data) {
        System.out.println("updateData() " + data.tableInfo);
        ITableInfo info0 = this.data.tableInfo;
        this.data = data;
        this.setCellCount(data.getRecordCount(), data.tableInfo.getColumnCount(), null);
        if (!((Object)info0).equals(data.tableInfo)) {
            this.fitAll();
        }
        this.\u518d\u914d\u7f6e();
    }

    private void fitAll() {
        for (int c = 0; c < this.data.tableInfo.getColumnCount(); ++c) {
            int w = this.getFitWidth(c, true);
            this.getSheet().getHeader(2).setPreferredWidth(c, w);
            this.getSheet().getHeader(2).setWidth(c, w);
        }
    }

    private int getFitWidth(int col, boolean containHeader) {
        Object[] record;
        int len;
        int size;
        int prefWidth = 0;
        if (containHeader) {
            int len2 = this.data.tableInfo.getColumnName(col).length();
            prefWidth = len2 * 8 + 4;
        }
        for (int r = 0; r < this.data.getRecordCount() && ((size = (len = (record = this.data.getRecord(r))[col] != null ? record[col].toString().length() : 4) * 8 + 4) <= prefWidth || (prefWidth = size) < 300); ++r) {
        }
        return Math.min(prefWidth, 300);
    }

    protected String getToolTipText(String panename, MouseEvent e) {
        if (panename.equals("CellPane")) {
            int col = this.getViewPositionAtPoint(2, e.getX());
            if (col == -1) {
                return null;
            }
            int row = this.getViewPositionAtPoint(1, e.getY());
            if (row == -1) {
                return null;
            }
            return "" + this.getValueAt(row, col);
        }
        if (panename.equals("ColumnHeaderPane")) {
            int col = this.getViewPositionAtPoint(2, e.getX());
            if (col == -1) {
                return null;
            }
            TableInfo table = (TableInfo)this.data.tableInfo;
            return table.getDatabase().getToolTipText(table, table.getColumnInfo(col));
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)panename);
        }
        return null;
    }

    public boolean[] getSelection() {
        System.out.println("getSelection() enter " + System.currentTimeMillis());
        boolean[] result = new boolean[this.data.getRecordCount()];
        for (int i = 0; i < this.data.getRecordCount(); ++i) {
            result[i] = this.isSelectedRecord(i);
        }
        System.out.println("getSelection() exit  " + System.currentTimeMillis());
        return result;
    }

    public boolean isSelectedRecord(int row) {
        int count = this.getHeader(2).getViewCount();
        for (int c = 0; c < count; ++c) {
            if (!this.getCellSelection(row, c)) continue;
            return true;
        }
        return false;
    }

    boolean isSelectEditingCell() {
        for (int r = 0; r < this.data.getRecordCount(); ++r) {
            int mode = this.data.getMode(r);
            if (mode != 0 && mode != 1) continue;
            Object[] rec = this.data.getRecord(r);
            for (int c = 0; c < rec.length; ++c) {
                if (!this.getCellSelection(r, c)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        $assertionsDisabled = !DbTableView.class.desiredAssertionStatus();
        logger = Logger.getLogger(DbTableView.class);
        numericEditor = new JSpreadCellEditor.NumberEditor();
        charEditor = new JSpreadCellEditor.DefaultCellEditor();
        dateEditor = new DateEditor();
        timeEditor = new TimeEditor();
        timestampEditor = new TimestampEditor();
        bitEditor = new BitEditor();
    }

    class SetOriginalAction
    extends AbstractAction {
        SetOriginalAction() {
            super("\u9078\u629e\u3055\u308c\u305f\u30bb\u30eb\u3092\u7de8\u96c6\u524d\u306e\u5024\u306b\u3059\u308b(O)");
            this.putValue("MnemonicKey", new Integer(79));
            this.putValue("ShortDescription", "\u9078\u629e\u3055\u308c\u305f\u30bb\u30eb\u3092\u7de8\u96c6\u524d\u306e\u5024\u306b\u3059\u308b");
            this.putValue("LongDescription", "\u9078\u629e\u3055\u308c\u305f\u30bb\u30eb\u3092\u7de8\u96c6\u524d\u306e\u5024\u306b\u3059\u308b");
        }

        public void actionPerformed(ActionEvent ev) {
            for (int r = 0; r < DbTableView.this.data.getRecordCount(); ++r) {
                int mode = DbTableView.this.data.getMode(r);
                if (mode != 0 && mode != 1) continue;
                Object[] rec = DbTableView.this.data.getRecord(r);
                for (int c = 0; c < rec.length; ++c) {
                    if (!DbTableView.this.getCellSelection(r, c)) continue;
                    rec[c] = DbTableView.this.data.getOriginalValue(r, c);
                }
            }
            DbTableView.this.repaint();
        }
    }

    class SetDefaultAction
    extends AbstractAction {
        SetDefaultAction() {
            super("\u9078\u629e\u3055\u308c\u305f\u30bb\u30eb\u3092\u30c7\u30d5\u30a9\u30eb\u30c8\u5024\u306b\u3059\u308b(D)");
            this.putValue("MnemonicKey", new Integer(68));
            this.putValue("ShortDescription", "\u9078\u629e\u3055\u308c\u305f\u30bb\u30eb\u3092\u30c7\u30d5\u30a9\u30eb\u30c8\u5024\u306b\u3059\u308b");
            this.putValue("LongDescription", "\u9078\u629e\u3055\u308c\u305f\u30bb\u30eb\u3092\u30c7\u30d5\u30a9\u30eb\u30c8\u5024\u306b\u3059\u308b");
        }

        public void actionPerformed(ActionEvent ev) {
            TableInfo table = (TableInfo)DbTableView.this.data.tableInfo;
            for (int r = 0; r < DbTableView.this.data.getRecordCount(); ++r) {
                int mode = DbTableView.this.data.getMode(r);
                if (mode != 0 && mode != 1) continue;
                Object[] rec = DbTableView.this.data.getRecord(r);
                for (int c = 0; c < rec.length; ++c) {
                    if (!DbTableView.this.getCellSelection(r, c)) continue;
                    rec[c] = table.getColumnInfo((int)c).columnDefault;
                }
            }
            DbTableView.this.repaint();
        }
    }

    class SetNullAction
    extends AbstractAction {
        SetNullAction() {
            super("\u9078\u629e\u3055\u308c\u305f\u30bb\u30eb\u3092 NULL \u306b\u3059\u308b(N)");
            this.putValue("MnemonicKey", new Integer(78));
            this.putValue("ShortDescription", "\u9078\u629e\u3055\u308c\u305f\u30bb\u30eb\u3092 NULL \u306b\u3059\u308b");
            this.putValue("LongDescription", "\u9078\u629e\u3055\u308c\u305f\u30bb\u30eb\u3092 NULL \u306b\u3059\u308b");
        }

        public void actionPerformed(ActionEvent ev) {
            for (int r = 0; r < DbTableView.this.data.getRecordCount(); ++r) {
                int mode = DbTableView.this.data.getMode(r);
                if (mode != 0 && mode != 1) continue;
                Object[] rec = DbTableView.this.data.getRecord(r);
                for (int c = 0; c < rec.length; ++c) {
                    if (!DbTableView.this.getCellSelection(r, c)) continue;
                    System.out.println(rec[c]);
                    rec[c] = null;
                }
            }
            DbTableView.this.repaint();
        }
    }

    class SortAction
    extends AbstractAction
    implements Comparator {
        private int col;
        private boolean asc;

        SortAction(int col, boolean asc, String title) {
            super(title);
            this.col = col;
            this.asc = asc;
            String icon = asc ? "/resources/SortAsc.png" : "/resources/SortDsc.png";
            this.putValue("SmallIcon", Global.getImageIcon(icon));
            this.putValue("ShortDescription", title);
            this.putValue("LongDescription", title);
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println(e);
            DbTableView.this.data.sort(this);
            DbTableView.this.updateData(DbTableView.this.data);
            DbTableView.this.\u518d\u63cf\u753b();
        }

        public int compare(Object o1, Object o2) {
            return this.asc ? this.compare0(o1, o2) : -this.compare0(o1, o2);
        }

        public int compare0(Object o1, Object o2) {
            Object[] rec1 = (Object[])o1;
            Object fld1 = rec1[this.col];
            Object[] rec2 = (Object[])o2;
            Object fld2 = rec2[this.col];
            if (fld1 == fld2) {
                return 0;
            }
            if (fld1 == null) {
                return -1;
            }
            if (fld2 == null) {
                return 1;
            }
            if (fld1 instanceof Comparable) {
                Comparable c1 = (Comparable)fld1;
                Comparable c2 = (Comparable)fld2;
                return c1.compareTo(c2);
            }
            System.out.println("\u6bd4\u8f03\u3067\u304d\u306a\u3044\u578b\u3067\u3059 " + fld1.getClass());
            return 0;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    }

    class HeaderMouseListener
    extends SxMouseAdapter {
        HeaderMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            int col1;
            int col0;
            if (e.getClickCount() == 2 && (e.getModifiers() & 0x10) != 0 && (col0 = DbTableView.this.getViewPositionAtPoint(2, e.getX() - 3)) != (col1 = DbTableView.this.getViewPositionAtPoint(2, e.getX() + 3))) {
                if (DbTableView.this.getHeaderSelection(2, col0)) {
                    for (int c = 0; c < DbTableView.this.getCellCount(2); ++c) {
                        if (!DbTableView.this.getHeaderSelection(2, c)) continue;
                        int w = DbTableView.this.getFitWidth(c, true);
                        DbTableView.this.getSheet().getHeader(2).setPreferredWidth(c, w);
                        DbTableView.this.getSheet().getHeader(2).setWidth(c, w);
                    }
                } else {
                    int w = DbTableView.this.getFitWidth(col0, true);
                    DbTableView.this.getSheet().getHeader(2).setPreferredWidth(col0, w);
                    DbTableView.this.getSheet().getHeader(2).setWidth(col0, w);
                }
                DbTableView.this.\u518d\u914d\u7f6e();
                e.consume();
            }
        }

        public void mousePopup(MouseEvent e) {
            int col = DbTableView.this.getViewPositionAtPoint(2, e.getX());
            if (col == -1) {
                return;
            }
            System.out.println("Popup! " + e);
            JPopupMenu popup = new JPopupMenu();
            popup.add(new SortAction(col, true, "\u6607\u9806\u306b\u30bd\u30fc\u30c8"));
            popup.add(new SortAction(col, false, "\u964d\u9806\u306b\u30bd\u30fc\u30c8"));
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    class RowMouseListener
    extends SxMouseAdapter {
        RowMouseListener() {
        }

        public void mousePopup(MouseEvent e) {
            JPopupMenu popup = new JPopupMenu();
            popup.add(DbTableView.this.getActionMap().get("CopyClipboardAction"));
            popup.add(DbTableView.this.getActionMap().get("SelectAllAction"));
            popup.addSeparator();
            VvDatabase db = DbTableView.this.data.tableInfo.getDatabase();
            popup.add(new CreateInsertAction(AsanDatabaseBrowser.theApp, db, DbTableView.this));
            popup.add(new CreateUpdateAction(AsanDatabaseBrowser.theApp, db, DbTableView.this));
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    class CellMouseListener
    extends SxMouseAdapter {
        CellMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            try {
                if (e.getClickCount() == 2 && (e.getModifiers() & 0x10) != 0) {
                    int col = DbTableView.this.getViewPositionAtPoint(2, e.getX());
                    if (col == -1) {
                        return;
                    }
                    int row = DbTableView.this.getViewPositionAtPoint(1, e.getY());
                    if (row == -1) {
                        return;
                    }
                    Object value = DbTableView.this.getValueAt(row, col);
                    AsanDatabaseBrowser.theApp.openLargeObject(value, DbTableView.this.data.tableInfo, DbTableView.this.data.getRecord(row), col);
                }
            }
            catch (Exception ex) {
                AsanDatabaseBrowser.theApp.showMessage(DbTableView.this, "\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", ex, 0);
            }
        }

        public void mousePopup(MouseEvent e) {
            JPopupMenu popup = new JPopupMenu();
            popup.add(DbTableView.this.getActionMap().get("CopyClipboardAction"));
            popup.add(DbTableView.this.getActionMap().get("SelectAllAction"));
            popup.addSeparator();
            if (DbTableView.this.isSelectEditingCell()) {
                popup.add(new SetNullAction());
                popup.add(new SetDefaultAction());
                popup.add(new SetOriginalAction());
                popup.addSeparator();
            }
            VvDatabase db = DbTableView.this.data.tableInfo.getDatabase();
            popup.add(new CreateInsertAction(AsanDatabaseBrowser.theApp, db, DbTableView.this));
            popup.add(new CreateUpdateAction(AsanDatabaseBrowser.theApp, db, DbTableView.this));
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    static class BitEditor
    extends JSpreadCellEditor.DefaultCellEditor {
        BitEditor() {
        }

        public void setCellValue(Object value) {
            this.textField.setText(value == null ? "null" : value.toString());
        }

        public Object getCellValue() {
            String s = this.textField.getText();
            if (s.length() == 0) {
                return null;
            }
            try {
                return Boolean.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                logger.debug(s, e);
                this.textField.setBorder(new LineBorder(Color.red));
                AsanDatabaseBrowser.theApp.showMessage(this.textField, "\u30c7\u30fc\u30bf\u5909\u63db\u30a8\u30e9\u30fc[" + s + "]", e, 0);
                return this.value;
            }
        }
    }

    static class TimestampEditor
    extends JSpreadCellEditor.DefaultCellEditor {
        TimestampEditor() {
        }

        public void setCellValue(Object value) {
            this.textField.setText(value == null ? "" : value.toString());
        }

        public Object getCellValue() {
            String s = this.textField.getText();
            if (s.length() == 0) {
                return null;
            }
            try {
                return Timestamp.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                logger.debug(s, e);
                this.textField.setBorder(new LineBorder(Color.red));
                AsanDatabaseBrowser.theApp.showMessage(this.textField, "\u30c7\u30fc\u30bf\u5909\u63db\u30a8\u30e9\u30fc[" + s + "]", e, 0);
                return this.value;
            }
        }
    }

    static class TimeEditor
    extends JSpreadCellEditor.DefaultCellEditor {
        TimeEditor() {
        }

        public void setCellValue(Object value) {
            this.textField.setText(value == null ? "" : value.toString());
        }

        public Object getCellValue() {
            String s = this.textField.getText();
            if (s.length() == 0) {
                return null;
            }
            try {
                return Time.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                logger.debug(s, e);
                this.textField.setBorder(new LineBorder(Color.red));
                AsanDatabaseBrowser.theApp.showMessage(this.textField, "\u30c7\u30fc\u30bf\u5909\u63db\u30a8\u30e9\u30fc[" + s + "]", e, 0);
                return this.value;
            }
        }
    }

    static class DateEditor
    extends JSpreadCellEditor.DefaultCellEditor {
        DateEditor() {
        }

        public void setCellValue(Object value) {
            this.textField.setText(value == null ? "" : value.toString());
        }

        public Object getCellValue() {
            String s = this.textField.getText();
            if (s.length() == 0) {
                return null;
            }
            try {
                return Date.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                logger.debug(s, e);
                this.textField.setBorder(new LineBorder(Color.red));
                AsanDatabaseBrowser.theApp.showMessage(this.textField, "\u30c7\u30fc\u30bf\u5909\u63db\u30a8\u30e9\u30fc[" + s + "]", e, 0);
                return this.value;
            }
        }
    }

    class CellRenderer2
    extends JSpreadCellRenderer.DefaultCellRenderer {
        static final /* synthetic */ boolean $assertionsDisabled;

        CellRenderer2() {
        }

        public JComponent getSpreadCellRendererComponent(JSpread spread, Object value, boolean isSelected, boolean hasFocus, int rowDataIndex, int colDataIndex) {
            JLabel label = (JLabel)super.getSpreadCellRendererComponent(spread, value, isSelected, hasFocus, rowDataIndex, colDataIndex);
            ColumnInfo col = (ColumnInfo)DbTableView.this.data.tableInfo.getIColumnInfo(colDataIndex);
            if (!isSelected) {
                switch (DbTableView.this.data.getMode(rowDataIndex)) {
                    case -1: {
                        label.setBackground(Color.WHITE);
                        break;
                    }
                    case 0: {
                        label.setBackground(Color.YELLOW);
                        break;
                    }
                    case 1: {
                        label.setBackground(Color.GREEN);
                        break;
                    }
                    case 2: {
                        label.setBackground(Color.RED);
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError(DbTableView.this.data.getMode(rowDataIndex));
                        }
                        break;
                    }
                }
            }
            if (value == null) {
                label.setText("NULL");
                label.setForeground(Color.GRAY);
                label.setHorizontalAlignment(0);
                return label;
            }
            if (value instanceof Integer || value instanceof Long || value instanceof BigDecimal) {
                label.setForeground(Color.BLACK);
                label.setHorizontalAlignment(4);
                return label;
            }
            if (value instanceof WeakReference) {
                label.setText(col.typeName);
                label.setForeground(Color.BLACK);
                label.setHorizontalAlignment(0);
                return label;
            }
            label.setForeground(Color.BLACK);
            label.setHorizontalAlignment(2);
            return label;
        }

        static {
            $assertionsDisabled = !(class$asandatabasebrowser$view$DbTableView == null ? (class$asandatabasebrowser$view$DbTableView = DbTableView.class$("asandatabasebrowser.view.DbTableView")) : class$asandatabasebrowser$view$DbTableView).desiredAssertionStatus();
        }
    }
}

