/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.view;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.Global;
import asandatabasebrowser.action.AboutAction;
import asandatabasebrowser.action.AsanDebugAction;
import asandatabasebrowser.action.CloseAllFrameAction;
import asandatabasebrowser.action.CountListAction;
import asandatabasebrowser.action.CreateDdlAction;
import asandatabasebrowser.action.DatabaseAddAction;
import asandatabasebrowser.action.DatabaseConnectAction;
import asandatabasebrowser.action.DatabaseDeleteAction;
import asandatabasebrowser.action.DatabaseDisconnectAction;
import asandatabasebrowser.action.DatabaseMetadataAction;
import asandatabasebrowser.action.DatabasePropertyAction;
import asandatabasebrowser.action.DatabaseRefreshAction;
import asandatabasebrowser.action.EnterAction;
import asandatabasebrowser.action.ExitAction;
import asandatabasebrowser.action.NodeDownAction;
import asandatabasebrowser.action.NodeUpAction;
import asandatabasebrowser.action.OpenDatabaseDefinitionAction;
import asandatabasebrowser.action.OpenExecuteFrameAction;
import asandatabasebrowser.action.OpenSqlFrameAction;
import asandatabasebrowser.action.OpenTableAction;
import asandatabasebrowser.action.OpenTableDefinitionAction;
import asandatabasebrowser.action.OptionAction;
import asandatabasebrowser.action.SqlLogViewAction;
import asandatabasebrowser.model.FavoriteTable;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.DbTreeView;
import asandatabasebrowser.view.FavoriteTree;
import asandatabasebrowser.view.SqlLogView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.sourceforge.swingx.SxAction;

public class DbTreeFrame
extends JFrame {
    final AsanDatabaseBrowser tools;
    DbTreeView tree = null;
    public FavoriteTree favTree;
    public final JTabbedPane tab;
    Action databaseAddAction;
    Action databaseDeleteAction;
    public Action databaseConnectAction;
    Action databaseDisconnectAction;
    Action databasePropertyAction;
    Action databaseMetadataAction;
    Action databaseRefreshAction;
    Action exitAction;
    Action openSqlFrameAction;
    Action openExecuteFrameAction;
    public Action openTableAction;
    Action countListAction;
    Action closeAllFrameAction;
    Action sqlLogViewAction;
    Action optionAction;
    Action createDdlAction;
    Action enterAction;
    Action openTableDefinitionAction;
    Action openDatabaseDefinitionAction;
    SxAction nodeUpAction;
    SxAction nodeDownAction;

    public DbTreeFrame(AsanDatabaseBrowser tools) {
        super("AsanDatabaseBrowser");
        this.setIconImage(Global.getImage("/resources/database.png"));
        this.tools = tools;
        this.tree = new DbTreeView(tools);
        this.getContentPane().setLayout(new BorderLayout());
        this.tab = new JTabbedPane(3);
        this.tab.addTab("Database", Global.rootIcon, new JScrollPane(this.tree));
        this.favTree = new FavoriteTree(tools);
        this.tab.addTab("\u304a\u6c17\u306b\u5165\u308a", Global.favoriteIcon, new JScrollPane(this.favTree));
        this.getContentPane().add((Component)this.tab, "Center");
        this.databaseAddAction = new DatabaseAddAction(tools);
        this.databaseDeleteAction = new DatabaseDeleteAction(tools);
        this.databaseConnectAction = new DatabaseConnectAction(tools);
        this.databaseDisconnectAction = new DatabaseDisconnectAction(tools);
        this.databasePropertyAction = new DatabasePropertyAction(tools);
        this.databaseMetadataAction = new DatabaseMetadataAction(tools);
        this.databaseRefreshAction = new DatabaseRefreshAction(tools);
        this.exitAction = new ExitAction(tools);
        this.openSqlFrameAction = new OpenSqlFrameAction(tools);
        this.openExecuteFrameAction = new OpenExecuteFrameAction(tools, this.tree);
        this.openTableAction = new OpenTableAction(tools);
        this.countListAction = new CountListAction(tools);
        this.closeAllFrameAction = new CloseAllFrameAction(tools);
        this.sqlLogViewAction = new SqlLogViewAction();
        this.optionAction = new OptionAction(tools);
        this.createDdlAction = new CreateDdlAction(tools);
        this.enterAction = new EnterAction();
        this.openTableDefinitionAction = new OpenTableDefinitionAction(tools);
        this.openDatabaseDefinitionAction = new OpenDatabaseDefinitionAction(tools);
        this.nodeUpAction = new NodeUpAction();
        this.nodeDownAction = new NodeDownAction();
        JToolBar toolbar = new JToolBar("AsanDatabaseBrowser");
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        toolbar.add(this.databaseConnectAction);
        toolbar.add(this.databaseDisconnectAction);
        toolbar.addSeparator();
        toolbar.add(this.openTableAction);
        toolbar.add(this.openSqlFrameAction);
        toolbar.add(this.openExecuteFrameAction);
        toolbar.addSeparator();
        toolbar.add(this.nodeUpAction);
        toolbar.add(this.nodeDownAction);
        this.getContentPane().add((Component)toolbar, "North");
        JMenuBar menubar = new JMenuBar();
        JMenu databaseMenu = new JMenu("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9(D)");
        databaseMenu.setMnemonic('D');
        databaseMenu.add(this.databaseAddAction);
        databaseMenu.add(this.databaseDeleteAction);
        databaseMenu.addSeparator();
        databaseMenu.add(this.databaseConnectAction);
        databaseMenu.add(this.databaseDisconnectAction);
        databaseMenu.addSeparator();
        databaseMenu.add(this.databaseMetadataAction);
        databaseMenu.add(this.databasePropertyAction);
        databaseMenu.add(this.databaseRefreshAction);
        databaseMenu.addSeparator();
        databaseMenu.add(this.exitAction);
        menubar.add(databaseMenu);
        JMenu windowMenu = new JMenu("\u30a6\u30a3\u30f3\u30c9\u30a6(W)");
        windowMenu.setMnemonic('W');
        windowMenu.add(this.openTableAction);
        windowMenu.add(this.openSqlFrameAction);
        windowMenu.add(this.openExecuteFrameAction);
        windowMenu.addSeparator();
        windowMenu.add(new JCheckBoxMenuItem(this.sqlLogViewAction));
        windowMenu.addSeparator();
        windowMenu.add(this.closeAllFrameAction);
        windowMenu.addSeparator();
        windowMenu.add(this.optionAction);
        menubar.add(windowMenu);
        JMenu helpMenu = new JMenu("\u30d8\u30eb\u30d7(H)");
        helpMenu.setMnemonic('H');
        if (System.getProperty("debug") != null) {
            helpMenu.add(new AsanDebugAction());
            helpMenu.addSeparator();
        }
        helpMenu.add(new AboutAction(this));
        menubar.add(helpMenu);
        this.setJMenuBar(menubar);
        InputMap inputmap = this.tree.getInputMap();
        ActionMap actionmap = this.tree.getActionMap();
        inputmap.put(KeyStroke.getKeyStroke(10, 0), "enter");
        actionmap.put("enter", this.enterAction);
        inputmap = this.favTree.getInputMap();
        actionmap = this.favTree.getActionMap();
        actionmap.put("enter", this.enterAction);
        inputmap.put(KeyStroke.getKeyStroke(10, 0), "enter");
        this.setSize(300, 480);
        this.setVisible(true);
        this.tree.grabFocus();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AsanDatabaseBrowser.theApp.exitInstance();
            }

            public void windowDeiconified(WindowEvent e) {
                System.out.println("windowDeiconified() " + e);
                List list = AsanDatabaseBrowser.theApp.getFrameList();
                for (int i = 0; i < list.size(); ++i) {
                    JFrame frame = (JFrame)list.get(i);
                    frame.setExtendedState(0);
                }
                SqlLogView logView = AsanDatabaseBrowser.theApp.logView;
                if (logView.isVisible()) {
                    logView.setExtendedState(0);
                }
            }

            public void windowIconified(WindowEvent e) {
                System.out.println("windowIconified() " + e);
                List list = AsanDatabaseBrowser.theApp.getFrameList();
                for (int i = 0; i < list.size(); ++i) {
                    JFrame frame = (JFrame)list.get(i);
                    frame.setExtendedState(1);
                }
                SqlLogView logView = AsanDatabaseBrowser.theApp.logView;
                if (logView.isVisible()) {
                    logView.setExtendedState(1);
                }
            }
        });
        this.tab.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DbTreeFrame.this.updateMainFrame();
            }
        });
    }

    public DbTreeView getTree() {
        return this.tree;
    }

    public FavoriteTree getFavTree() {
        return this.favTree;
    }

    public void refresh() {
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.tree.updateUI();
        this.updateMainFrame();
    }

    public void updateMainFrame() {
        VvDatabase database = this.tree.getSelectedDatabase(true);
        if (this.tab.getSelectedIndex() == 0) {
            this.databaseAddAction.setEnabled(true);
            this.databaseDeleteAction.setEnabled(database != null && database.getConnection() == null);
            this.databaseConnectAction.setEnabled(database != null && database.getConnection() == null);
            this.databaseDisconnectAction.setEnabled(database != null && database.getConnection() != null);
            this.databasePropertyAction.setEnabled(database != null);
            this.databaseMetadataAction.setEnabled(database != null && database.getConnection() != null);
            this.databaseRefreshAction.setEnabled(database != null && database.getConnection() != null);
            TableInfo table = this.tree.getSelectedTableInfo();
            this.openTableAction.setEnabled(table != null);
            this.openSqlFrameAction.setEnabled(table != null);
            this.openExecuteFrameAction.setEnabled(database != null && database.getConnection() != null);
            this.openTableDefinitionAction.setEnabled(table != null);
            this.openDatabaseDefinitionAction.setEnabled(database != null && database.getConnection() != null);
            TreePath path = this.tree.getSelectionPath();
            this.countListAction.setEnabled(path != null && path.getPathCount() >= 3);
        } else {
            boolean isFavTable = this.favTree.getSelectionNodeObject() instanceof FavoriteTable;
            this.databaseAddAction.setEnabled(false);
            this.databaseDeleteAction.setEnabled(false);
            this.databaseConnectAction.setEnabled(false);
            this.databaseDisconnectAction.setEnabled(false);
            this.databasePropertyAction.setEnabled(false);
            this.databaseMetadataAction.setEnabled(false);
            this.databaseRefreshAction.setEnabled(false);
            this.openTableAction.setEnabled(isFavTable);
            this.openSqlFrameAction.setEnabled(isFavTable);
            this.openExecuteFrameAction.setEnabled(isFavTable);
            this.openTableDefinitionAction.setEnabled(isFavTable);
            this.openDatabaseDefinitionAction.setEnabled(isFavTable);
            this.countListAction.setEnabled(isFavTable);
        }
        this.nodeUpAction.updateStatus();
        this.nodeDownAction.updateStatus();
        this.closeAllFrameAction.setEnabled(this.tools.getFrameList().size() > 0);
        this.setTitle("AsanDatabaseBrowser" + (this.tools.doc.isModified() ? " *" : ""));
    }
}

