/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.view;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.Global;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.FavoriteGroup;
import asandatabasebrowser.model.FavoriteSQL;
import asandatabasebrowser.model.FavoriteTable;
import asandatabasebrowser.model.SchemaInfo;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.TableTypeInfo;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.model.VvDocument;
import asandatabasebrowser.view.DbTreeFrame;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DbTreeView
extends JTree {
    private static final int NODE_DEPTH_ROOT = 1;
    public static final int NODE_DEPTH_DB = 2;
    private static final int NODE_DEPTH_SCHEMA = 3;
    private static final int NODE_DEPTH_FOLDER = 4;
    private static final int NODE_DEPTH_TABLE = 5;
    AsanDatabaseBrowser dbTools;
    DefaultTreeModel model;
    DefaultMutableTreeNode root;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DbTreeView(AsanDatabaseBrowser dbTools) {
        if (!$assertionsDisabled && dbTools == null) {
            throw new AssertionError();
        }
        this.dbTools = dbTools;
        VvDocument doc = AsanDatabaseBrowser.theApp.doc;
        this.root = new DefaultMutableTreeNode("\u308b\u30fc\u3068");
        for (int i = 0; i < doc.databaseList.size(); ++i) {
            this.root.add(new DefaultMutableTreeNode(doc.databaseList.get(i)));
        }
        this.setCellRenderer(new CellRednerer());
        this.model = new DefaultTreeModel(this.root);
        this.setModel(this.model);
        this.setSelectionRow(0);
        this.addMouseListener(new TreeMouseListener(this));
        this.setToolTipText("\u3064\u308a\u30fc");
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DbTreeView.this.dbTools.getTreeFrame().updateMainFrame();
            }
        });
    }

    public void \u63a5\u7d9a\u3057\u305f\u306e\u3067\u679d\u3092\u4f5c\u308b(DefaultMutableTreeNode node, VvDatabase db) throws DbException {
        System.out.println("createDatabaseNodes()");
        VvDocument doc = AsanDatabaseBrowser.theApp.doc;
        ArrayList list = db.getSchemaInfoList();
        for (int i = 0; i < list.size(); ++i) {
            SchemaInfo schema = (SchemaInfo)list.get(i);
            DefaultMutableTreeNode schema_node = new DefaultMutableTreeNode(schema);
            this.model.insertNodeInto(schema_node, node, node.getChildCount());
            for (int k = 0; k < schema.getCount(); ++k) {
                TableTypeInfo type = schema.getTableTypeInfo(k);
                DefaultMutableTreeNode type_node = new DefaultMutableTreeNode(type);
                this.model.insertNodeInto(type_node, schema_node, schema_node.getChildCount());
                for (int j = 0; j < type.getCount(); ++j) {
                    TableInfo table = type.getTableInfo(j);
                    if (type.type.equals("TABLE") && db.hideOracleBinTable && table.getTableName().matches("^BIN\\$.*==\\$0$")) continue;
                    this.model.insertNodeInto(new DefaultMutableTreeNode(table), type_node, type_node.getChildCount());
                }
            }
        }
        int row = this.getRow(node);
        if (row != -1) {
            this.expandRow(row);
        }
    }

    public void \u5207\u65ad\u3057\u305f\u306e\u3067\u679d\u3092\u524a\u9664\u3059\u308b(DefaultMutableTreeNode node) {
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            this.model.removeNodeFromParent((DefaultMutableTreeNode)node.getChildAt(i));
        }
    }

    public void \u65b0\u3057\u3044\uff24\uff22\u3092\u8ffd\u52a0\u3059\u308b(VvDatabase db) {
        this.model.insertNodeInto(new DefaultMutableTreeNode(db), this.root, this.root.getChildCount());
    }

    public void \uff24\uff22\u3092\u524a\u9664\u3059\u308b(DefaultMutableTreeNode node) {
        this.model.removeNodeFromParent(node);
    }

    public void \u540d\u524d\u304c\u5909\u308f\u3063\u305f() {
        this.model.reload();
    }

    public String getToolTipText(MouseEvent e) {
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        switch (path.getPathCount()) {
            case 1: {
                return "<html>\u308b\u30fc\u3068</html>";
            }
            case 2: {
                VvDatabase db = (VvDatabase)node.getUserObject();
                return "<html>driver:<b>" + db.driverName + "</b><br>URL:<b>" + db.url + "</b><br>name:<b>" + db.user + "</b></html>";
            }
            case 3: {
                SchemaInfo schema = (SchemaInfo)node.getUserObject();
                return "<html>\u30b9\u30ad\u30fc\u30de:<b>" + schema.getSchemaName() + "</b><br>" + "\u30ab\u30bf\u30ed\u30b0:<b>" + schema.getCatalogName() + "</b>" + "</html>";
            }
            case 4: {
                TableTypeInfo type = (TableTypeInfo)node.getUserObject();
                return "<html>\u30bf\u30a4\u30d7:<b>" + type.type + "</b><br></html>";
            }
            case 5: {
                TableInfo info = (TableInfo)node.getUserObject();
                return "<html>\u30ab\u30bf\u30ed\u30b0:<b>" + info.getCatalogName() + "</b><br>" + "\u30b9\u30ad\u30fc\u30de:<b>" + info.getSchemaName() + "</b><br>" + "\u30c6\u30fc\u30d6\u30eb\u540d:<b><font color=\"BLUE\">" + info.getTableName() + "</font></b><br>" + "\u30bf\u30a4\u30d7:<b>" + info.getTableType() + "</b><br>" + "remarks:<b>" + info.getRemarks() + "</b>" + "</html>";
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError(path.getPathCount());
        }
        return "???";
    }

    public Object getSelectionNodeObject() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        return node.getUserObject();
    }

    public Object[] getSelectionNodeObjects() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            result.add(node.getUserObject());
        }
        return result.toArray(new Object[result.size()]);
    }

    public VvDatabase getSelectedDatabase(boolean searchParent) {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        if (path.getPathCount() <= 1) {
            return null;
        }
        if (!searchParent && path.getPathCount() != 2) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(1);
        VvDatabase db = (VvDatabase)node.getUserObject();
        return db;
    }

    public SchemaInfo getSelectedSchemaInfo() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        if (path.getPathCount() != 3) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        SchemaInfo info = (SchemaInfo)node.getUserObject();
        return info;
    }

    public TableInfo getSelectedTableInfo() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        if (path.getPathCount() != 5) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        TableInfo info = (TableInfo)node.getUserObject();
        return info;
    }

    public int getRow(DefaultMutableTreeNode node) {
        for (int r = 0; r < this.getRowCount(); ++r) {
            Object obj = this.getPathForRow(r).getLastPathComponent();
            if (obj != node) continue;
            return r;
        }
        return -1;
    }

    public ArrayList getAllNode(DefaultMutableTreeNode node) {
        if (!$assertionsDisabled && node == null) {
            throw new AssertionError();
        }
        ArrayList<DefaultMutableTreeNode> result = new ArrayList<DefaultMutableTreeNode>();
        result.add(node);
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)node.getChildAt(i);
            result.addAll(this.getAllNode(n));
        }
        return result;
    }

    public DefaultMutableTreeNode getNodeByUserObject(Object userObj) {
        if (!$assertionsDisabled && userObj == null) {
            throw new AssertionError();
        }
        ArrayList list = this.getAllNode(this.root);
        for (int i = 0; i < list.size(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)list.get(i);
            if (!userObj.equals(node.getUserObject())) continue;
            return node;
        }
        return null;
    }

    static {
        $assertionsDisabled = !DbTreeView.class.desiredAssertionStatus();
    }

    class SendFavTreeAction
    extends AbstractAction {
        FavoriteGroup group;

        SendFavTreeAction(FavoriteGroup g) {
            super(g.name, Global.groupIcon);
            this.group = g;
        }

        public void actionPerformed(ActionEvent e) {
            TreePath[] paths = DbTreeView.this.getSelectionPaths();
            for (int i = 0; i < paths.length; ++i) {
                if (paths[i].getPathCount() != 5) continue;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                TableInfo tableInfo = (TableInfo)node.getUserObject();
                FavoriteTable favtable = new FavoriteTable(tableInfo.getSqlTableName(), tableInfo.db.name, tableInfo.getCatalogName(), tableInfo.getSchemaName(), tableInfo.getTableName(), tableInfo.getTableType());
                this.group.add(favtable);
            }
            DbTreeView.this.dbTools.getTreeFrame().favTree.buildTree();
            DbTreeView.this.dbTools.doc.setModified(true);
            DbTreeView.this.dbTools.getTreeFrame().updateMainFrame();
        }
    }

    class TreeMouseListener
    extends MouseAdapter {
        DbTreeView tree;
        static final /* synthetic */ boolean $assertionsDisabled;

        TreeMouseListener(DbTreeView tree) {
            this.tree = tree;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && e.getButton() == 1) {
                TreePath selPath = DbTreeView.this.getPathForLocation(e.getX(), e.getY());
                if (selPath == null) {
                    return;
                }
                if (selPath.getPathCount() != 5) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                TableInfo table = (TableInfo)node.getUserObject();
                try {
                    DbTreeView.this.setCursor(Cursor.getPredefinedCursor(3));
                    DbTreeView.this.dbTools.openTableFrame(table);
                }
                catch (DbException ex) {
                    AsanDatabaseBrowser.theApp.showMessage(DbTreeView.this, "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u7167\u4f1a\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex, 0);
                }
                finally {
                    DbTreeView.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                DbTreeView.this.dbTools.getTreeFrame().updateMainFrame();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.mousePopup(e);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.mousePopup(e);
            }
        }

        void mousePopup(MouseEvent e) {
            TreePath selPath = DbTreeView.this.getPathForLocation(e.getX(), e.getY());
            if (selPath == null) {
                return;
            }
            TreePath[] selPaths = DbTreeView.this.getSelectionPaths();
            boolean contain = false;
            if (selPaths != null) {
                for (int i = 0; i < selPaths.length; ++i) {
                    if (selPaths[i] != selPath) continue;
                    contain = true;
                    break;
                }
            }
            if (!contain) {
                DbTreeView.this.setSelectionPath(selPath);
            }
            DbTreeFrame frame = DbTreeView.this.dbTools.getTreeFrame();
            switch (selPath.getPathCount()) {
                case 1: {
                    JPopupMenu popup = new JPopupMenu("\u307d\u3063\u3077\u3042\u3063\u3077");
                    popup.add(frame.databaseAddAction);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                    break;
                }
                case 2: {
                    JPopupMenu popup = new JPopupMenu("\u307d\u3063\u3077\u3042\u3063\u3077");
                    popup.add(frame.databaseConnectAction);
                    popup.add(frame.databaseDisconnectAction);
                    popup.addSeparator();
                    popup.add(frame.databaseMetadataAction);
                    popup.add(frame.openDatabaseDefinitionAction);
                    popup.addSeparator();
                    popup.add(frame.databaseRefreshAction);
                    popup.addSeparator();
                    popup.add(frame.databaseDeleteAction);
                    popup.add(frame.databasePropertyAction);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                    break;
                }
                case 3: {
                    JPopupMenu popup = new JPopupMenu("\u307d\u3063\u3077\u3042\u3063\u3077");
                    popup.add(frame.countListAction);
                    popup.addSeparator();
                    popup.add(frame.createDdlAction);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                    break;
                }
                case 4: {
                    JPopupMenu popup = new JPopupMenu("\u307d\u3063\u3077\u3042\u3063\u3077");
                    popup.add(frame.countListAction);
                    popup.addSeparator();
                    popup.add(frame.createDdlAction);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                    break;
                }
                case 5: {
                    JPopupMenu popup = new JPopupMenu("\u307d\u3063\u3077\u3042\u3063\u3077");
                    popup.add(frame.openTableAction);
                    popup.add(frame.openSqlFrameAction);
                    popup.add(frame.openExecuteFrameAction);
                    popup.addSeparator();
                    JMenu sendFav = new JMenu("\u304a\u6c17\u306b\u5165\u308a\u306b\u9001\u308b");
                    sendFav.setIcon(Global.favoriteIcon);
                    if (DbTreeView.this.dbTools.doc.favList.size() > 0) {
                        for (int i = 0; i < DbTreeView.this.dbTools.doc.favList.size(); ++i) {
                            FavoriteGroup g = (FavoriteGroup)DbTreeView.this.dbTools.doc.favList.get(i);
                            sendFav.add(new JMenuItem(new SendFavTreeAction(g)));
                        }
                    } else {
                        JMenuItem menu = new JMenuItem("\u304a\u6c17\u306b\u5165\u308a\u306b\u30b0\u30eb\u30fc\u30d7\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u307e\u305a\u306f\u304a\u6c17\u306b\u5165\u308a\u30bf\u30d6\u3067\u30b0\u30eb\u30fc\u30d7\u3092\u4f5c\u6210\u3057\u3066\u304f\u3060\u3055\u3044");
                        menu.setEnabled(false);
                        sendFav.add(menu);
                    }
                    popup.add(sendFav);
                    popup.addSeparator();
                    popup.add(frame.countListAction);
                    popup.add(frame.openTableDefinitionAction);
                    popup.add(frame.openDatabaseDefinitionAction);
                    popup.add(frame.createDdlAction);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                    break;
                }
                default: {
                    System.out.println("getPathCount()=" + selPath.getPathCount());
                    if (!$assertionsDisabled) {
                        throw new AssertionError(selPath.getPathCount());
                    }
                    break;
                }
            }
        }

        static {
            $assertionsDisabled = !(class$asandatabasebrowser$view$DbTreeView == null ? (class$asandatabasebrowser$view$DbTreeView = DbTreeView.class$("asandatabasebrowser.view.DbTreeView")) : class$asandatabasebrowser$view$DbTreeView).desiredAssertionStatus();
        }
    }

    static class CellRednerer
    extends DefaultTreeCellRenderer {
        CellRednerer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            JLabel label = (JLabel)c;
            if (value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object obj = node.getUserObject();
                if (obj instanceof String) {
                    if (obj.equals("\u308b\u30fc\u3068")) {
                        label.setIcon(Global.rootIcon);
                    } else if (obj.equals("\u304a\u6c17\u306b\u5165\u308a")) {
                        label.setIcon(Global.favoriteIcon);
                    }
                } else if (obj instanceof VvDatabase) {
                    VvDatabase db = (VvDatabase)obj;
                    if (db.getConnection() != null) {
                        label.setIcon(Global.databaseIcon);
                    } else {
                        label.setIcon(Global.databaseOffIcon);
                    }
                } else if (obj instanceof SchemaInfo) {
                    label.setIcon(Global.schemaIcon);
                } else if (obj instanceof TableTypeInfo) {
                    TableTypeInfo type = (TableTypeInfo)obj;
                    label.setText(type.type);
                } else if (obj instanceof TableInfo) {
                    TableInfo info = (TableInfo)obj;
                    String text = value.toString();
                    if (info.getRemarks() != null && info.getRemarks().length() > 0) {
                        text = text + "(" + info.getRemarks() + ")";
                    }
                    label.setText(text);
                    String type = info.getTableType();
                    if (type.equals("TABLE")) {
                        label.setIcon(Global.tableIcon);
                    } else if (type.equals("VIEW")) {
                        label.setIcon(Global.viewIcon);
                    } else if (type.equals("SYSTEM TABLE")) {
                        label.setIcon(Global.systemTableIcon);
                    } else if (type.equals("GLOBAL TEMPORARY")) {
                        label.setIcon(Global.globalTemporaryIcon);
                    } else if (type.equals("LOCAL TEMPORARY")) {
                        label.setIcon(Global.localTemporaryIcon);
                    } else if (type.equals("ALIAS")) {
                        label.setIcon(Global.aliasIcon);
                    } else if (type.equals("SYNONYM")) {
                        label.setIcon(Global.synonymIcon);
                    } else {
                        label.setIcon(Global.unknownIcon);
                    }
                } else if (obj instanceof FavoriteTable) {
                    FavoriteTable fav = (FavoriteTable)obj;
                    label.setText(fav.name);
                    String type = fav.tableType;
                    if (type.equals("TABLE")) {
                        label.setIcon(Global.favTableIcon);
                    } else if (type.equals("VIEW")) {
                        label.setIcon(Global.viewIcon);
                    } else if (type.equals("SYSTEM TABLE")) {
                        label.setIcon(Global.systemTableIcon);
                    } else if (type.equals("GLOBAL TEMPORARY")) {
                        label.setIcon(Global.globalTemporaryIcon);
                    } else if (type.equals("LOCAL TEMPORARY")) {
                        label.setIcon(Global.localTemporaryIcon);
                    } else if (type.equals("ALIAS")) {
                        label.setIcon(Global.aliasIcon);
                    } else if (type.equals("SYNONYM")) {
                        label.setIcon(Global.synonymIcon);
                    } else {
                        label.setIcon(Global.unknownIcon);
                    }
                } else if (obj instanceof FavoriteSQL) {
                    FavoriteSQL favSql = (FavoriteSQL)obj;
                    label.setText(favSql.name);
                    label.setIcon(Global.favSqlIcon);
                } else if (obj instanceof FavoriteGroup) {
                    FavoriteGroup group = (FavoriteGroup)obj;
                    label.setText(group.name);
                    label.setIcon(Global.groupIcon);
                } else {
                    System.out.println("value=" + value + " class=" + value.getClass());
                }
            }
            return c;
        }
    }
}

