/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.view;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.Global;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.FavoriteGroup;
import asandatabasebrowser.model.FavoriteSQL;
import asandatabasebrowser.model.FavoriteTable;
import asandatabasebrowser.model.IFavorite;
import asandatabasebrowser.model.SchemaInfo;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.DbTreeFrame;
import asandatabasebrowser.view.DbTreeView;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.sourceforge.swingx.SxTextUtilities;

public class FavoriteTree
extends JTree {
    AsanDatabaseBrowser tools;
    DefaultMutableTreeNode root = new DefaultMutableTreeNode("\u304a\u6c17\u306b\u5165\u308a");
    private DbTreeView.CellRednerer renderer = new DbTreeView.CellRednerer();
    static final /* synthetic */ boolean $assertionsDisabled;

    public FavoriteTree(AsanDatabaseBrowser tools) {
        if (!$assertionsDisabled && tools == null) {
            throw new AssertionError();
        }
        this.tools = tools;
        this.setToolTipText("\u3064\u308a\u30fc");
        this.setCellRenderer(this.renderer);
        this.setCellEditor(new FavTreeCellEditor((DefaultTreeCellRenderer)this.renderer));
        this.setEditable(true);
        this.setModel(new DefaultTreeModel(this.root));
        this.addMouseListener(new FavListMouseListener(this));
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                FavoriteTree.this.tools.getTreeFrame().updateMainFrame();
            }
        });
        this.buildTree();
    }

    public void buildTree() {
        this.root.removeAllChildren();
        ArrayList favList = this.tools.doc.favList;
        for (int i = 0; i < favList.size(); ++i) {
            FavoriteGroup g = (FavoriteGroup)favList.get(i);
            DefaultMutableTreeNode group = new DefaultMutableTreeNode(g);
            this.root.add(group);
            for (int j = 0; j < g.list.size(); ++j) {
                IFavorite t = g.get(j);
                group.add(new DefaultMutableTreeNode(t, false));
            }
        }
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.reload();
        this.expandRow(0);
    }

    public String getToolTipText(MouseEvent e) {
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object obj = node.getUserObject();
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof FavoriteGroup) {
            FavoriteGroup group = (FavoriteGroup)obj;
            return group.name;
        }
        if (obj instanceof FavoriteTable) {
            FavoriteTable fav = (FavoriteTable)obj;
            return "<html>DB:<b>" + fav.dbName + "</b><br>" + "\u30ab\u30bf\u30ed\u30b0:<b>" + fav.tableCatalog + "</b><br>" + "\u30b9\u30ad\u30fc\u30de:<b>" + fav.tableSchema + "</b><br>" + "\u30c6\u30fc\u30d6\u30eb\u540d:<b><font color=\"BLUE\">" + fav.tableName + "</font></b><br>" + "\u30bf\u30a4\u30d7:<b>" + fav.tableType + "</b><br>" + "</html>";
        }
        if (obj instanceof FavoriteSQL) {
            FavoriteSQL sql = (FavoriteSQL)obj;
            return sql.name;
        }
        return "?";
    }

    public Object getSelectionNodeObject() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        return node.getUserObject();
    }

    public Object[] getSelectionNodeObjects() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            result.add(node.getUserObject());
        }
        return result.toArray(new Object[result.size()]);
    }

    public ArrayList getAllNode(DefaultMutableTreeNode node) {
        if (!$assertionsDisabled && node == null) {
            throw new AssertionError();
        }
        ArrayList<DefaultMutableTreeNode> result = new ArrayList<DefaultMutableTreeNode>();
        result.add(node);
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)node.getChildAt(i);
            result.addAll(this.getAllNode(n));
        }
        return result;
    }

    public DefaultMutableTreeNode getNodeByUserObject(Object userObj) {
        if (!$assertionsDisabled && userObj == null) {
            throw new AssertionError();
        }
        ArrayList list = this.getAllNode(this.root);
        for (int i = 0; i < list.size(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)list.get(i);
            if (!userObj.equals(node.getUserObject())) continue;
            return node;
        }
        return null;
    }

    public int getRow(DefaultMutableTreeNode node) {
        for (int r = 0; r < this.getRowCount(); ++r) {
            Object obj = this.getPathForRow(r).getLastPathComponent();
            if (obj != node) continue;
            return r;
        }
        return -1;
    }

    public boolean isPathEditable(TreePath path) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        return node.getUserObject() instanceof FavoriteGroup || node.getUserObject() instanceof FavoriteTable;
    }

    public void startEditingAtPath(TreePath path) {
        System.out.println("startEditingAtPath()" + path);
        super.startEditingAtPath(path);
    }

    public boolean stopEditing() {
        System.out.println("stopEditing()");
        return super.stopEditing();
    }

    static {
        $assertionsDisabled = !FavoriteTree.class.desiredAssertionStatus();
    }

    class RemoveFavGroupAction
    extends AbstractAction {
        FavoriteGroup group;

        RemoveFavGroupAction(FavoriteGroup group) {
            super("\u304a\u6c17\u306b\u5165\u308a\u306e\u30b0\u30eb\u30fc\u30d7\u306e\u524a\u9664 ...");
            this.group = group;
        }

        public void actionPerformed(ActionEvent e) {
            int rc = JOptionPane.showConfirmDialog(FavoriteTree.this.tools.getTreeFrame(), "\u672c\u5f53\u306b\u6d88\u3057\u3066\u3044\u3044\uff1f\n" + this.group.name, "\u304a\u6c17\u306b\u5165\u308a\u306e\u524a\u9664", 0);
            if (rc != 0) {
                return;
            }
            if (this.group.list.size() > 0 && (rc = JOptionPane.showConfirmDialog(FavoriteTree.this.tools.getTreeFrame(), "\u307e\u3060\u3001\u4e2d\u8eab\u306b\u304a\u6c17\u306b\u5165\u308a\u304c\u3042\u308b\u3088\u3002\n\u672c\u5f53\u306b\u6d88\u3057\u3066\u3044\u3044\u306e\uff1f\uff1f\uff1f\n" + this.group.name, "\u304a\u6c17\u306b\u5165\u308a\u306e\u524a\u9664", 0)) != 0) {
                return;
            }
            FavoriteTree.this.tools.doc.favList.remove(this.group);
            FavoriteTree.this.tools.getTreeFrame().favTree.buildTree();
            FavoriteTree.this.tools.doc.setModified(true);
            FavoriteTree.this.tools.getTreeFrame().updateMainFrame();
        }
    }

    class RemoveFavTableAction
    extends AbstractAction {
        FavoriteGroup group;
        FavoriteTable table;

        RemoveFavTableAction(FavoriteGroup group, FavoriteTable table) {
            super("\u304a\u6c17\u306b\u5165\u308a\u306e\u524a\u9664 ...");
            this.group = group;
            this.table = table;
        }

        public void actionPerformed(ActionEvent e) {
            TreePath[] paths = FavoriteTree.this.getSelectionPaths();
            if (paths == null || paths.length == 0) {
                return;
            }
            ArrayList<DefaultMutableTreeNode> list = new ArrayList<DefaultMutableTreeNode>();
            String message = "\u672c\u5f53\u306b\u6d88\u3057\u3066\u3044\u3044\uff1f";
            for (int i = 0; i < paths.length; ++i) {
                TreePath path = paths[i];
                if (path.getPathCount() != 3) continue;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                list.add(node);
                FavoriteTable table = (FavoriteTable)node.getUserObject();
                message = message + "\n" + table.name;
            }
            if (list.size() == 0) {
                FavoriteTree.this.tools.showMessage(FavoriteTree.this, "\u304a\u6c17\u306b\u5165\u308a\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093", null, 0);
                return;
            }
            int rc = JOptionPane.showConfirmDialog(FavoriteTree.this.tools.getTreeFrame(), message, "\u304a\u6c17\u306b\u5165\u308a\u306e\u524a\u9664", 0);
            if (rc != 0) {
                return;
            }
            DefaultTreeModel model = (DefaultTreeModel)FavoriteTree.this.getModel();
            for (int i = 0; i < list.size(); ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)list.get(i);
                DefaultMutableTreeNode gnode = (DefaultMutableTreeNode)node.getParent();
                FavoriteGroup group = (FavoriteGroup)gnode.getUserObject();
                FavoriteTable table = (FavoriteTable)node.getUserObject();
                group.list.remove(table);
                model.removeNodeFromParent(node);
            }
            model.reload();
            FavoriteTree.this.tools.doc.setModified(true);
            FavoriteTree.this.tools.getTreeFrame().updateMainFrame();
        }
    }

    class MoveFavTreeAction
    extends AbstractAction {
        FavoriteTable favTable;
        FavoriteGroup srcgroup;
        FavoriteGroup dstgroup;

        MoveFavTreeAction(FavoriteGroup srcg, FavoriteGroup dstg, FavoriteTable favTable) {
            super(dstg.name, Global.groupIcon);
            this.srcgroup = srcg;
            this.dstgroup = dstg;
            this.favTable = favTable;
            this.setEnabled(!this.srcgroup.equals(this.dstgroup));
        }

        public void actionPerformed(ActionEvent e) {
            this.srcgroup.list.remove(this.favTable);
            this.dstgroup.add(this.favTable);
            FavoriteTree.this.tools.getTreeFrame().favTree.buildTree();
            FavoriteTree.this.tools.doc.setModified(true);
            FavoriteTree.this.tools.getTreeFrame().updateMainFrame();
        }
    }

    class CreateGroupAction
    extends AbstractAction {
        CreateGroupAction() {
            super("\u65b0\u3057\u3044\u30b0\u30eb\u30fc\u30d7\u306e\u4f5c\u6210", Global.groupIcon);
        }

        public void actionPerformed(ActionEvent e) {
            FavoriteGroup group = new FavoriteGroup("newGroup");
            FavoriteTree.this.tools.doc.favList.add(group);
            DefaultTreeModel model = (DefaultTreeModel)FavoriteTree.this.getModel();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)model.getRoot();
            DefaultMutableTreeNode new_node = new DefaultMutableTreeNode(group);
            model.insertNodeInto(new_node, parent, parent.getChildCount());
            model.reload();
        }
    }

    class FavListMouseListener
    extends MouseAdapter {
        FavoriteTree tree;
        static final /* synthetic */ boolean $assertionsDisabled;

        FavListMouseListener(FavoriteTree tree) {
            this.tree = tree;
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && (e.getModifiers() & 0x10) != 0) {
                TreePath selPath = FavoriteTree.this.getPathForLocation(e.getX(), e.getY());
                if (selPath == null) {
                    return;
                }
                Object leaf = selPath.getLastPathComponent();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)leaf;
                Object userObject = node.getUserObject();
                if (userObject instanceof FavoriteTable) {
                    FavoriteTable fav = (FavoriteTable)userObject;
                    System.out.println(node);
                    VvDatabase db = null;
                    for (int i = 0; i < AsanDatabaseBrowser.theApp.doc.databaseList.size(); ++i) {
                        VvDatabase d = (VvDatabase)AsanDatabaseBrowser.theApp.doc.databaseList.get(i);
                        if (!d.name.equals(fav.dbName)) continue;
                        db = d;
                        break;
                    }
                    if (db == null) {
                        return;
                    }
                    Connection conn = db.getConnection();
                    if (conn == null) {
                        try {
                            FavoriteTree.this.tools.connect(db);
                            conn = db.getConnection();
                            if (!$assertionsDisabled && conn == null) {
                                throw new AssertionError();
                            }
                            DbTreeView dbtree = FavoriteTree.this.tools.getTreeFrame().getTree();
                            DefaultMutableTreeNode dbnode = dbtree.getNodeByUserObject(db);
                            dbtree.\u63a5\u7d9a\u3057\u305f\u306e\u3067\u679d\u3092\u4f5c\u308b(dbnode, db);
                        }
                        catch (DbException e1) {
                            FavoriteTree.this.tools.showMessage(this.tree, "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e1, 0);
                            return;
                        }
                    }
                    try {
                        SchemaInfo schema = null;
                        ArrayList list = db.getSchemaInfoList();
                        for (int i = 0; i < list.size(); ++i) {
                            SchemaInfo s = (SchemaInfo)list.get(i);
                            if (!SxTextUtilities.equalsString(fav.tableCatalog, s.getCatalogName()) || !SxTextUtilities.equalsString(fav.tableSchema, s.getSchemaName())) continue;
                            schema = s;
                            break;
                        }
                        if (schema == null) {
                            throw new DbException("\u305d\u306e\u3088\u3046\u306a\u30ab\u30bf\u30ed\u30b0/\u30b9\u30ad\u30fc\u30de\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002catalog=" + fav.tableCatalog + " schema=" + fav.tableSchema);
                        }
                        TableInfo table = schema.getTableTypeInfo(fav.tableType).getTableInfo(fav.tableName);
                        FavoriteTree.this.tools.openTableFrame(table);
                    }
                    catch (DbException ex) {
                        FavoriteTree.this.tools.showMessage(this.tree, "\u30c6\u30fc\u30d6\u30eb\u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093", ex, 0);
                    }
                } else if (userObject instanceof FavoriteSQL) {
                    FavoriteSQL fav = (FavoriteSQL)userObject;
                    System.out.println(node);
                    VvDatabase db = null;
                    for (int i = 0; i < AsanDatabaseBrowser.theApp.doc.databaseList.size(); ++i) {
                        VvDatabase d = (VvDatabase)AsanDatabaseBrowser.theApp.doc.databaseList.get(i);
                        if (!d.name.equals(fav.dbName)) continue;
                        db = d;
                        break;
                    }
                    if (db == null) {
                        return;
                    }
                    Connection conn = db.getConnection();
                    if (conn == null) {
                        try {
                            FavoriteTree.this.tools.connect(db);
                            conn = db.getConnection();
                            if (!$assertionsDisabled && conn == null) {
                                throw new AssertionError();
                            }
                            DbTreeView dbtree = FavoriteTree.this.tools.getTreeFrame().getTree();
                            DefaultMutableTreeNode dbnode = dbtree.getNodeByUserObject(db);
                            dbtree.\u63a5\u7d9a\u3057\u305f\u306e\u3067\u679d\u3092\u4f5c\u308b(dbnode, db);
                        }
                        catch (DbException e1) {
                            FavoriteTree.this.tools.showMessage(this.tree, "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e1, 0);
                            return;
                        }
                    }
                    try {
                        FavoriteTree.this.tools.openSqlFrame(db, fav);
                    }
                    catch (DbException ex) {
                        FavoriteTree.this.tools.showMessage(this.tree, "\u30c6\u30fc\u30d6\u30eb\u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093", ex, 0);
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.mousePopup(e);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.mousePopup(e);
            }
        }

        void mousePopup(MouseEvent e) {
            TreePath selPath = FavoriteTree.this.getPathForLocation(e.getX(), e.getY());
            if (selPath == null) {
                return;
            }
            TreePath[] selPaths = FavoriteTree.this.getSelectionPaths();
            boolean contain = false;
            for (int i = 0; i < selPaths.length; ++i) {
                if (selPaths[i] != selPath) continue;
                contain = true;
                break;
            }
            System.out.println("contain=" + contain);
            if (!contain) {
                FavoriteTree.this.setSelectionPath(selPath);
            }
            DbTreeFrame frame = FavoriteTree.this.tools.getTreeFrame();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            Object obj = node.getUserObject();
            if (obj instanceof FavoriteTable) {
                JPopupMenu popup = new JPopupMenu("\u307d\u3063\u3077\u3042\u3063\u3077");
                popup.add(frame.openTableAction);
                popup.add(frame.openSqlFrameAction);
                popup.add(frame.openExecuteFrameAction);
                popup.addSeparator();
                JMenu sendFav = new JMenu("\u304a\u6c17\u306b\u5165\u308a\u306b\u9001\u308b");
                sendFav.setIcon(Global.favoriteIcon);
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                FavoriteGroup srcg = (FavoriteGroup)parent.getUserObject();
                FavoriteTable favTable = (FavoriteTable)node.getUserObject();
                for (int i = 0; i < FavoriteTree.this.tools.doc.favList.size(); ++i) {
                    FavoriteGroup dstg = (FavoriteGroup)FavoriteTree.this.tools.doc.favList.get(i);
                    sendFav.add(new JMenuItem(new MoveFavTreeAction(srcg, dstg, favTable)));
                }
                popup.add(sendFav);
                popup.add(new RemoveFavTableAction(srcg, favTable));
                popup.addSeparator();
                popup.add(frame.countListAction);
                popup.add(frame.openTableDefinitionAction);
                popup.add(frame.openDatabaseDefinitionAction);
                popup.add(frame.createDdlAction);
                popup.show(e.getComponent(), e.getX(), e.getY());
            } else if (obj instanceof String && obj.equals("\u304a\u6c17\u306b\u5165\u308a")) {
                JPopupMenu popup = new JPopupMenu("\u307d\u3063\u3077\u3042\u3063\u3077");
                popup.add(new CreateGroupAction());
                popup.show(e.getComponent(), e.getX(), e.getY());
            } else if (obj instanceof FavoriteGroup) {
                FavoriteGroup group = (FavoriteGroup)obj;
                JPopupMenu popup = new JPopupMenu("\u307d\u3063\u3077\u3042\u3063\u3077");
                popup.add(new RemoveFavGroupAction(group));
                popup.add(frame.countListAction);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        static {
            $assertionsDisabled = !(class$asandatabasebrowser$view$FavoriteTree == null ? (class$asandatabasebrowser$view$FavoriteTree = FavoriteTree.class$("asandatabasebrowser.view.FavoriteTree")) : class$asandatabasebrowser$view$FavoriteTree).desiredAssertionStatus();
        }
    }

    class FavTreeCellEditor
    extends DefaultTreeCellEditor {
        DefaultMutableTreeNode node;
        static final /* synthetic */ boolean $assertionsDisabled;

        FavTreeCellEditor(DefaultTreeCellRenderer renderer) {
            super(FavoriteTree.this, renderer);
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.node = (DefaultMutableTreeNode)value;
            Object obj = this.node.getUserObject();
            String name = null;
            if (obj instanceof FavoriteGroup) {
                name = ((FavoriteGroup)obj).name;
            } else if (obj instanceof FavoriteTable) {
                name = ((FavoriteTable)obj).name;
            } else if (!$assertionsDisabled) {
                throw new AssertionError(obj.getClass());
            }
            Component comp = super.getTreeCellEditorComponent(tree, name, isSelected, expanded, leaf, row);
            System.out.println(comp);
            return comp;
        }

        public Object getCellEditorValue() {
            Object value = super.getCellEditorValue();
            System.out.println(value);
            Object obj = this.node.getUserObject();
            if (obj instanceof FavoriteGroup) {
                ((FavoriteGroup)obj).name = (String)value;
            } else if (obj instanceof FavoriteTable) {
                ((FavoriteTable)obj).name = (String)value;
            } else if (!$assertionsDisabled) {
                throw new AssertionError(obj.getClass());
            }
            FavoriteTree.this.tools.doc.setModified(true);
            FavoriteTree.this.tools.getTreeFrame().updateMainFrame();
            return obj;
        }

        static {
            $assertionsDisabled = !(class$asandatabasebrowser$view$FavoriteTree == null ? (class$asandatabasebrowser$view$FavoriteTree = FavoriteTree.class$("asandatabasebrowser.view.FavoriteTree")) : class$asandatabasebrowser$view$FavoriteTree).desiredAssertionStatus();
        }
    }
}

