/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.view;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.SqlEditor;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import net.sourceforge.swingx.SxOptionPane;

public class JTabbedTextArea
extends JTabbedPane {
    int count = 0;
    VvDatabase db;
    KeyListener keyListener;

    JTabbedTextArea(VvDatabase db, KeyListener keyListener) {
        super(1, 1);
        this.db = db;
        this.keyListener = keyListener;
        this.addMouseListener(new TabMouseListener());
    }

    public String getCurrentText() {
        if (this.getTabCount() == 0) {
            return null;
        }
        JScrollPane scroll = (JScrollPane)this.getSelectedComponent();
        JTextPane textarea = (JTextPane)scroll.getViewport().getView();
        return textarea.getText();
    }

    String getSelectedText() {
        JScrollPane scroll = (JScrollPane)this.getSelectedComponent();
        JTextPane textarea = (JTextPane)scroll.getViewport().getView();
        return textarea.getSelectedText();
    }

    public String getText(int index) {
        JScrollPane scroll = (JScrollPane)this.getComponentAt(index);
        JTextPane area = (JTextPane)scroll.getViewport().getView();
        return area.getText();
    }

    public void addTextArea(String sql) {
        SqlEditor editor = new SqlEditor(sql, this.db.getBlancoSqlRule(), AsanDatabaseBrowser.theApp.doc.getFont());
        if (System.getProperty("debug") != null) {
            editor.setToolTipText("<html>Shift+Enter\u3067SQL\u3092\u5b9f\u884c\u3057\u307e\u3059\u3002<br>\u672b\u5c3e\u306b\u30bb\u30df\u30b3\u30ed\u30f3\u306f\u4e0d\u8981\u3067\u3059\u3002</html>");
        }
        editor.addKeyListener(this.keyListener);
        this.addTab("SQL" + this.count, new JScrollPane(editor));
        this.setSelectedIndex(this.getTabCount() - 1);
        ++this.count;
    }

    public void removeTextArea() {
        if (this.getTabCount() <= 1) {
            return;
        }
        this.removeTabAt(this.getSelectedIndex());
    }

    class TabMouseListener
    extends MouseAdapter {
        TabMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            System.out.println(e);
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                int index = JTabbedTextArea.this.indexAtLocation(e.getX(), e.getY());
                if (index == -1) {
                    return;
                }
                JTextField field = new JTextField(JTabbedTextArea.this.getTitleAt(index), 10);
                int rc = SxOptionPane.showMessageDialog(JTabbedTextArea.this, field, "\u30bf\u30d6\u540d\u306e\u7de8\u96c6", 3, -1, null);
                if (rc != 1) {
                    return;
                }
                String text = field.getText();
                if (text.length() == 0) {
                    SxOptionPane.showMessageDialog(JTabbedTextArea.this, "1\u6587\u5b57\u4ee5\u4e0a\u306e\u6587\u5b57\u5217\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002", "\u30bf\u30d6\u540d\u306e\u7de8\u96c6", 1, 0, null);
                    return;
                }
                JTabbedTextArea.this.setTitleAt(index, text);
            }
        }
    }
}

