/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.view;

import asandatabasebrowser.Global;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class RitchTable
extends JTable {
    public RitchTable() {
        this.init();
    }

    public RitchTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.init();
    }

    void init() {
        ActionMap actionmap = new ActionMap();
        actionmap.put("copy", new CopyClipboardAction(this));
        actionmap.put("select-all", new SelectAllAction(this));
        SwingUtilities.replaceUIActionMap(this, actionmap);
        InputMap inputmap = new InputMap();
        inputmap.put(KeyStroke.getKeyStroke(67, 2), "copy");
        inputmap.put(KeyStroke.getKeyStroke(65, 2), "select-all");
        SwingUtilities.replaceUIInputMap(this, 0, inputmap);
    }

    public class SelectAllAction
    extends AbstractAction {
        JTable table;

        public SelectAllAction(JTable table) {
            super("\u3059\u3079\u3066\u3092\u9078\u629e(A)");
            this.putValue("MnemonicKey", new Integer(65));
            this.putValue("ShortDescription", "\u5168\u9078\u629e");
            this.putValue("LongDescription", "\u5168\u9078\u629e");
            this.table = table;
        }

        public void actionPerformed(ActionEvent ev) {
            System.out.println("SelectAllAction");
            this.table.selectAll();
        }
    }

    class CopyClipboardAction
    extends AbstractAction {
        JTable table;

        public CopyClipboardAction(JTable table) {
            super("\u30b3\u30d4\u30fc(C)");
            this.putValue("ShortDescription", "\u30b3\u30d4\u30fc");
            this.putValue("LongDescription", "\u30b3\u30d4\u30fc");
            this.putValue("MnemonicKey", new Integer(67));
            this.putValue("SmallIcon", Global.getImageIcon("/resources/eclipse_EditCopy.png"));
            this.table = table;
        }

        public void actionPerformed(ActionEvent ev) {
            System.out.println("CopyClipboardAction");
            String data = "";
            int[] cols = this.table.getSelectedColumns();
            int[] rows = this.table.getSelectedRows();
            for (int row = 0; row < rows.length; ++row) {
                String line = null;
                for (int col = 0; col < cols.length; ++col) {
                    if (!this.table.isCellSelected(rows[row], cols[col])) continue;
                    Object val = this.table.getValueAt(rows[row], cols[col]);
                    line = line == null ? "" + val : line + "\t" + val;
                    System.out.println(val);
                }
                data = data + line + "\n";
            }
            StringSelection ss = new StringSelection(data);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
        }
    }
}

