/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.view;

import asandatabasebrowser.Global;
import asandatabasebrowser.action.SqlExcludeCommentAction;
import asandatabasebrowser.action.SqlFormatAction;
import asandatabasebrowser.action.SqlUnformatAction;
import blanco.commons.sql.format.BlancoSqlConstants;
import blanco.commons.sql.format.BlancoSqlParser;
import blanco.commons.sql.format.BlancoSqlRule;
import blanco.commons.sql.format.valueobject.BlancoSqlToken;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import net.sourceforge.swingx.SxAction;
import net.sourceforge.swingx.SxMouseAdapter;
import net.sourceforge.swingx.SxTextUtilities;
import net.sourceforge.swingx.SxUtilities;

public class SqlEditor
extends JTextPane {
    static final int TAB_SIZE = 4;
    BlancoSqlParser fParser = new BlancoSqlParser();
    static SimpleAttributeSet PLANE;
    static SimpleAttributeSet KEYWORD;
    static SimpleAttributeSet COMMENT;
    static SimpleAttributeSet VALUE;
    static SimpleAttributeSet NAME;
    static SimpleAttributeSet SQL89;
    static SimpleAttributeSet SQL92;
    static SimpleAttributeSet SQL99;
    static SimpleAttributeSet SQL_FAMOUS;
    static SimpleAttributeSet UNKNOWN;
    BlancoSqlRule rule;
    UndoManager undoManager = new UndoManager();
    RedoAction redoAction;
    UndoAction undoAction;
    SqlFormatAction sqlFormatAction;
    SqlCommentAction sqlCommentAction;
    SqlCommentAddAction sqlCommentAddAction;
    SqlCommentDeleteAction sqlCommentDeleteAction;
    SqlUnformatAction sqlUnformatAction;
    SqlExcludeCommentAction sqlExcludeCommentAction;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SqlEditor(String sql, BlancoSqlRule rule, Font font) {
        Action act_selall;
        Action act_paste;
        Action act_copy;
        this.rule = rule;
        this.setText(sql);
        this.setFont(font);
        this.selectAll();
        ActionMap amap = this.getActionMap();
        this.redoAction = new RedoAction();
        this.undoAction = new UndoAction();
        this.sqlFormatAction = new SqlFormatAction(rule, this, false);
        this.sqlCommentAction = new SqlCommentAction();
        this.sqlCommentAddAction = new SqlCommentAddAction();
        this.sqlCommentDeleteAction = new SqlCommentDeleteAction();
        this.sqlUnformatAction = new SqlUnformatAction(this);
        this.sqlExcludeCommentAction = new SqlExcludeCommentAction(this);
        amap.put(this.undoAction.getClass().getName(), this.undoAction);
        amap.put(this.redoAction.getClass().getName(), this.redoAction);
        amap.put(this.sqlFormatAction.getClass().getName(), this.sqlFormatAction);
        amap.put(this.sqlCommentAction.getClass().getName(), this.sqlCommentAction);
        amap.put(this.sqlCommentAddAction.getClass().getName(), this.sqlCommentAddAction);
        amap.put(this.sqlCommentDeleteAction.getClass().getName(), this.sqlCommentDeleteAction);
        amap.put(this.sqlUnformatAction.getClass().getName(), this.sqlUnformatAction);
        amap.put(this.sqlExcludeCommentAction.getClass().getName(), this.sqlExcludeCommentAction);
        InputMap imap = this.getInputMap();
        imap.put(this.undoAction.getAcceleratorKey(), this.undoAction);
        imap.put(this.redoAction.getAcceleratorKey(), this.redoAction);
        imap.put(this.sqlFormatAction.getAcceleratorKey(), this.sqlFormatAction);
        imap.put(this.sqlCommentAction.getAcceleratorKey(), this.sqlCommentAction);
        Action act_cut = amap.get("cut-to-clipboard");
        if (act_cut.getValue("AcceleratorKey") == null) {
            act_cut.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
        }
        if (act_cut.getValue("SmallIcon") == null) {
            act_cut.putValue("SmallIcon", Global.getImageIcon("/resources/eclipse_EditCut.png"));
        }
        if ((act_copy = amap.get("copy-to-clipboard")).getValue("AcceleratorKey") == null) {
            act_copy.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
        }
        if (act_copy.getValue("SmallIcon") == null) {
            act_copy.putValue("SmallIcon", Global.getImageIcon("/resources/eclipse_EditCopy.png"));
        }
        if ((act_paste = amap.get("paste-from-clipboard")).getValue("AcceleratorKey") == null) {
            act_paste.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 2));
        }
        if (act_paste.getValue("SmallIcon") == null) {
            act_paste.putValue("SmallIcon", Global.getImageIcon("/resources/eclipse_EditPaste.png"));
        }
        if ((act_selall = amap.get("select-all")).getValue("AcceleratorKey") == null) {
            act_selall.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 2));
        }
        this.getDocument().addUndoableEditListener(new UndoableListener());
        SxUtilities.addPopupMenuMouseListener(this);
        this.addMouseListener(new PopupListener());
        StyledDocument doc = (StyledDocument)this.getDocument();
        this.invokeSetHighlight(doc);
        doc.addDocumentListener(new DocListener());
    }

    void setHighlight(StyledDocument doc) {
        String text = "";
        try {
            text = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return;
        }
        ArrayList tokens = null;
        try {
            tokens = this.fParser.parse(text);
        }
        catch (RuntimeException e) {
            return;
        }
        doc.setCharacterAttributes(0, text.length(), PLANE, true);
        block14: for (int i = 0; i < tokens.size(); ++i) {
            BlancoSqlToken t = (BlancoSqlToken)tokens.get(i);
            int pos = t.getPos();
            String str = t.getString();
            switch (t.getType()) {
                case 0: {
                    continue block14;
                }
                case 1: {
                    continue block14;
                }
                case 2: {
                    str = str.toUpperCase();
                    if (Arrays.binarySearch(BlancoSqlConstants.SQL89_RESERVED_WORDS, str) >= 0) {
                        doc.setCharacterAttributes(pos, str.length(), SQL89, true);
                        continue block14;
                    }
                    if (Arrays.binarySearch(BlancoSqlConstants.SQL92_RESERVED_WORDS, str) >= 0) {
                        doc.setCharacterAttributes(pos, str.length(), SQL92, true);
                        continue block14;
                    }
                    if (Arrays.binarySearch(BlancoSqlConstants.SQL99_RESERVED_WORDS, str) >= 0) {
                        doc.setCharacterAttributes(pos, str.length(), SQL99, true);
                        continue block14;
                    }
                    if (Arrays.binarySearch(BlancoSqlConstants.SQL_FAMOUS_WORDS, str) >= 0) {
                        doc.setCharacterAttributes(pos, str.length(), SQL_FAMOUS, true);
                        continue block14;
                    }
                    doc.setCharacterAttributes(pos, str.length(), KEYWORD, true);
                    System.out.println("keyword=" + str);
                    continue block14;
                }
                case 3: {
                    doc.setCharacterAttributes(pos, str.length(), NAME, true);
                    continue block14;
                }
                case 4: {
                    doc.setCharacterAttributes(pos, str.length(), VALUE, true);
                    continue block14;
                }
                case 5: {
                    doc.setCharacterAttributes(pos, str.length(), COMMENT, true);
                    continue block14;
                }
                case 6: {
                    continue block14;
                }
                case 7: {
                    doc.setCharacterAttributes(pos, str.length(), UNKNOWN, true);
                    continue block14;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError(t.getType());
                    }
                    continue block14;
                }
            }
        }
    }

    void invokeSetHighlight(final StyledDocument doc) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SqlEditor.this.setHighlight(doc);
            }
        });
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                System.setProperty("swing.plaf.metal.controlFont", "Dialog-12");
                JFrame frame = new JFrame("SQL Editor");
                BlancoSqlRule rule = new BlancoSqlRule();
                String sql = "-- \u30b5\u30f3\u30d7\u30eb\u3067\u3059\u2606\nUPDATE\ntable1\nSET\ncol2 = 'ABC'\n,col3 = 123\nWHERE\ncol1 = 5;\nINSERT INTO table2 values(1,2,3);";
                Font font = new Font("Monospaced", 0, 12);
                SqlEditor editor = new SqlEditor(sql, rule, font);
                editor.setBorder(new EmptyBorder(5, 10, 0, 0));
                frame.getContentPane().add(new JScrollPane(editor));
                frame.setDefaultCloseOperation(3);
                frame.setSize(640, 800);
                frame.setVisible(true);
            }
        });
    }

    static {
        $assertionsDisabled = !SqlEditor.class.desiredAssertionStatus();
        PLANE = new SimpleAttributeSet();
        KEYWORD = new SimpleAttributeSet();
        COMMENT = new SimpleAttributeSet();
        VALUE = new SimpleAttributeSet();
        NAME = new SimpleAttributeSet();
        SQL89 = new SimpleAttributeSet();
        SQL92 = new SimpleAttributeSet();
        SQL99 = new SimpleAttributeSet();
        SQL_FAMOUS = new SimpleAttributeSet();
        UNKNOWN = new SimpleAttributeSet();
        StyleConstants.setForeground(KEYWORD, Color.BLUE);
        StyleConstants.setForeground(COMMENT, new Color(0, 128, 0));
        StyleConstants.setForeground(VALUE, Color.RED);
        StyleConstants.setBackground(UNKNOWN, Color.RED);
        StyleConstants.setForeground(SQL89, new Color(255, 0, 255));
        StyleConstants.setForeground(SQL92, new Color(192, 0, 255));
        StyleConstants.setForeground(SQL99, new Color(96, 0, 255));
        StyleConstants.setForeground(SQL_FAMOUS, new Color(0, 128, 255));
    }

    class SqlCommentDeleteAction
    extends SxAction {
        SqlCommentDeleteAction() {
            super("\u30b3\u30e1\u30f3\u30c8\u306e\u9664\u53bb");
            this.putValue("ShortDescription", "\u30b3\u30e1\u30f3\u30c8\u306e\u9664\u53bb");
            this.putValue("LongDescription", "\u30b3\u30e1\u30f3\u30c8\u306e\u9664\u53bb");
            this.putValue("SmallIcon", Global.getImageIcon("/resources/CommentDelete.png"));
        }

        public void actionPerformed(ActionEvent event) {
            int i;
            String text = SqlEditor.this.getText();
            int start = SqlEditor.this.getSelectionStart();
            int end = SqlEditor.this.getSelectionEnd();
            int[] slinecol = SxTextUtilities.getLineColumnIndex(text, start);
            int[] elinecol = SxTextUtilities.getLineColumnIndex(text, end);
            int sline = slinecol[0];
            int eline = elinecol[0];
            if (elinecol[1] == 0 && sline < eline) {
                --eline;
            }
            System.out.println("sline=" + sline + " eline=" + eline);
            String[] lines = SxTextUtilities.splitLine(text);
            for (i = sline; i <= eline; ++i) {
                if (!lines[i].startsWith("--")) continue;
                lines[i] = lines[i].substring(2);
            }
            text = "";
            for (i = 0; i < lines.length; ++i) {
                text = text + lines[i];
            }
            SqlEditor.this.setText(text);
        }

        public void updateStatus() {
        }
    }

    class SqlCommentAddAction
    extends SxAction {
        SqlCommentAddAction() {
            super("\u30b3\u30e1\u30f3\u30c8\u306e\u8ffd\u52a0");
            this.putValue("ShortDescription", "\u30b3\u30e1\u30f3\u30c8\u306e\u8ffd\u52a0");
            this.putValue("LongDescription", "\u30b3\u30e1\u30f3\u30c8\u306e\u8ffd\u52a0");
            this.putValue("SmallIcon", Global.getImageIcon("/resources/CommentAdd.png"));
        }

        public void actionPerformed(ActionEvent event) {
            int i;
            String text = SqlEditor.this.getText();
            int start = SqlEditor.this.getSelectionStart();
            int end = SqlEditor.this.getSelectionEnd();
            int[] slinecol = SxTextUtilities.getLineColumnIndex(text, start);
            int[] elinecol = SxTextUtilities.getLineColumnIndex(text, end);
            int sline = slinecol[0];
            int eline = elinecol[0];
            if (elinecol[1] == 0 && sline < eline) {
                --eline;
            }
            System.out.println("sline=" + sline + " eline=" + eline);
            String[] lines = SxTextUtilities.splitLine(text);
            for (i = sline; i <= eline; ++i) {
                lines[i] = "--" + lines[i];
            }
            text = "";
            for (i = 0; i < lines.length; ++i) {
                text = text + lines[i];
            }
            SqlEditor.this.setText(text);
        }

        public void updateStatus() {
        }
    }

    class SqlCommentAction
    extends SxAction {
        SqlCommentAction() {
            super("\u30b3\u30e1\u30f3\u30c8\u306e\u5207\u308a\u66ff\u3048(L)");
            this.putValue("MnemonicKey", new Integer(76));
            this.putValue("SmallIcon", Global.getImageIcon("/resources/CommentAdd.png"));
            this.putValue("ShortDescription", "\u30b3\u30e1\u30f3\u30c8\u306e\u5207\u308a\u66ff\u3048");
            this.putValue("LongDescription", "\u30b3\u30e1\u30f3\u30c8\u306e\u5207\u308a\u66ff\u3048");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(45, 2));
        }

        public void actionPerformed(ActionEvent event) {
            int i;
            String text = SqlEditor.this.getText();
            int start = SqlEditor.this.getSelectionStart();
            int end = SqlEditor.this.getSelectionEnd();
            int[] slinecol = SxTextUtilities.getLineColumnIndex(text, start);
            int[] elinecol = SxTextUtilities.getLineColumnIndex(text, end);
            int sline = slinecol[0];
            int eline = elinecol[0];
            if (elinecol[1] == 0 && sline < eline) {
                --eline;
            }
            System.out.println("sline=" + sline + " eline=" + eline);
            String[] lines = SxTextUtilities.splitLine(text);
            boolean allComment = true;
            for (i = sline; i <= eline; ++i) {
                if (lines[i].startsWith("--")) continue;
                allComment = false;
                break;
            }
            if (allComment) {
                for (i = sline; i <= eline; ++i) {
                    lines[i] = lines[i].substring(2);
                }
            } else {
                for (i = sline; i <= eline; ++i) {
                    lines[i] = "--" + lines[i];
                }
            }
            text = "";
            for (i = 0; i < lines.length; ++i) {
                text = text + lines[i];
            }
            SqlEditor.this.setText(text);
        }

        public void updateStatus() {
        }
    }

    private class RedoAction
    extends SxAction {
        static final String TITLE = "\u3084\u308a\u76f4\u3057(R)";

        RedoAction() {
            super(TITLE);
            this.putValue("MnemonicKey", new Integer(82));
            this.putValue("SmallIcon", Global.redoIcon);
            this.putValue("ShortDescription", "\u3084\u308a\u76f4\u3057");
            this.putValue("LongDescription", "\u3084\u308a\u76f4\u3057");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, 2));
            this.updateStatus();
        }

        public void actionPerformed(ActionEvent e) {
            SqlEditor.this.undoManager.redo();
            SqlEditor.this.undoAction.updateStatus();
            this.updateStatus();
        }

        public void updateStatus() {
            boolean canRedo = SqlEditor.this.undoManager.canRedo();
            if (canRedo) {
                this.setEnabled(true);
                this.putValue("Name", SqlEditor.this.undoManager.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", TITLE);
            }
        }
    }

    private class UndoAction
    extends SxAction {
        static final String TITLE = "\u5143\u306b\u623b\u3059(U)";

        UndoAction() {
            super(TITLE);
            this.putValue("MnemonicKey", new Integer(85));
            this.putValue("SmallIcon", Global.undoIcon);
            this.putValue("ShortDescription", "\u5143\u306b\u623b\u3059");
            this.putValue("LongDescription", "\u5143\u306b\u623b\u3059");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 2));
            this.updateStatus();
        }

        public void actionPerformed(ActionEvent e) {
            SqlEditor.this.undoManager.undo();
            SqlEditor.this.redoAction.updateStatus();
            this.updateStatus();
        }

        public void updateStatus() {
            boolean canUndo = SqlEditor.this.undoManager.canUndo();
            if (canUndo) {
                this.setEnabled(true);
                this.putValue("Name", SqlEditor.this.undoManager.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", TITLE);
            }
        }
    }

    private class UndoableListener
    implements UndoableEditListener {
        private UndoableListener() {
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            System.out.println(e.getEdit().getClass());
            AbstractDocument.DefaultDocumentEvent event = (AbstractDocument.DefaultDocumentEvent)e.getEdit();
            if (event.getType() != DocumentEvent.EventType.CHANGE) {
                SqlEditor.this.undoManager.addEdit(e.getEdit());
                SqlEditor.this.undoAction.updateStatus();
                SqlEditor.this.redoAction.updateStatus();
            }
        }
    }

    class UndoEdit
    extends AbstractUndoableEdit {
        String before;
        String after;

        UndoEdit(String before, String after) {
            this.before = before;
            this.after = after;
        }

        public void undo() {
            SqlEditor.this.setText(this.before);
        }

        public void redo() {
            SqlEditor.this.setText(this.after);
        }
    }

    private class DocListener
    implements DocumentListener {
        private DocListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            System.out.println(SqlEditor.this.getText());
            System.out.println("insertUpdate(e)" + e);
            SqlEditor.this.invokeSetHighlight((StyledDocument)e.getDocument());
        }

        public void removeUpdate(DocumentEvent e) {
            SqlEditor.this.invokeSetHighlight((StyledDocument)e.getDocument());
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }

    private class PopupListener
    extends SxMouseAdapter {
        static final /* synthetic */ boolean $assertionsDisabled;

        private PopupListener() {
        }

        public void mousePopup(MouseEvent ev) {
            JPopupMenu popup = new JPopupMenu();
            if (System.getProperty("debug") != null) {
                popup.add(SqlEditor.this.undoAction);
                popup.add(SqlEditor.this.redoAction);
                popup.addSeparator();
            }
            SxUtilities.addMenuItems(SqlEditor.this, popup);
            popup.addSeparator();
            popup.add(SqlEditor.this.sqlCommentAddAction);
            popup.add(SqlEditor.this.sqlCommentDeleteAction);
            popup.addSeparator();
            popup.add(SqlEditor.this.sqlFormatAction);
            popup.addSeparator();
            popup.add(SqlEditor.this.sqlUnformatAction);
            popup.add(SqlEditor.this.sqlExcludeCommentAction);
            if (System.getProperty("debug") != null) {
                popup.addSeparator();
                popup.add(new SqlFormatAction(SqlEditor.this.rule, SqlEditor.this, true));
            }
            popup.show(SqlEditor.this, ev.getX(), ev.getY());
        }

        private JMenuItem createMenuItem(Action action, String text, int mnemonic, boolean enable) {
            if (!$assertionsDisabled && action == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && text == null) {
                throw new AssertionError();
            }
            JMenuItem menu = new JMenuItem(action);
            menu.setText(text);
            menu.setMnemonic(mnemonic);
            menu.setEnabled(enable);
            KeyStroke ks = (KeyStroke)action.getValue("AcceleratorKey");
            if (ks != null) {
                menu.setAccelerator(ks);
            }
            return menu;
        }

        static {
            $assertionsDisabled = !(class$asandatabasebrowser$view$SqlEditor == null ? (class$asandatabasebrowser$view$SqlEditor = SqlEditor.class$("asandatabasebrowser.view.SqlEditor")) : class$asandatabasebrowser$view$SqlEditor).desiredAssertionStatus();
        }
    }
}

