/*
 * Decompiled with CFR 0.152.
 */
package blanco.commons.sql.format;

import blanco.commons.sql.format.BlancoSqlFormatterException;
import blanco.commons.sql.format.BlancoSqlParser;
import blanco.commons.sql.format.BlancoSqlRule;
import blanco.commons.sql.format.valueobject.BlancoSqlToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import java.util.Stack;

public class BlancoSqlFormatter {
    private final BlancoSqlParser fParser = new BlancoSqlParser();
    private BlancoSqlRule fRule = null;
    private Stack functionBracket = new Stack();

    public BlancoSqlFormatter(BlancoSqlRule argRule) {
        this.fRule = argRule;
    }

    public String format(String argSql) throws BlancoSqlFormatterException {
        this.functionBracket.clear();
        try {
            boolean isSqlEndsWithNewLine = false;
            if (argSql.endsWith("\n")) {
                isSqlEndsWithNewLine = true;
            }
            List list = this.fParser.parse(argSql);
            list = this.format(list);
            String after = "";
            for (int index = 0; index < list.size(); ++index) {
                BlancoSqlToken token = (BlancoSqlToken)list.get(index);
                after = after + token.getString();
            }
            if (isSqlEndsWithNewLine) {
                after = after + "\n";
            }
            return after;
        }
        catch (Exception ex) {
            BlancoSqlFormatterException sqlException = new BlancoSqlFormatterException(ex.toString());
            sqlException.initCause(ex);
            throw sqlException;
        }
    }

    private List format(List argList) {
        int index;
        int index2;
        BlancoSqlToken token = (BlancoSqlToken)argList.get(0);
        if (token.getType() == 0) {
            argList.remove(0);
        }
        if ((token = (BlancoSqlToken)argList.get(argList.size() - 1)).getType() == 0) {
            argList.remove(argList.size() - 1);
        }
        block14: for (index2 = 0; index2 < argList.size(); ++index2) {
            token = (BlancoSqlToken)argList.get(index2);
            block0 : switch (token.getType()) {
                case 2: {
                    switch (this.fRule.keyword) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            token.setString(token.getString().toUpperCase());
                            break;
                        }
                        case 2: {
                            token.setString(token.getString().toLowerCase());
                        }
                    }
                    continue block14;
                }
                case 3: {
                    switch (this.fRule.name) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            token.setString(token.getString().toUpperCase());
                            break block0;
                        }
                        case 2: {
                            token.setString(token.getString().toLowerCase());
                        }
                    }
                }
            }
        }
        for (index2 = argList.size() - 1; index2 >= 1; --index2) {
            token = (BlancoSqlToken)argList.get(index2);
            BlancoSqlToken prevToken = (BlancoSqlToken)argList.get(index2 - 1);
            if (token.getType() == 0 && (prevToken.getType() == 1 || prevToken.getType() == 5)) {
                argList.remove(index2);
                continue;
            }
            if ((token.getType() == 1 || token.getType() == 5) && prevToken.getType() == 0) {
                argList.remove(index2 - 1);
                continue;
            }
            if (token.getType() != 0) continue;
            token.setString(" ");
        }
        for (index2 = 0; index2 < argList.size() - 2; ++index2) {
            BlancoSqlToken t0 = (BlancoSqlToken)argList.get(index2);
            BlancoSqlToken t1 = (BlancoSqlToken)argList.get(index2 + 1);
            BlancoSqlToken t2 = (BlancoSqlToken)argList.get(index2 + 2);
            if (t0.getType() == 2 && t1.getType() == 0 && t2.getType() == 2 && (t0.getString().equalsIgnoreCase("ORDER") || t0.getString().equalsIgnoreCase("GROUP")) && t2.getString().equalsIgnoreCase("BY")) {
                t0.setString(t0.getString() + " " + t2.getString());
                argList.remove(index2 + 1);
                argList.remove(index2 + 1);
            }
            if (!t0.getString().equals("(") || !t1.getString().equals("+") || !t2.getString().equals(")")) continue;
            t0.setString("(+)");
            argList.remove(index2 + 1);
            argList.remove(index2 + 1);
        }
        int indent = 0;
        Stack<Integer> bracketIndent = new Stack<Integer>();
        BlancoSqlToken prev = new BlancoSqlToken(0, " ");
        boolean encounterBetween = false;
        for (index = 0; index < argList.size(); ++index) {
            token = (BlancoSqlToken)argList.get(index);
            if (token.getType() == 1) {
                if (token.getString().equals("(")) {
                    this.functionBracket.push(this.fRule.isFunction(prev.getString()) ? Boolean.TRUE : Boolean.FALSE);
                    bracketIndent.push(new Integer(indent));
                    index += this.insertReturnAndIndent(argList, index + 1, ++indent);
                } else if (token.getString().equals(")")) {
                    indent = (Integer)bracketIndent.pop();
                    index += this.insertReturnAndIndent(argList, index, indent);
                    this.functionBracket.pop();
                } else if (token.getString().equals(",")) {
                    index += this.insertReturnAndIndent(argList, index, indent);
                } else if (token.getString().equals(";")) {
                    if (prev.getType() == 0) {
                        argList.remove(index);
                    }
                    indent = 0;
                    index += this.insertReturnAndIndent(argList, index, indent);
                    index += this.insertReturnAndIndent(argList, index + 1, indent);
                }
            } else if (token.getType() == 2) {
                if (token.getString().equalsIgnoreCase("DELETE") || token.getString().equalsIgnoreCase("SELECT") || token.getString().equalsIgnoreCase("UPDATE")) {
                    index += this.insertReturnAndIndent(argList, index + 1, indent += 2);
                }
                if (token.getString().equalsIgnoreCase("INSERT") || token.getString().equalsIgnoreCase("INTO") || token.getString().equalsIgnoreCase("CREATE") || token.getString().equalsIgnoreCase("DROP") || token.getString().equalsIgnoreCase("TRUNCATE") || token.getString().equalsIgnoreCase("TABLE") || token.getString().equalsIgnoreCase("CASE")) {
                    index += this.insertReturnAndIndent(argList, index + 1, ++indent);
                }
                if (token.getString().equalsIgnoreCase("FROM") || token.getString().equalsIgnoreCase("WHERE") || token.getString().equalsIgnoreCase("SET") || token.getString().equalsIgnoreCase("ORDER BY") || token.getString().equalsIgnoreCase("GROUP BY") || token.getString().equalsIgnoreCase("HAVING")) {
                    index += this.insertReturnAndIndent(argList, index, indent - 1);
                    index += this.insertReturnAndIndent(argList, index + 1, indent);
                }
                if (token.getString().equalsIgnoreCase("VALUES")) {
                    index += this.insertReturnAndIndent(argList, index, --indent);
                }
                if (token.getString().equalsIgnoreCase("END")) {
                    index += this.insertReturnAndIndent(argList, index, --indent);
                }
                if (token.getString().equalsIgnoreCase("OR") || token.getString().equalsIgnoreCase("THEN") || token.getString().equalsIgnoreCase("ELSE")) {
                    index += this.insertReturnAndIndent(argList, index, indent);
                }
                if (token.getString().equalsIgnoreCase("ON") || token.getString().equalsIgnoreCase("USING")) {
                    index += this.insertReturnAndIndent(argList, index, indent + 1);
                }
                if (token.getString().equalsIgnoreCase("UNION") || token.getString().equalsIgnoreCase("INTERSECT") || token.getString().equalsIgnoreCase("EXCEPT")) {
                    index += this.insertReturnAndIndent(argList, index, indent -= 2);
                    index += this.insertReturnAndIndent(argList, index + 1, indent);
                }
                if (token.getString().equalsIgnoreCase("BETWEEN")) {
                    encounterBetween = true;
                }
                if (token.getString().equalsIgnoreCase("AND")) {
                    if (!encounterBetween) {
                        index += this.insertReturnAndIndent(argList, index, indent);
                    }
                    encounterBetween = false;
                }
            } else if (token.getType() == 5 && token.getString().startsWith("/*")) {
                index += this.insertReturnAndIndent(argList, index + 1, indent);
            }
            prev = token;
        }
        for (index = argList.size() - 1; index >= 4; --index) {
            if (index >= argList.size()) continue;
            BlancoSqlToken t0 = (BlancoSqlToken)argList.get(index);
            BlancoSqlToken t1 = (BlancoSqlToken)argList.get(index - 1);
            BlancoSqlToken t2 = (BlancoSqlToken)argList.get(index - 2);
            BlancoSqlToken t3 = (BlancoSqlToken)argList.get(index - 3);
            BlancoSqlToken t4 = (BlancoSqlToken)argList.get(index - 4);
            if (!t4.getString().equalsIgnoreCase("(") || !t3.getString().trim().equalsIgnoreCase("") || !t1.getString().trim().equalsIgnoreCase("") || !t0.getString().equalsIgnoreCase(")")) continue;
            t4.setString(t4.getString() + t2.getString() + t0.getString());
            argList.remove(index);
            argList.remove(index - 1);
            argList.remove(index - 2);
            argList.remove(index - 3);
        }
        for (index = 1; index < argList.size(); ++index) {
            prev = (BlancoSqlToken)argList.get(index - 1);
            token = (BlancoSqlToken)argList.get(index);
            if (prev.getType() == 0 || token.getType() == 0 || prev.getString().equals(",") || this.fRule.isFunction(prev.getString()) && token.getString().equals("(") || prev.getType() == 5) continue;
            argList.add(index, new BlancoSqlToken(0, " "));
        }
        return argList;
    }

    private int insertReturnAndIndent(List argList, int argIndex, int argIndent) {
        if (this.functionBracket.contains(Boolean.TRUE)) {
            return 0;
        }
        try {
            String s = "\n";
            BlancoSqlToken prevToken = (BlancoSqlToken)argList.get(argIndex - 1);
            if (prevToken.getType() == 5 && prevToken.getString().startsWith("--")) {
                s = "";
            }
            for (int index = 0; index < argIndent; ++index) {
                s = s + this.fRule.indentString;
            }
            BlancoSqlToken token = (BlancoSqlToken)argList.get(argIndex);
            if (token.getType() == 0) {
                token.setString(s);
                return 0;
            }
            token = (BlancoSqlToken)argList.get(argIndex - 1);
            if (token.getType() == 0) {
                token.setString(s);
                return 0;
            }
            argList.add(argIndex, new BlancoSqlToken(0, s));
            return 1;
        }
        catch (IndexOutOfBoundsException e) {
            return 0;
        }
    }

    public static void main(String[] args) throws Exception {
        BlancoSqlRule rule = new BlancoSqlRule();
        rule.keyword = 1;
        rule.indentString = "    ";
        String[] mySqlFuncs = new String[]{"ABS", "ACOS", "ASIN", "ATAN", "ATAN2", "BIT_COUNT", "CEILING", "COS", "COT", "DEGREES", "EXP", "FLOOR", "LOG", "LOG10", "MAX", "MIN", "MOD", "PI", "POW", "POWER", "RADIANS", "RAND", "ROUND", "SIN", "SQRT", "TAN", "TRUNCATE", "ASCII", "BIN", "BIT_LENGTH", "CHAR", "CHARACTER_LENGTH", "CHAR_LENGTH", "CONCAT", "CONCAT_WS", "CONV", "ELT", "EXPORT_SET", "FIELD", "FIND_IN_SET", "HEX,INSERT", "INSTR", "LCASE", "LEFT", "LENGTH", "LOAD_FILE", "LOCATE", "LOCATE", "LOWER", "LPAD", "LTRIM", "MAKE_SET", "MATCH", "MID", "OCT", "OCTET_LENGTH", "ORD", "POSITION", "QUOTE", "REPEAT", "REPLACE", "REVERSE", "RIGHT", "RPAD", "RTRIM", "SOUNDEX", "SPACE", "STRCMP", "SUBSTRING", "SUBSTRING", "SUBSTRING", "SUBSTRING", "SUBSTRING_INDEX", "TRIM", "UCASE", "UPPER", "DATABASE", "USER", "SYSTEM_USER", "SESSION_USER", "PASSWORD", "ENCRYPT", "LAST_INSERT_ID", "VERSION", "DAYOFWEEK", "WEEKDAY", "DAYOFMONTH", "DAYOFYEAR", "MONTH", "DAYNAME", "MONTHNAME", "QUARTER", "WEEK", "YEAR", "HOUR", "MINUTE", "SECOND", "PERIOD_ADD", "PERIOD_DIFF", "TO_DAYS", "FROM_DAYS", "DATE_FORMAT", "TIME_FORMAT", "CURDATE", "CURRENT_DATE", "CURTIME", "CURRENT_TIME", "NOW", "SYSDATE", "CURRENT_TIMESTAMP", "UNIX_TIMESTAMP", "FROM_UNIXTIME", "SEC_TO_TIME", "TIME_TO_SEC"};
        rule.setFunctionNames(mySqlFuncs);
        BlancoSqlFormatter formatter = new BlancoSqlFormatter(rule);
        File[] files = new File("Test").listFiles();
        for (int i = 0; i < files.length; ++i) {
            String line;
            System.out.println("-- " + files[i]);
            BufferedReader reader = new BufferedReader(new FileReader(files[i]));
            String before = "";
            while (reader.ready() && (line = reader.readLine()) != null) {
                before = before + line + "\n";
            }
            reader.close();
            System.out.println("[before]\n" + before);
            String after = formatter.format(before);
            System.out.println("[after]\n" + after);
        }
    }
}

