/*
 * Decompiled with CFR 0.152.
 */
package blanco.commons.sql.format;

import blanco.commons.sql.format.BlancoSqlFormatterException;
import blanco.commons.sql.format.BlancoSqlParser;
import blanco.commons.sql.format.BlancoSqlRule;
import blanco.commons.sql.format.valueobject.BlancoSqlToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class BlancoSqlFormatter2 {
    private final BlancoSqlParser fParser = new BlancoSqlParser();
    private BlancoSqlRule fRule = null;
    private Stack functionBracket = new Stack();
    static final /* synthetic */ boolean $assertionsDisabled;

    public BlancoSqlFormatter2(BlancoSqlRule argRule) {
        this.fRule = argRule;
    }

    public String format(String argSql) throws BlancoSqlFormatterException {
        this.functionBracket.clear();
        try {
            boolean isSqlEndsWithNewLine = false;
            if (argSql.endsWith("\n")) {
                isSqlEndsWithNewLine = true;
            }
            List list = this.fParser.parse(argSql);
            list = this.format(list);
            StringBuffer after = new StringBuffer();
            for (int index = 0; index < list.size(); ++index) {
                BlancoSqlToken token = (BlancoSqlToken)list.get(index);
                after.append(token.getString());
            }
            if (isSqlEndsWithNewLine) {
                after.append("\n");
            }
            return after.toString();
        }
        catch (Exception ex) {
            BlancoSqlFormatterException sqlException = new BlancoSqlFormatterException(ex.toString());
            sqlException.initCause(ex);
            throw sqlException;
        }
    }

    private List format(List list0) {
        ArrayList<BlancoSqlToken> list1 = new ArrayList<BlancoSqlToken>();
        block17: for (int i = 0; i < list0.size(); ++i) {
            BlancoSqlToken token = (BlancoSqlToken)list0.get(i);
            switch (token.getType()) {
                case 0: {
                    continue block17;
                }
                default: {
                    list1.add(token);
                }
            }
        }
        ArrayList<BlancoSqlToken> list2 = new ArrayList<BlancoSqlToken>();
        block18: for (int i = 0; i < list1.size(); ++i) {
            BlancoSqlToken token = (BlancoSqlToken)list1.get(i);
            switch (token.getType()) {
                case 2: {
                    switch (this.fRule.keyword) {
                        case 0: {
                            list2.add(token);
                            continue block18;
                        }
                        case 1: {
                            token = new BlancoSqlToken(token.getType(), token.getString().toUpperCase());
                            list2.add(token);
                            continue block18;
                        }
                        case 2: {
                            token = new BlancoSqlToken(token.getType(), token.getString().toLowerCase());
                            list2.add(token);
                            continue block18;
                        }
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError(this.fRule.keyword);
                    }
                    continue block18;
                }
                case 3: {
                    switch (this.fRule.name) {
                        case 0: {
                            list2.add(token);
                            continue block18;
                        }
                        case 1: {
                            token = new BlancoSqlToken(token.getType(), token.getString().toUpperCase());
                            list2.add(token);
                            continue block18;
                        }
                        case 2: {
                            token = new BlancoSqlToken(token.getType(), token.getString().toLowerCase());
                            list2.add(token);
                            continue block18;
                        }
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError(this.fRule.name);
                    }
                    continue block18;
                }
                default: {
                    list2.add(token);
                }
            }
        }
        ArrayList<BlancoSqlToken> list3 = new ArrayList<BlancoSqlToken>();
        for (int index = 0; index < list2.size() - 2; ++index) {
            BlancoSqlToken t;
            BlancoSqlToken t0 = (BlancoSqlToken)list2.get(index);
            BlancoSqlToken t1 = (BlancoSqlToken)list2.get(index + 1);
            BlancoSqlToken t2 = (BlancoSqlToken)list2.get(index + 2);
            if (t0.getType() == 2 && t1.getType() == 2 && (t0.getString().equalsIgnoreCase("ORDER") || t0.getString().equalsIgnoreCase("GROUP")) && t1.getString().equalsIgnoreCase("BY")) {
                t = new BlancoSqlToken(2, t0.getString() + " " + t1.getString());
                list3.add(t);
                ++index;
            } else if (t0.getString().equals("(") && t1.getString().equals("+") && t2.getString().equals(")")) {
                t = new BlancoSqlToken(1, "(+)");
                list3.add(t);
            } else {
                list3.add(t0);
            }
            if (index != list2.size() - 3) continue;
            list3.add(t1);
            list3.add(t2);
        }
        int indent = 0;
        Stack<Integer> bracketIndent = new Stack<Integer>();
        BlancoSqlToken prev = new BlancoSqlToken(0, " ");
        boolean encounterBetween = false;
        for (int index = 0; index < list3.size(); ++index) {
            BlancoSqlToken token = (BlancoSqlToken)list3.get(index);
            if (token.getType() == 1) {
                if (token.getString().equals("(")) {
                    this.functionBracket.push(this.fRule.isFunction(prev.getString()) ? Boolean.TRUE : Boolean.FALSE);
                    bracketIndent.push(new Integer(indent));
                    index += this.insertReturnAndIndent(list3, index + 1, ++indent);
                } else if (token.getString().equals(")")) {
                    indent = (Integer)bracketIndent.pop();
                    index += this.insertReturnAndIndent(list3, index, indent);
                    this.functionBracket.pop();
                } else if (token.getString().equals(",")) {
                    index += this.insertReturnAndIndent(list3, index, indent);
                } else if (token.getString().equals(";")) {
                    if (prev.getType() == 0) {
                        list3.remove(index);
                    }
                    indent = 0;
                    index += this.insertReturnAndIndent(list3, index, indent);
                }
            } else if (token.getType() == 2) {
                if (token.getString().equalsIgnoreCase("DELETE") || token.getString().equalsIgnoreCase("SELECT") || token.getString().equalsIgnoreCase("UPDATE")) {
                    index += this.insertReturnAndIndent(list3, index + 1, indent += 2);
                }
                if (token.getString().equalsIgnoreCase("INSERT") || token.getString().equalsIgnoreCase("INTO") || token.getString().equalsIgnoreCase("CREATE") || token.getString().equalsIgnoreCase("DROP") || token.getString().equalsIgnoreCase("TRUNCATE") || token.getString().equalsIgnoreCase("TABLE") || token.getString().equalsIgnoreCase("CASE")) {
                    index += this.insertReturnAndIndent(list3, index + 1, ++indent);
                }
                if (token.getString().equalsIgnoreCase("FROM") || token.getString().equalsIgnoreCase("WHERE") || token.getString().equalsIgnoreCase("SET") || token.getString().equalsIgnoreCase("ORDER BY") || token.getString().equalsIgnoreCase("GROUP BY") || token.getString().equalsIgnoreCase("HAVING")) {
                    index += this.insertReturnAndIndent(list3, index, indent - 1);
                    index += this.insertReturnAndIndent(list3, index + 1, indent);
                }
                if (token.getString().equalsIgnoreCase("VALUES")) {
                    index += this.insertReturnAndIndent(list3, index, --indent);
                }
                if (token.getString().equalsIgnoreCase("END")) {
                    index += this.insertReturnAndIndent(list3, index, --indent);
                }
                if (token.getString().equalsIgnoreCase("OR") || token.getString().equalsIgnoreCase("THEN") || token.getString().equalsIgnoreCase("ELSE")) {
                    index += this.insertReturnAndIndent(list3, index, indent);
                }
                if (token.getString().equalsIgnoreCase("ON") || token.getString().equalsIgnoreCase("USING")) {
                    index += this.insertReturnAndIndent(list3, index, indent + 1);
                }
                if (token.getString().equalsIgnoreCase("UNION") || token.getString().equalsIgnoreCase("INTERSECT") || token.getString().equalsIgnoreCase("EXCEPT")) {
                    index += this.insertReturnAndIndent(list3, index, indent -= 2);
                    index += this.insertReturnAndIndent(list3, index + 1, indent);
                }
                if (token.getString().equalsIgnoreCase("BETWEEN")) {
                    encounterBetween = true;
                }
                if (token.getString().equalsIgnoreCase("AND")) {
                    if (!encounterBetween) {
                        index += this.insertReturnAndIndent(list3, index, indent);
                    }
                    encounterBetween = false;
                }
            } else if (token.getType() == 5 && token.getString().startsWith("/*")) {
                index += this.insertReturnAndIndent(list3, index + 1, indent);
            }
            prev = token;
        }
        return list3;
    }

    private int insertReturnAndIndent(List argList, int argIndex, int argIndent) {
        if (this.functionBracket.contains(Boolean.TRUE)) {
            return 0;
        }
        try {
            String s = "\n";
            BlancoSqlToken prevToken = (BlancoSqlToken)argList.get(argIndex - 1);
            if (prevToken.getType() == 5 && prevToken.getString().startsWith("--")) {
                s = "";
            }
            for (int index = 0; index < argIndent; ++index) {
                s = s + this.fRule.indentString;
            }
            BlancoSqlToken token = (BlancoSqlToken)argList.get(argIndex);
            if (token.getType() == 0) {
                token.setString(s);
                return 0;
            }
            token = (BlancoSqlToken)argList.get(argIndex - 1);
            if (token.getType() == 0) {
                token.setString(s);
                return 0;
            }
            argList.add(argIndex, new BlancoSqlToken(0, s));
            return 1;
        }
        catch (IndexOutOfBoundsException e) {
            return 0;
        }
    }

    public static void main(String[] args) throws Exception {
        BlancoSqlRule rule = new BlancoSqlRule();
        rule.keyword = 1;
        rule.indentString = "    ";
        String[] mySqlFuncs = new String[]{"ABS", "ACOS", "ASIN", "ATAN", "ATAN2", "BIT_COUNT", "CEILING", "COS", "COT", "DEGREES", "EXP", "FLOOR", "LOG", "LOG10", "MAX", "MIN", "MOD", "PI", "POW", "POWER", "RADIANS", "RAND", "ROUND", "SIN", "SQRT", "TAN", "TRUNCATE", "ASCII", "BIN", "BIT_LENGTH", "CHAR", "CHARACTER_LENGTH", "CHAR_LENGTH", "CONCAT", "CONCAT_WS", "CONV", "ELT", "EXPORT_SET", "FIELD", "FIND_IN_SET", "HEX,INSERT", "INSTR", "LCASE", "LEFT", "LENGTH", "LOAD_FILE", "LOCATE", "LOCATE", "LOWER", "LPAD", "LTRIM", "MAKE_SET", "MATCH", "MID", "OCT", "OCTET_LENGTH", "ORD", "POSITION", "QUOTE", "REPEAT", "REPLACE", "REVERSE", "RIGHT", "RPAD", "RTRIM", "SOUNDEX", "SPACE", "STRCMP", "SUBSTRING", "SUBSTRING", "SUBSTRING", "SUBSTRING", "SUBSTRING_INDEX", "TRIM", "UCASE", "UPPER", "DATABASE", "USER", "SYSTEM_USER", "SESSION_USER", "PASSWORD", "ENCRYPT", "LAST_INSERT_ID", "VERSION", "DAYOFWEEK", "WEEKDAY", "DAYOFMONTH", "DAYOFYEAR", "MONTH", "DAYNAME", "MONTHNAME", "QUARTER", "WEEK", "YEAR", "HOUR", "MINUTE", "SECOND", "PERIOD_ADD", "PERIOD_DIFF", "TO_DAYS", "FROM_DAYS", "DATE_FORMAT", "TIME_FORMAT", "CURDATE", "CURRENT_DATE", "CURTIME", "CURRENT_TIME", "NOW", "SYSDATE", "CURRENT_TIMESTAMP", "UNIX_TIMESTAMP", "FROM_UNIXTIME", "SEC_TO_TIME", "TIME_TO_SEC"};
        rule.setFunctionNames(mySqlFuncs);
        BlancoSqlFormatter2 formatter = new BlancoSqlFormatter2(rule);
        File[] files = new File("Test").listFiles();
        for (int i = 0; i < files.length; ++i) {
            String line;
            System.out.println("-- " + files[i]);
            BufferedReader reader = new BufferedReader(new FileReader(files[i]));
            String before = "";
            while (reader.ready() && (line = reader.readLine()) != null) {
                before = before + line + "\n";
            }
            reader.close();
            System.out.println("[before]\n" + before);
            String after = formatter.format(before);
            System.out.println("[after]\n" + after);
        }
    }

    static {
        $assertionsDisabled = !BlancoSqlFormatter2.class.desiredAssertionStatus();
    }
}

