/*
 * Decompiled with CFR 0.152.
 */
package blanco.commons.sql.format;

import blanco.commons.sql.format.BlancoSqlConstants;
import blanco.commons.sql.format.valueobject.BlancoSqlToken;
import java.util.ArrayList;

public class BlancoSqlParser {
    private String fBefore;
    private char fChar;
    private int fPos;
    private static final String[] twoCharacterSymbol = new String[]{"<>", "<=", ">=", "||"};

    public static boolean isSpace(char argChar) {
        return argChar == ' ' || argChar == '\t' || argChar == '\n' || argChar == '\r' || argChar == '\uffff';
    }

    public static boolean isLetter(char argChar) {
        if (BlancoSqlParser.isSpace(argChar)) {
            return false;
        }
        if (BlancoSqlParser.isDigit(argChar)) {
            return false;
        }
        return !BlancoSqlParser.isSymbol(argChar);
    }

    public static boolean isDigit(char argChar) {
        return '0' <= argChar && argChar <= '9';
    }

    public static boolean isSymbol(char argChar) {
        switch (argChar) {
            case '\"': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    BlancoSqlToken nextToken() {
        int start_pos = this.fPos;
        if (this.fPos >= this.fBefore.length()) {
            ++this.fPos;
            return new BlancoSqlToken(6, "", start_pos);
        }
        this.fChar = this.fBefore.charAt(this.fPos);
        if (BlancoSqlParser.isSpace(this.fChar)) {
            String workString = "";
            do {
                ++this.fPos;
                workString = workString + this.fChar;
                if (this.fPos >= this.fBefore.length()) {
                    return new BlancoSqlToken(0, workString, start_pos);
                }
                this.fChar = this.fBefore.charAt(this.fPos);
            } while (BlancoSqlParser.isSpace(this.fChar));
            return new BlancoSqlToken(0, workString, start_pos);
        }
        if (this.fChar == ';') {
            ++this.fPos;
            return new BlancoSqlToken(1, ";", start_pos);
        }
        if (BlancoSqlParser.isDigit(this.fChar)) {
            String s = "";
            while (BlancoSqlParser.isDigit(this.fChar) || this.fChar == '.') {
                s = s + this.fChar;
                ++this.fPos;
                if (this.fPos >= this.fBefore.length()) break;
                this.fChar = this.fBefore.charAt(this.fPos);
            }
            return new BlancoSqlToken(4, s, start_pos);
        }
        if (BlancoSqlParser.isLetter(this.fChar)) {
            String s = "";
            while (BlancoSqlParser.isLetter(this.fChar) || BlancoSqlParser.isDigit(this.fChar) || this.fChar == '.') {
                s = s + this.fChar;
                ++this.fPos;
                if (this.fPos >= this.fBefore.length()) break;
                this.fChar = this.fBefore.charAt(this.fPos);
            }
            for (int i = 0; i < BlancoSqlConstants.SQL_RESERVED_WORDS.length; ++i) {
                if (s.compareToIgnoreCase(BlancoSqlConstants.SQL_RESERVED_WORDS[i]) != 0) continue;
                return new BlancoSqlToken(2, s, start_pos);
            }
            return new BlancoSqlToken(3, s, start_pos);
        }
        if (this.fChar == '-') {
            ++this.fPos;
            char ch2 = this.fBefore.charAt(this.fPos);
            if (ch2 != '-') {
                return new BlancoSqlToken(1, "-", start_pos);
            }
            ++this.fPos;
            String s = "--";
            do {
                this.fChar = this.fBefore.charAt(this.fPos);
                s = s + this.fChar;
                ++this.fPos;
            } while (this.fChar != '\n' && this.fPos < this.fBefore.length());
            return new BlancoSqlToken(5, s, start_pos);
        }
        if (this.fChar == '/') {
            ++this.fPos;
            char ch2 = this.fBefore.charAt(this.fPos);
            if (ch2 != '*') {
                return new BlancoSqlToken(1, "/", start_pos);
            }
            String s = "/*";
            ++this.fPos;
            int ch0 = -1;
            do {
                ch0 = this.fChar;
                this.fChar = this.fBefore.charAt(this.fPos);
                s = s + this.fChar;
                ++this.fPos;
            } while (ch0 != 42 || this.fChar != '/');
            return new BlancoSqlToken(5, s, start_pos);
        }
        if (this.fChar == '\'') {
            ++this.fPos;
            String s = "'";
            do {
                this.fChar = this.fBefore.charAt(this.fPos);
                s = s + this.fChar;
                ++this.fPos;
            } while (this.fChar != '\'');
            return new BlancoSqlToken(4, s, start_pos);
        }
        if (this.fChar == '\"') {
            ++this.fPos;
            String s = "\"";
            do {
                this.fChar = this.fBefore.charAt(this.fPos);
                s = s + this.fChar;
                ++this.fPos;
            } while (this.fChar != '\"');
            return new BlancoSqlToken(3, s, start_pos);
        }
        if (BlancoSqlParser.isSymbol(this.fChar)) {
            String s = "" + this.fChar;
            ++this.fPos;
            if (this.fPos >= this.fBefore.length()) {
                return new BlancoSqlToken(1, s, start_pos);
            }
            char ch2 = this.fBefore.charAt(this.fPos);
            for (int i = 0; i < twoCharacterSymbol.length; ++i) {
                if (twoCharacterSymbol[i].charAt(0) != this.fChar || twoCharacterSymbol[i].charAt(1) != ch2) continue;
                ++this.fPos;
                s = s + ch2;
                break;
            }
            return new BlancoSqlToken(1, s, start_pos);
        }
        ++this.fPos;
        return new BlancoSqlToken(7, "" + this.fChar, start_pos);
    }

    public ArrayList parse(String argSql) {
        BlancoSqlToken token;
        this.fPos = 0;
        this.fBefore = argSql;
        ArrayList<BlancoSqlToken> list = new ArrayList<BlancoSqlToken>();
        while ((token = this.nextToken()).getType() != 6) {
            list.add(token);
        }
        return list;
    }
}

