/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx;

import java.io.File;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter {
    protected ArrayList extensions = new ArrayList();
    protected String desc;
    protected boolean ignoreCase = true;

    public ExtensionFileFilter(String[] exts, String desc, boolean ignoreCase) {
        if (exts != null) {
            for (int i = 0; i < exts.length; ++i) {
                this.extensions.add(exts[i]);
            }
        }
        this.desc = desc;
        this.ignoreCase = ignoreCase;
    }

    public ExtensionFileFilter(String[] exts, String desc) {
        this(exts, desc, true);
    }

    public ExtensionFileFilter() {
        this(null, null);
    }

    public void addExtension(String ext) {
        this.extensions.add(ext);
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public void setExtensions(String[] exts, String desc) {
        for (int i = 0; i < exts.length; ++i) {
            this.extensions.add(exts[i]);
        }
        this.desc = desc;
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String fname = f.getName();
        for (int i = 0; i < this.extensions.size(); ++i) {
            String ext = (String)this.extensions.get(i);
            if (!fname.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static String getExtension(String fname) {
        int pos = fname.lastIndexOf(".");
        if (pos == -1) {
            return null;
        }
        return fname.substring(pos);
    }

    public String getDescription() {
        return this.desc;
    }

    public static void main(String[] args) {
        ExtensionFileFilter filter = new ExtensionFileFilter();
        filter.addExtension(".java");
        System.out.println(filter.accept(new File("ExtensionFileFilter.java")));
        System.out.println(filter.accept(new File("ExtensionFileFilter.class")));
    }
}

