/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;

public class RatioLayout
implements LayoutManager2 {
    private ArrayList ratios = new ArrayList();
    private int axis;
    private Container target;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RatioLayout(Container target, int axis) {
        if (!$assertionsDisabled && axis != 0 && axis != 1) {
            throw new AssertionError(axis);
        }
        this.axis = axis;
        this.target = target;
    }

    public void addLayoutComponent(Component comp, Object ratio) {
        this.ratios.add(ratio);
    }

    public void addLayoutComponent(String name, Component comp) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void layoutContainer(Container target) {
        int i;
        if (!$assertionsDisabled && this.target != target) {
            throw new AssertionError(target);
        }
        int nChildren = target.getComponentCount();
        int[] xOffsets = new int[nChildren];
        int[] xSpans = new int[nChildren];
        int[] yOffsets = new int[nChildren];
        int[] ySpans = new int[nChildren];
        Dimension alloc = target.getSize();
        Insets in = target.getInsets();
        alloc.width -= in.left + in.right;
        alloc.height -= in.top + in.bottom;
        int offset = 0;
        for (i = 0; i < nChildren; ++i) {
            int ratio;
            if (this.axis == 0) {
                yOffsets[i] = in.top;
                ySpans[i] = alloc.height;
                xOffsets[i] = alloc.width * offset / 100;
                Integer xRatio = (Integer)this.ratios.get(i);
                ratio = xRatio;
                xSpans[i] = alloc.width * ratio / 100;
                offset += ratio;
                continue;
            }
            xOffsets[i] = in.left;
            xSpans[i] = alloc.width;
            yOffsets[i] = alloc.height * offset / 100;
            Integer yRatio = (Integer)this.ratios.get(i);
            ratio = yRatio;
            ySpans[i] = alloc.height * ratio / 100;
            offset += ratio;
        }
        for (i = 0; i < nChildren; ++i) {
            Component c = target.getComponent(i);
            c.setBounds(in.left + xOffsets[i], in.top + yOffsets[i], xSpans[i], ySpans[i]);
        }
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension maximumLayoutSize(Container target) {
        Dimension dim = new Dimension();
        for (int i = 0; i < target.getComponentCount(); ++i) {
            Component c = target.getComponent(i);
            Dimension d = c.getMaximumSize();
            if (this.axis == 0) {
                dim.width = d.width == Integer.MAX_VALUE || dim.width == Integer.MAX_VALUE ? Integer.MAX_VALUE : (dim.width += d.width);
                dim.height = Math.max(dim.height, d.height);
                continue;
            }
            dim.height = d.height == Integer.MAX_VALUE || dim.height == Integer.MAX_VALUE ? Integer.MAX_VALUE : (dim.height += d.height);
            dim.width = Math.max(dim.width, d.width);
        }
        return dim;
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension dim = new Dimension();
        for (int i = 0; i < target.getComponentCount(); ++i) {
            Component c = target.getComponent(i);
            Dimension d = c.getPreferredSize();
            if (this.axis == 0) {
                dim.width += d.width;
                dim.height = Math.max(dim.height, d.height);
                continue;
            }
            dim.height += d.height;
            dim.width = Math.max(dim.width, d.width);
        }
        return dim;
    }

    public Dimension minimumLayoutSize(Container target) {
        Dimension dim = new Dimension();
        for (int i = 0; i < target.getComponentCount(); ++i) {
            Component c = target.getComponent(i);
            Dimension d = c.getMinimumSize();
            if (this.axis == 0) {
                dim.width += d.width;
                dim.height = Math.max(dim.height, d.height);
                continue;
            }
            dim.height += d.height;
            dim.width = Math.max(dim.width, d.width);
        }
        return dim;
    }

    static {
        $assertionsDisabled = !RatioLayout.class.desiredAssertionStatus();
    }
}

