/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.security.AccessControlException;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

public class SxAboutDialog {
    public static JPanel createJavaVmPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JComponent sysprop = null;
        try {
            sysprop = new JScrollPane(SxAboutDialog.createSystemPropertiesTable());
        }
        catch (AccessControlException e) {
            sysprop = new JLabel("\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u4e0a\u3001\u30b7\u30b9\u30c6\u30e0\u30d7\u30ed\u30d1\u30c6\u30a3\u306f\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
        }
        panel.add((Component)sysprop, "Center");
        panel.add((Component)SxAboutDialog.createMemoryPanel(), "South");
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        return panel;
    }

    public static JTable createSystemPropertiesTable() {
        Properties prop = System.getProperties();
        TreeMap<String, String> sortMap = new TreeMap<String, String>();
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            sortMap.put(key, prop.getProperty(key));
        }
        Object[] columnNames = new String[]{"Key", "Value"};
        Object[][] data = new Object[sortMap.size()][2];
        Iterator ite = sortMap.keySet().iterator();
        int i = 0;
        while (ite.hasNext()) {
            String key = (String)ite.next();
            data[i][0] = key;
            data[i][1] = sortMap.get(key);
            ++i;
        }
        JTable table = new JTable(data, columnNames){

            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        table.setCellEditor(null);
        table.setPreferredScrollableViewportSize(new Dimension(480, 240));
        table.getTableHeader().setReorderingAllowed(false);
        return table;
    }

    public static JPanel createMemoryPanel() {
        JPanel panel = new JPanel();
        final JLabel memorySizeLabel = new JLabel(SxAboutDialog.getMemoryText());
        panel.add(memorySizeLabel);
        panel.add(new JButton(new AbstractAction("GC\u5b9f\u884c"){

            public void actionPerformed(ActionEvent e) {
                System.gc();
                memorySizeLabel.setText(SxAboutDialog.getMemoryText());
            }
        }));
        return panel;
    }

    static String getMemoryText() {
        Runtime runtime = Runtime.getRuntime();
        DecimalFormat f = new DecimalFormat();
        if (System.getProperty("java.version").compareTo("1.4") < 0) {
            return "<html><table><tr><td>free memory</td><td align=\"right\">" + f.format(runtime.freeMemory()) + "</td></tr>" + "<tr><td>total memory</td>" + "<td align=\"right\">" + f.format(runtime.totalMemory()) + "</td></tr>" + "</table></html>";
        }
        return "<html><table><tr><td>free memory</td><td align=\"right\">" + f.format(runtime.freeMemory()) + "</td></tr>" + "<tr><td>total memory</td>" + "<td align=\"right\">" + f.format(runtime.totalMemory()) + "</td></tr>" + "<tr><td>max memory</td>" + "<td align=\"right\">" + f.format(runtime.maxMemory()) + "</td></tr>" + "<tr><td>available processors</td>" + "<td align=\"right\">" + runtime.availableProcessors() + "</td></tr>" + "</table></html>";
    }
}

