/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class SxBevelBorder
extends AbstractBorder {
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    protected int bevelType;
    protected Color highlightOuter;
    protected Color highlightInner;
    protected Color shadowInner;
    protected Color shadowOuter;
    protected int depth;

    public SxBevelBorder(int bevelType) {
        this.bevelType = bevelType;
        this.depth = 1;
    }

    public SxBevelBorder(int bevelType, Color highlight, Color shadow) {
        this(bevelType, highlight.brighter(), highlight, shadow, shadow.brighter());
    }

    public SxBevelBorder(int bevelType, Color highlightOuterColor, Color highlightInnerColor, Color shadowOuterColor, Color shadowInnerColor) {
        this(bevelType);
        this.highlightOuter = highlightOuterColor;
        this.highlightInner = highlightInnerColor;
        this.shadowOuter = shadowOuterColor;
        this.shadowInner = shadowInnerColor;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.bevelType == 0) {
            this.paintRaisedBevel(c, g, x, y, width, height);
        } else if (this.bevelType == 1) {
            this.paintLoweredBevel(c, g, x, y, width, height);
        }
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(this.depth, this.depth, this.depth, this.depth);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = insets.bottom = this.depth;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    public Color getHighlightOuterColor(Component c) {
        Color highlight = this.getHighlightOuterColor();
        return highlight != null ? highlight : c.getBackground().brighter().brighter();
    }

    public Color getHighlightInnerColor(Component c) {
        Color highlight = this.getHighlightInnerColor();
        return highlight != null ? highlight : c.getBackground().brighter();
    }

    public Color getShadowInnerColor(Component c) {
        Color shadow = this.getShadowInnerColor();
        return shadow != null ? shadow : c.getBackground().darker();
    }

    public Color getShadowOuterColor(Component c) {
        Color shadow = this.getShadowOuterColor();
        return shadow != null ? shadow : c.getBackground().darker().darker();
    }

    public Color getHighlightOuterColor() {
        return this.highlightOuter;
    }

    public Color getHighlightInnerColor() {
        return this.highlightInner;
    }

    public Color getShadowInnerColor() {
        return this.shadowInner;
    }

    public Color getShadowOuterColor() {
        return this.shadowOuter;
    }

    public int getBevelType() {
        return this.bevelType;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    protected void paintRaisedBevel(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        int h = height;
        int w = width;
        g.translate(x, y);
        g.setColor(this.getHighlightOuterColor(c));
        g.drawLine(0, 0, 0, h - 2);
        g.drawLine(1, 0, w - 2, 0);
        g.setColor(this.getShadowOuterColor(c));
        g.drawLine(0, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, 0, w - 1, h - 2);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    protected void paintLoweredBevel(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        int h = height;
        int w = width;
        g.translate(x, y);
        g.setColor(this.getShadowInnerColor(c));
        g.drawLine(0, 0, 0, h - 1);
        g.drawLine(1, 0, w - 1, 0);
        g.setColor(this.getHighlightOuterColor(c));
        g.drawLine(1, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, 1, w - 1, h - 2);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }
}

