/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.sourceforge.swingx.SxResource;
import net.sourceforge.swingx.SxUtilities;

public class SxOptionPane
extends JDialog {
    static final Icon ERROR_ICON;
    static final Icon INFORMATION_ICON;
    static final Icon WARNING_ICON;
    static final Icon QUESTION_ICON;
    public static final int PLAIN_MESSAGE = -1;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int CLOSED = -1;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int ABOUT = 4;
    public static final int RETRY = 8;
    public static final int IGNORE = 16;
    public static final int YES = 32;
    public static final int NO = 61;
    public static final int DEFAULT_OPTION = -1;
    public static final int YES_NO_OPTION = 61;
    public static final int YES_NO_CANCEL_OPTION = 63;
    public static final int OK_CANCEL_OPTION = 3;
    public static final int OK_ONLY_OPTION = 1;
    public static final int ABOUT_RETRY_IGNORE_OPTION = 28;
    public static final int RETRY_CANCEL_OPTION = 10;
    protected int returnValue = -1;
    protected JPanel buttonPanel = new JPanel();
    static final /* synthetic */ boolean $assertionsDisabled;

    public SxOptionPane(JFrame owner, String title, int messageType, int optionType) {
        super(owner, title, true);
        this.init(messageType, optionType);
    }

    public SxOptionPane(JDialog owner, String title, int messageType, int optionType) {
        super(owner, title, true);
        this.init(messageType, optionType);
    }

    public SxOptionPane(JFrame owner, String title) {
        this(owner, title, -1, -1);
    }

    private void init(int messageType, int optionType) {
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel panel = (JPanel)this.getContentPane();
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)this.buttonPanel, "South");
        if (!$assertionsDisabled && messageType != 0 && messageType != 1 && messageType != 2 && messageType != 3 && messageType != -1) {
            throw new AssertionError(messageType);
        }
        if (!$assertionsDisabled && optionType != -1 && optionType != 61 && optionType != 63 && optionType != 3 && optionType != 1 && optionType != 28 && optionType != 10) {
            throw new AssertionError(optionType);
        }
        switch (messageType) {
            case 0: {
                this.setIcon(ERROR_ICON);
                break;
            }
            case 1: {
                this.setIcon(INFORMATION_ICON);
                break;
            }
            case 2: {
                this.setIcon(WARNING_ICON);
                break;
            }
            case 3: {
                this.setIcon(QUESTION_ICON);
                break;
            }
            case -1: {
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError(messageType);
                }
                break;
            }
        }
        KeyStroke.getKeyStroke(27, 0);
        switch (optionType) {
            case -1: {
                break;
            }
            case 61: {
                this.addOptionButton(32, "\u306f\u3044(Y)", true);
                this.addOptionButton(61, "\u3044\u3044\u3048(N)", false);
                break;
            }
            case 63: {
                this.addOptionButton(32, "\u306f\u3044(Y)", true);
                this.addOptionButton(61, "\u3044\u3044\u3048(N)", false);
                this.addOptionButton(2, "\u30ad\u30e3\u30f3\u30bb\u30eb", false);
                break;
            }
            case 3: {
                this.addOptionButton(1, "OK", true);
                this.addOptionButton(2, "\u30ad\u30e3\u30f3\u30bb\u30eb", false);
                break;
            }
            case 1: {
                this.addOptionButton(1, "OK", true);
                break;
            }
            case 28: {
                this.addOptionButton(4, "\u4e2d\u65ad(B)", true);
                this.addOptionButton(8, "\u518d\u5b9f\u884c(R)", false);
                this.addOptionButton(16, "\u7121\u8996(I)", false);
                break;
            }
            case 10: {
                this.addOptionButton(8, "\u518d\u5b9f\u884c(R)", true);
                this.addOptionButton(2, "\u30ad\u30e3\u30f3\u30bb\u30eb", false);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError(optionType);
                }
                break;
            }
        }
    }

    private void addOptionButton(int id, String name2, boolean isDefault) {
        class OptionPaneButtonAction
        extends AbstractAction {
            private int value;

            OptionPaneButtonAction(String name, int value, int mnemonic, KeyStroke stroke) {
                super(name);
                this.value = value;
                if (mnemonic != -1) {
                    this.putValue("MnemonicKey", new Integer(mnemonic));
                }
                if (stroke != null) {
                    this.putValue("AcceleratorKey", stroke);
                }
            }

            public void actionPerformed(ActionEvent event) {
                System.out.println(SxOptionPane.this.getName() + event);
                SxOptionPane.this.dispose();
                SxOptionPane.this.returnValue = this.value;
            }
        }
        OptionPaneButtonAction action = null;
        JButton button = null;
        switch (id) {
            case 1: {
                action = new OptionPaneButtonAction("OK", 1, 75, null);
                button = new JButton(action);
                button.setName("OK");
                this.addButton(button, isDefault);
                break;
            }
            case 2: {
                action = new OptionPaneButtonAction("\u30ad\u30e3\u30f3\u30bb\u30eb", 2, -1, KeyStroke.getKeyStroke(27, 0));
                button = new JButton(action);
                button.setName("CANCEL");
                this.addButton(button, isDefault);
                break;
            }
            case 32: {
                action = new OptionPaneButtonAction("\u306f\u3044(Y)", 32, 89, null);
                button = new JButton(action);
                button.setName("YES");
                this.addButton(button, isDefault);
                break;
            }
            case 61: {
                action = new OptionPaneButtonAction("\u3044\u3044\u3048(N)", 61, 78, null);
                button = new JButton(action);
                button.setName("NO");
                this.addButton(button, isDefault);
                break;
            }
            case 4: {
                action = new OptionPaneButtonAction("\u4e2d\u65ad(B)", 4, 66, null);
                button = new JButton(action);
                button.setName("ABOUT");
                this.addButton(button, isDefault);
                break;
            }
            case 8: {
                action = new OptionPaneButtonAction("\u518d\u5b9f\u884c(R)", 8, 82, null);
                button = new JButton(action);
                button.setName("RETRY");
                this.addButton(button, isDefault);
                break;
            }
            case 16: {
                action = new OptionPaneButtonAction("\u7121\u8996(I)", 16, 73, null);
                button = new JButton(action);
                button.setName("IGNORE");
                this.addButton(button, isDefault);
            }
        }
    }

    public void setIcon(Icon icon) {
        this.getContentPane().add((Component)new JLabel(icon), "West");
    }

    public void setDefaultButton(JButton button) {
        this.getRootPane().setDefaultButton(button);
    }

    public void addButton(JButton button, boolean isDefault) {
        this.buttonPanel.add(button);
        if (isDefault) {
            this.setDefaultButton(button);
        }
    }

    public void addButton(JButton button) {
        this.addButton(button, false);
    }

    public JButton getButton(String value) {
        return (JButton)SxUtilities.getComponent(this, value);
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public static int showMessageDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon) {
        if (!$assertionsDisabled && parentComponent == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && title == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && optionType != -1 && optionType != 61 && optionType != 63 && optionType != 3 && optionType != 1 && optionType != 28 && optionType != 10) {
            throw new AssertionError(optionType);
        }
        if (!$assertionsDisabled && messageType != 0 && messageType != 1 && messageType != 2 && messageType != 3 && messageType != -1) {
            throw new AssertionError(messageType);
        }
        Component owner = SwingUtilities.getRoot(parentComponent);
        SxOptionPane pane = null;
        if (owner instanceof JFrame) {
            pane = new SxOptionPane((JFrame)owner, title, messageType, optionType);
        } else if (owner instanceof JDialog) {
            pane = new SxOptionPane((JDialog)owner, title, messageType, optionType);
        } else if (!$assertionsDisabled) {
            throw new AssertionError(parentComponent);
        }
        if (icon != null) {
            pane.setIcon(icon);
        }
        if (message instanceof JComponent) {
            pane.getContentPane().add((Component)((JComponent)message), "Center");
        } else {
            pane.getContentPane().add((Component)new JLabel(message.toString()), "Center");
        }
        pane.pack();
        pane.setLocationRelativeTo(owner);
        pane.setVisible(true);
        return pane.getReturnValue();
    }

    static {
        $assertionsDisabled = !SxOptionPane.class.desiredAssertionStatus();
        ERROR_ICON = SxResource.getImageIcon("/javax/swing/plaf/metal/icons/Error.gif");
        INFORMATION_ICON = SxResource.getImageIcon("/javax/swing/plaf/metal/icons/Inform.gif");
        WARNING_ICON = SxResource.getImageIcon("/javax/swing/plaf/metal/icons/Warn.gif");
        QUESTION_ICON = SxResource.getImageIcon("/javax/swing/plaf/metal/icons/Question.gif");
    }
}

