/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;

public class SxTextUtilities {
    public static String dump(byte[] data) {
        StringBuffer result = new StringBuffer("ADDRESS  +0 +1 +2 +3 +4 +5 +6 +7 +8 +9 +A +B +C +D +E +F 0123456789ABCDEF\n");
        for (int i = 0; i < data.length; i += 16) {
            String address = SxTextUtilities.toHexString(i, 8);
            StringBuffer hex = new StringBuffer();
            for (int j = 0; j < 16; ++j) {
                if (i + j < data.length) {
                    hex.append(SxTextUtilities.toHexString(data[i + j], 2)).append(" ");
                    continue;
                }
                hex.append("   ");
            }
            StringBuffer chr = new StringBuffer();
            for (int j = 0; j < 16 && i + j < data.length; ++j) {
                if (data[i + j] >= 32 && data[i + j] <= 126) {
                    chr.append((char)data[i + j]);
                    continue;
                }
                chr.append("?");
            }
            result.append(address).append(" ").append(hex).append(chr).append("\n");
        }
        return result.toString();
    }

    public static String toHexString(int x, int len) {
        if (len <= 0) {
            return "";
        }
        return SxTextUtilities.toHexString(x >> 4, len - 1) + "0123456789ABCDEF".charAt(x & 0xF);
    }

    public static boolean equalsString(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static int compareString(String str1, String str2) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        return str1.compareTo(str2);
    }

    public static String getStackTraceString(Throwable th) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        th.printStackTrace(pw);
        return sw.toString();
    }

    public static String replace(String str, String src, String dst) {
        int pos;
        String newStr = "";
        int lastpos = 0;
        while ((pos = str.indexOf(src, lastpos)) != -1) {
            newStr = newStr + str.substring(lastpos, pos);
            newStr = newStr + dst;
            lastpos = pos + src.length();
        }
        return newStr + str.substring(lastpos);
    }

    public static String decodeXml(String str) {
        if (str.compareTo("<null/>") == 0) {
            return null;
        }
        str = SxTextUtilities.replace(str, "&lt;", "<");
        str = SxTextUtilities.replace(str, "&gt;", ">");
        str = SxTextUtilities.replace(str, "&quot;", "\"");
        str = SxTextUtilities.replace(str, "&amp;", "&");
        return str;
    }

    public static String encodeXml(String str) {
        if (str == null) {
            return "<null/>";
        }
        str = SxTextUtilities.replace(str, "&", "&amp;");
        str = SxTextUtilities.replace(str, "<", "&lt;");
        str = SxTextUtilities.replace(str, ">", "&gt;");
        str = SxTextUtilities.replace(str, "\"", "&quot;");
        return str;
    }

    public static String[] splitLine(String text) {
        ArrayList<String> list = new ArrayList<String>();
        int pos = text.indexOf("\n");
        while (pos != -1) {
            list.add(text.substring(0, pos + 1));
            text = text.substring(pos + 1);
            pos = text.indexOf("\n");
        }
        if (text.length() > 0) {
            list.add(text);
        }
        String[] result = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = (String)list.get(i);
        }
        return result;
    }

    public static int[] getLineColumnIndex(String text, int pos) {
        int line = 0;
        int col = 0;
        for (int i = 0; i < pos; ++i) {
            if (text.charAt(i) == '\n') {
                ++line;
                col = 0;
                continue;
            }
            ++col;
        }
        return new int[]{line, col};
    }

    public static int search(boolean[] array, boolean value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }
}

