/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;

public class SxUtilities {
    static Graphics2D image_g2;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Rectangle2D.Float getTextRectangle(Graphics2D g2, String text, Font font) {
        if (g2 == null) {
            g2 = image_g2;
        }
        if (!($assertionsDisabled || text != null && text.length() > 0)) {
            throw new AssertionError((Object)text);
        }
        FontRenderContext frc = g2.getFontRenderContext();
        TextLayout tl = new TextLayout(text, font, frc);
        return new Rectangle2D.Float(0.0f, -tl.getAscent(), tl.getAdvance(), tl.getAscent() + tl.getDescent());
    }

    public static void addMenuItems(JTextComponent comp, JPopupMenu popup) {
        if (!$assertionsDisabled && comp == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && popup == null) {
            throw new AssertionError();
        }
        ActionMap map = comp.getActionMap();
        boolean isEditable = comp.isEditable();
        if (comp instanceof JPasswordField) {
            popup.add(SxUtilities.createMenuItem(map.get("paste-from-clipboard"), "\u8cbc\u308a\u4ed8\u3051(P)", 80, isEditable));
            popup.addSeparator();
            popup.add(SxUtilities.createMenuItem(map.get("select-all"), "\u3059\u3079\u3066\u9078\u629e(A)", 65, true));
        } else {
            Action undo = map.get("Undo");
            Action redo = map.get("Redo");
            if (undo != null || redo != null) {
                if (undo != null) {
                    popup.add(SxUtilities.createMenuItem(undo, "\u5143\u306b\u623b\u3059(U)", 85, isEditable));
                }
                if (redo != null) {
                    popup.add(SxUtilities.createMenuItem(redo, "\u3084\u308a\u76f4\u3057(R)", 82, isEditable));
                }
                popup.addSeparator();
            }
            popup.add(SxUtilities.createMenuItem(map.get("cut-to-clipboard"), "\u5207\u308a\u53d6\u308a(T)", 84, isEditable));
            popup.add(SxUtilities.createMenuItem(map.get("copy-to-clipboard"), "\u30b3\u30d4\u30fc(C)", 67, true));
            popup.add(SxUtilities.createMenuItem(map.get("paste-from-clipboard"), "\u8cbc\u308a\u4ed8\u3051(P)", 80, isEditable));
            popup.addSeparator();
            popup.add(SxUtilities.createMenuItem(map.get("select-all"), "\u3059\u3079\u3066\u9078\u629e(A)", 65, true));
        }
    }

    private static JMenuItem createMenuItem(Action action, String text, int mnemonic, boolean enable) {
        if (!$assertionsDisabled && action == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && text == null) {
            throw new AssertionError();
        }
        JMenuItem menu = new JMenuItem(action);
        menu.setText(text);
        menu.setMnemonic(mnemonic);
        menu.setEnabled(enable);
        KeyStroke ks = (KeyStroke)action.getValue("AcceleratorKey");
        if (ks != null) {
            menu.setAccelerator(ks);
        }
        return menu;
    }

    public static void addPopupMenuMouseListener(JTextComponent comp) {
        if (!$assertionsDisabled && comp == null) {
            throw new AssertionError();
        }
        comp.addMouseListener(new TextComponentMouseListener(comp));
    }

    public static void setUndoRedoAction(JTextComponent comp) {
        SxUndoableEditorListener listener = new SxUndoableEditorListener();
        comp.getDocument().addUndoableEditListener(listener);
        ActionMap amap = comp.getActionMap();
        amap.put("Undo", listener.undoAction);
        amap.put("Redo", listener.redoAction);
        InputMap imap = comp.getInputMap();
        imap.put(KeyStroke.getKeyStroke(90, 2), "Undo");
        imap.put(KeyStroke.getKeyStroke(89, 2), "Redo");
    }

    public static Component getComponent(Component parent, String name) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (name.equals(parent.getName())) {
            return parent;
        }
        if (parent instanceof Container) {
            Container c = (Container)parent;
            for (int i = 0; i < c.getComponentCount(); ++i) {
                Component ret = SxUtilities.getComponent(c.getComponent(i), name);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    static {
        $assertionsDisabled = !SxUtilities.class.desiredAssertionStatus();
        image_g2 = new BufferedImage(1, 1, 6).createGraphics();
    }

    private static class SxUndoableEditorListener
    implements UndoableEditListener {
        UndoManager undoManager = new UndoManager();
        RedoAction redoAction = new RedoAction();
        UndoLastAction undoAction = new UndoLastAction();

        private SxUndoableEditorListener() {
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            this.undoManager.addEdit(e.getEdit());
            this.undoAction.update();
            this.redoAction.update();
        }

        private class UndoLastAction
        extends AbstractAction {
            public UndoLastAction() {
                super("Undo");
                this.update();
            }

            public void actionPerformed(ActionEvent e) {
                SxUndoableEditorListener.this.undoManager.undo();
                SxUndoableEditorListener.this.redoAction.update();
                this.update();
            }

            public void update() {
                boolean canUndo = SxUndoableEditorListener.this.undoManager.canUndo();
                if (canUndo) {
                    this.setEnabled(true);
                    this.putValue("Name", SxUndoableEditorListener.this.undoManager.getUndoPresentationName());
                } else {
                    this.setEnabled(false);
                    this.putValue("Name", "Undo");
                }
            }
        }

        private class RedoAction
        extends AbstractAction {
            public RedoAction() {
                super("Redo");
                this.update();
            }

            public void actionPerformed(ActionEvent e) {
                SxUndoableEditorListener.this.undoManager.redo();
                SxUndoableEditorListener.this.undoAction.update();
                this.update();
            }

            public void update() {
                boolean canRedo = SxUndoableEditorListener.this.undoManager.canRedo();
                if (canRedo) {
                    this.setEnabled(true);
                    this.putValue("Name", SxUndoableEditorListener.this.undoManager.getRedoPresentationName());
                } else {
                    this.setEnabled(false);
                    this.putValue("Name", "Redo");
                }
            }
        }
    }

    static class TextComponentMouseListener
    extends MouseAdapter {
        final JTextComponent comp;
        static final /* synthetic */ boolean $assertionsDisabled;

        TextComponentMouseListener(JTextComponent comp) {
            if (!$assertionsDisabled && comp == null) {
                throw new AssertionError();
            }
            this.comp = comp;
        }

        public void mousePressed(MouseEvent ev) {
            if (ev.isPopupTrigger()) {
                this.showPopupMenu(ev);
            }
        }

        public void mouseReleased(MouseEvent ev) {
            if (ev.isPopupTrigger()) {
                this.showPopupMenu(ev);
            }
        }

        private void showPopupMenu(MouseEvent ev) {
            JPopupMenu popup = new JPopupMenu();
            SxUtilities.addMenuItems(this.comp, popup);
            popup.show(this.comp, ev.getX(), ev.getY());
        }

        static {
            $assertionsDisabled = !(class$net$sourceforge$swingx$SxUtilities == null ? (class$net$sourceforge$swingx$SxUtilities = SxUtilities.class$("net.sourceforge.swingx.SxUtilities")) : class$net$sourceforge$swingx$SxUtilities).desiredAssertionStatus();
        }
    }
}

