/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx.jspread;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import net.sourceforge.swingx.Logger;
import net.sourceforge.swingx.jspread.JSpreadActions;
import net.sourceforge.swingx.jspread.JSpreadCellEditor;
import net.sourceforge.swingx.jspread.JSpreadCellRenderer;
import net.sourceforge.swingx.jspread.JSpreadConstant;
import net.sourceforge.swingx.jspread.JSpreadControllerBuilder;
import net.sourceforge.swingx.jspread.JSpreadControllerCellEditor;
import net.sourceforge.swingx.jspread.JSpreadControllerCellRenderer;
import net.sourceforge.swingx.jspread.JSpreadControllerHeader;
import net.sourceforge.swingx.jspread.JSpreadControllerHeaderData;
import net.sourceforge.swingx.jspread.JSpreadHeader;
import net.sourceforge.swingx.jspread.JSpreadProperty;
import net.sourceforge.swingx.jspread.JSpreadSelectionEvent;
import net.sourceforge.swingx.jspread.JSpreadSelectionListener;
import net.sourceforge.swingx.jspread.JSpreadSheet;
import net.sourceforge.swingx.jspread.JSpreadUtilities;

public class JSpread
extends JPanel
implements JSpreadConstant {
    static Logger logger;
    JSpreadSheet sheet;
    JSpreadProperty properties = new JSpreadProperty();
    private ArrayList selectionListeners = null;
    JSpreadControllerHeaderData headerDataController = new JSpreadControllerHeaderData(this);
    JSpreadControllerBuilder viewController = new JSpreadControllerBuilder(this);
    JSpreadControllerHeader headerController = new JSpreadControllerHeader(this);
    JSpreadControllerCellRenderer rendererController = new JSpreadControllerCellRenderer(this);
    JSpreadControllerCellEditor editorController = new JSpreadControllerCellEditor(this);
    static final /* synthetic */ boolean $assertionsDisabled;

    public JSpread() {
        this(256, 256);
    }

    public JSpread(int numRows, int numCols) {
        if (!$assertionsDisabled && numRows < 0) {
            throw new AssertionError(numRows);
        }
        if (!$assertionsDisabled && numCols < 0) {
            throw new AssertionError(numCols);
        }
        this.sheet = new JSpreadSheet(this, "Sheet", numRows, numCols);
        ActionMap actionmap = this.getActionMap();
        JSpreadActions.SelectAllAction selectAllAction = new JSpreadActions.SelectAllAction(this);
        JSpreadActions.CopyClipboardAction copyClipboardAction = new JSpreadActions.CopyClipboardAction(this);
        actionmap.put("SelectAllAction", selectAllAction);
        actionmap.put("CopyClipboardAction", copyClipboardAction);
        InputMap inputmap = this.getInputMap(1);
        inputmap.put(KeyStroke.getKeyStroke(65, 2), "SelectAllAction");
        inputmap.put(KeyStroke.getKeyStroke(67, 2), "CopyClipboardAction");
        this.setOpaque(true);
        this.setAutoscrolls(true);
    }

    public JSpreadSheet getSheet() {
        return this.sheet;
    }

    public Object getValueAt(int rowDataIndex, int colDataIndex) {
        if (!$assertionsDisabled && 0 > rowDataIndex) {
            throw new AssertionError(rowDataIndex);
        }
        if (!$assertionsDisabled && 0 > colDataIndex) {
            throw new AssertionError(colDataIndex);
        }
        Object obj = this.sheet.getValueAt(rowDataIndex, colDataIndex);
        return obj;
    }

    public void setValueAt(Object value, int rowDataIndex, int colDataIndex) {
        if (!$assertionsDisabled && 0 > rowDataIndex) {
            throw new AssertionError(rowDataIndex);
        }
        if (!$assertionsDisabled && 0 > colDataIndex) {
            throw new AssertionError(colDataIndex);
        }
        this.sheet.setValueAt(value, rowDataIndex, colDataIndex);
    }

    public Object getHeaderValueAt(int header, int dataIndex) {
        logger.debug("enter");
        if (!$assertionsDisabled && header == 1 && header == 2) {
            throw new AssertionError(header);
        }
        if (!$assertionsDisabled && 0 > dataIndex) {
            throw new AssertionError(dataIndex);
        }
        Object obj = this.sheet.getHeaderValueAt(header, dataIndex);
        logger.debug("exit");
        return obj;
    }

    public void setHeaderValueAt(Object value, int header, int dataIndex) {
        logger.debug("enter");
        if (!$assertionsDisabled && header == 1 && header == 2) {
            throw new AssertionError(header);
        }
        if (!$assertionsDisabled && 0 > dataIndex) {
            throw new AssertionError(dataIndex);
        }
        logger.debug("setHeaderValueAt() value=" + value + " header=" + header + " dataIndex=" + dataIndex);
        this.sheet.setHeaderValueAt(value, header, dataIndex);
        logger.debug("exit");
    }

    public Object getCornerValue() {
        return this.sheet.getCornerValue();
    }

    public void setCornerValue(Object value) {
        logger.debug("setCornerValue() value=" + value);
        this.sheet.setCornerValue(value);
        logger.debug("exit");
    }

    public int getCellCount(int orientation) {
        logger.debug("enter");
        if (!$assertionsDisabled && orientation != 1 && orientation != 2) {
            throw new AssertionError(orientation);
        }
        int count = this.sheet.getCellCount(orientation);
        logger.debug("exit");
        return count;
    }

    public void setCellCount(int rowCount, int colCount, Object initValue) {
        logger.debug("enter");
        if (!$assertionsDisabled && rowCount < 0) {
            throw new AssertionError(rowCount);
        }
        if (!$assertionsDisabled && colCount < 0) {
            throw new AssertionError(colCount);
        }
        this.sheet.setCellCount(rowCount, colCount, initValue);
        this.revalidate();
        JSpreadSheet.CurrentFocus prev = this.sheet.getCurrentFocus();
        this.sheet.focusCol = Math.min(this.sheet.focusCol, colCount - 1);
        this.sheet.focusRow = Math.min(this.sheet.focusRow, rowCount - 1);
        this.sheet.curCol = Math.min(this.sheet.curCol, colCount - 1);
        this.sheet.curRow = Math.min(this.sheet.curRow, rowCount - 1);
        JSpreadSheet.CurrentFocus next = this.sheet.getCurrentFocus();
        if (!prev.equals(next)) {
            this.fireSelectionListener(new JSpreadSelectionEvent(this, prev, next));
        }
        logger.debug("exit");
    }

    public void insertValueAt(Object value, int header, int dataIndex, int count, Object headerValue) {
        if (!$assertionsDisabled && header == 1 && header == 2) {
            throw new AssertionError(header);
        }
        if (!$assertionsDisabled && 0 > dataIndex && dataIndex != -1) {
            throw new AssertionError(dataIndex);
        }
        if (!$assertionsDisabled && 1 > count) {
            throw new AssertionError(count);
        }
        logger.debug("insertValueAt() value=" + value + " header=" + header + " dataIndex=" + dataIndex + " count=" + count + " headerValue=" + headerValue);
        this.sheet.insertValueAt(value, header, dataIndex, count, headerValue);
    }

    public JSpreadHeader getHeader(int header) {
        if (!$assertionsDisabled && header == 1 && header == 2) {
            throw new AssertionError(header);
        }
        return header == 1 ? this.sheet.rowHeader : this.sheet.colHeader;
    }

    public JComponent createView() {
        this.viewController.createView(this);
        return this;
    }

    public JPanel createScrollView(int vsbPolicy, int hsbPolicy) {
        logger.debug("enter");
        if (!$assertionsDisabled && vsbPolicy != 20 && vsbPolicy != 21 && vsbPolicy != 22) {
            throw new AssertionError(vsbPolicy);
        }
        if (!$assertionsDisabled && hsbPolicy != 30 && hsbPolicy != 31 && hsbPolicy != 32) {
            throw new AssertionError(hsbPolicy);
        }
        this.viewController.createScrollView(this, vsbPolicy, hsbPolicy);
        logger.debug("exit");
        return this;
    }

    public JPanel createScrollView() {
        return this.createScrollView(20, 30);
    }

    public JComponent getComponent(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        JComponent comp = JSpreadUtilities.getComponent(this, name);
        if (!$assertionsDisabled && comp == null) {
            throw new AssertionError((Object)name);
        }
        return comp;
    }

    public void hideHeader(int rowOrColumn, int viewpos1, int viewpos2) {
        if (!$assertionsDisabled && rowOrColumn != 1 && rowOrColumn != 2) {
            throw new AssertionError(rowOrColumn);
        }
        if (!$assertionsDisabled && 0 > viewpos1) {
            throw new AssertionError(viewpos1);
        }
        if (!$assertionsDisabled && 0 > viewpos2) {
            throw new AssertionError(viewpos2);
        }
        this.headerController.hideHeader(rowOrColumn, viewpos1, viewpos2);
    }

    public void showHeaderAll(int rowOrColumn) {
        if (!$assertionsDisabled && rowOrColumn != 1 && rowOrColumn != 2 && rowOrColumn != 3) {
            throw new AssertionError(rowOrColumn);
        }
        this.headerController.showHeaderAll(rowOrColumn);
    }

    public int getViewPositionAtPoint(int rowOrColumn, int xy) {
        if (!$assertionsDisabled && rowOrColumn != 1 && rowOrColumn != 2) {
            throw new AssertionError(rowOrColumn);
        }
        return rowOrColumn == 1 ? this.sheet.rowHeader.getViewPositionAtPoint(xy) : this.sheet.colHeader.getViewPositionAtPoint(xy);
    }

    public JSpreadCellRenderer getCellRenderer(Object value, int rowDataIndex, int columnDataIndex) {
        if (!$assertionsDisabled && 0 > rowDataIndex) {
            throw new AssertionError(rowDataIndex);
        }
        if (!$assertionsDisabled && 0 > columnDataIndex) {
            throw new AssertionError(columnDataIndex);
        }
        return this.rendererController.getCellRenderer(value, rowDataIndex, columnDataIndex);
    }

    public JSpreadCellRenderer getHeaderRenderer(Object value, int header, int dataIndex) {
        if (!$assertionsDisabled && header != 1 && header != 2 && header != 3) {
            throw new AssertionError(header);
        }
        if (!$assertionsDisabled && 0 > dataIndex) {
            throw new AssertionError(dataIndex);
        }
        return this.rendererController.getHeaderRenderer(value, header, dataIndex);
    }

    public boolean isCellEditable(int rowDataIndex, int colDataIndex) {
        if (!$assertionsDisabled && 0 > rowDataIndex) {
            throw new AssertionError(rowDataIndex);
        }
        if (!$assertionsDisabled && 0 > colDataIndex) {
            throw new AssertionError(colDataIndex);
        }
        return this.editorController.isCellEditable(rowDataIndex, colDataIndex);
    }

    public boolean editCellAt(int rowViewIndex, int colViewIndex, EventObject event) {
        logger.debug("editCellAt() enter");
        boolean rc = this.editorController.editCellAt(rowViewIndex, colViewIndex, event);
        logger.debug("editCellAt() exit rc=" + rc);
        return rc;
    }

    public JSpreadCellEditor getCellEditor(Object value, int rowDataIndex, int colDataIndex) {
        return this.editorController.getCellEditor(value, rowDataIndex, colDataIndex);
    }

    public boolean stopCellEditing() {
        return this.editorController.stopCellEditing();
    }

    public void cancelCellEditing() {
        this.editorController.cancelCellEditing();
    }

    public boolean isEditing() {
        return this.editorController.isEditing();
    }

    public JComponent getEditorComponent() {
        return this.editorController.getEditorComponent();
    }

    public static void putClassProperty(String key, Object value) {
        JSpreadProperty.classProperties.put(key, value);
    }

    public void putObjectProperty(String key, Object value) {
        this.properties.objectProperties.put(key, value);
    }

    public int getFocusColumn() {
        return this.sheet.focusCol;
    }

    public void setFocusColumn(int column) {
        this.sheet.focusCol = column;
    }

    public int getFocusRow() {
        return this.sheet.focusRow;
    }

    public void setFocusRow(int row) {
        this.sheet.focusRow = row;
    }

    public int getCurrentColumn() {
        return this.sheet.curCol;
    }

    public void setCurrentColumn(int column) {
        this.sheet.curCol = column;
    }

    public int getCurrentRow() {
        return this.sheet.curRow;
    }

    public void setCurrentRow(int row) {
        this.sheet.curRow = row;
    }

    public int getViewCount(int header) {
        if (!$assertionsDisabled && header != 2 && header != 1) {
            throw new AssertionError(header);
        }
        return header == 2 ? this.sheet.colHeader.getViewCount() : this.sheet.rowHeader.getViewCount();
    }

    public void setAutoResizeMode(int header, int mode) {
        if (!$assertionsDisabled && header != 2 && header != 1 && header != 3) {
            throw new AssertionError(header);
        }
        if (!$assertionsDisabled && mode != 0 && mode != 1 && mode != 3) {
            throw new AssertionError(mode);
        }
        if ((header & 2) != 0) {
            this.sheet.colHeader.autoResizeMode = mode;
        }
        if ((header & 1) != 0) {
            this.sheet.rowHeader.autoResizeMode = mode;
        }
    }

    public boolean getHeaderVisible(int header) {
        if (!$assertionsDisabled && header != 2 && header != 1) {
            throw new AssertionError(header);
        }
        return header == 2 ? this.sheet.colHeaderVisible : this.sheet.rowHeaderVisible;
    }

    public void setHeaderVisible(int header, boolean visible) {
        if (!$assertionsDisabled && header != 1 && header != 2 && header != 3) {
            throw new AssertionError(header);
        }
        if ((header & 1) != 0) {
            this.sheet.rowHeaderVisible = visible;
        }
        if ((header & 2) != 0) {
            this.sheet.colHeaderVisible = visible;
        }
    }

    public void setCellSelection(int rowViewIndex, int colViewIndex, boolean sel) {
        if (!($assertionsDisabled || 0 <= rowViewIndex && rowViewIndex < this.getViewCount(1))) {
            throw new AssertionError(rowViewIndex);
        }
        if (!($assertionsDisabled || 0 <= colViewIndex && colViewIndex < this.getViewCount(2))) {
            throw new AssertionError(colViewIndex);
        }
        this.sheet.cellSelection[rowViewIndex][colViewIndex] = sel;
    }

    public boolean getCellSelection(int rowViewIndex, int colViewIndex) {
        if (!($assertionsDisabled || 0 <= rowViewIndex && rowViewIndex < this.getViewCount(1))) {
            throw new AssertionError(rowViewIndex);
        }
        if (!($assertionsDisabled || 0 <= colViewIndex && colViewIndex < this.getViewCount(2))) {
            throw new AssertionError(colViewIndex);
        }
        return this.sheet.getSelection(rowViewIndex, colViewIndex);
    }

    public boolean getHeaderSelection(int orientation, int viewIndex) {
        if (!$assertionsDisabled && orientation != 1 && orientation != 2) {
            throw new AssertionError(orientation);
        }
        if (!($assertionsDisabled || 0 <= viewIndex && viewIndex < this.getViewCount(orientation))) {
            throw new AssertionError(viewIndex);
        }
        return this.sheet.getHeaderSelection(orientation, viewIndex);
    }

    public int[] getHeaderSelections(int orientation) {
        if (!$assertionsDisabled && orientation != 1 && orientation != 2) {
            throw new AssertionError(orientation);
        }
        int count = 0;
        for (int i = 0; i < this.getViewCount(orientation); ++i) {
            if (!this.getHeaderSelection(orientation, i)) continue;
            ++count;
        }
        int[] result = new int[count];
        int j = 0;
        for (int i = 0; i < this.getViewCount(orientation); ++i) {
            if (!this.getHeaderSelection(orientation, i)) continue;
            result[j++] = i;
        }
        return result;
    }

    public void addSelectionListener(JSpreadSelectionListener listener) {
        logger.debug(listener);
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList();
        }
        this.selectionListeners.add(listener);
    }

    void fireSelectionListener(JSpreadSelectionEvent e) {
        if (!$assertionsDisabled && e == null) {
            throw new AssertionError();
        }
        if (this.selectionListeners == null) {
            return;
        }
        for (int i = 0; i < this.selectionListeners.size(); ++i) {
            JSpreadSelectionListener listener = (JSpreadSelectionListener)this.selectionListeners.get(i);
            logger.debug(listener);
            listener.valueChanged(e);
        }
    }

    public void \u518d\u63cf\u753b() {
        logger.debug("enter \u518d\u63cf\u753b()");
        this.repaint();
        logger.debug("exit");
    }

    public void \u518d\u914d\u7f6e() {
        logger.debug("enter \u518d\u914d\u7f6e()");
        this.revalidate();
        if (this.getComponent(0) instanceof JScrollPane) {
            JScrollPane sp = (JScrollPane)this.getComponent(0);
            JComponent c = (JComponent)sp.getViewport().getView();
            c.revalidate();
        }
        this.\u518d\u63cf\u753b();
        logger.debug("exit");
    }

    public void setToolTipEnabled(String panename, boolean enabled) {
        if (!$assertionsDisabled && panename == null) {
            throw new AssertionError();
        }
        this.getComponent(panename).setToolTipText(enabled ? "JSpread" : null);
    }

    protected String getToolTipText(String panename, MouseEvent event) {
        return null;
    }

    public boolean inv() {
        return this.sheet.inv();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("focusCol=" + this.getFocusColumn() + " focusRow=" + this.getFocusRow() + "\n");
        sb.append("curCol=" + this.getCurrentColumn() + " curRow=" + this.getCurrentRow() + "\n");
        JComponent comp = this.getComponent("CellPane");
        sb.append("CellPane.bounds=" + comp.getBounds() + "\n");
        comp = this.getComponent("RowHeaderPane");
        sb.append("RowHeaderPane.bounds=" + comp.getBounds() + "\n");
        sb.append("inv=" + this.inv());
        return sb.toString();
    }

    public static void main(String[] args) {
        JSpread spread = new JSpread(10, 10);
        JFrame frame = new JFrame("HelloJSpread");
        spread.setValueAt("Hello", 0, 0);
        spread.setValueAt("JSpread", 0, 1);
        spread.createView();
        spread.doLayout();
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)spread, "Center");
        frame.setDefaultCloseOperation(3);
        frame.setSize(480, 200);
        frame.setVisible(true);
    }

    static {
        $assertionsDisabled = !JSpread.class.desiredAssertionStatus();
        logger = Logger.getLogger(JSpread.class);
    }
}

