/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx.jspread;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.sourceforge.swingx.Logger;
import net.sourceforge.swingx.jspread.JSpreadUtilities;

public class JSpread2x2Panel
extends JPanel {
    static Logger logger;
    final JComponent[][] pane;
    final int fixRow;
    final int fixCol;
    static final /* synthetic */ boolean $assertionsDisabled;

    JSpread2x2Panel(int fixRow, int fixCol) {
        if (!$assertionsDisabled && fixRow != 0 && fixRow != 1) {
            throw new AssertionError(fixRow);
        }
        if (!$assertionsDisabled && fixCol != 0 && fixCol != 1) {
            throw new AssertionError(fixCol);
        }
        this.fixRow = fixRow;
        this.fixCol = fixCol;
        this.pane = new JComponent[2][2];
        Dimension dim = new Dimension(1, 1);
        this.pane[0][0] = new Box.Filler(dim, dim, dim);
        this.pane[0][1] = new Box.Filler(dim, dim, dim);
        this.pane[1][0] = new Box.Filler(dim, dim, dim);
        this.pane[1][1] = new Box.Filler(dim, dim, dim);
        this.setLayout(new JFixSplitInsideLayoutManager());
    }

    public void setPane(int row, int col, JComponent comp) {
        if (!($assertionsDisabled || 0 <= row && row < 2)) {
            throw new AssertionError(row);
        }
        if (!($assertionsDisabled || 0 <= col && col < 2)) {
            throw new AssertionError(col);
        }
        if (!$assertionsDisabled && comp == null) {
            throw new AssertionError(comp);
        }
        if (this.pane[row][col] != null) {
            this.remove(this.pane[row][col]);
        }
        this.pane[row][col] = comp;
        this.add(comp);
    }

    public String toString() {
        return "JSpread2x2Panel[\npane[0][0]=" + JSpreadUtilities.toString(this.pane[0][0].getBounds()) + "\n" + "pane[0][1]=" + JSpreadUtilities.toString(this.pane[0][1].getBounds()) + "\n" + "pane[1][0]=" + JSpreadUtilities.toString(this.pane[1][0].getBounds()) + "\n" + "pane[1][1]=" + JSpreadUtilities.toString(this.pane[1][1].getBounds()) + "\n" + "]\n";
    }

    static {
        $assertionsDisabled = !JSpread2x2Panel.class.desiredAssertionStatus();
        logger = Logger.getLogger(JSpread2x2Panel.class);
    }

    class JFixSplitInsideLayoutManager
    implements LayoutManager {
        JFixSplitInsideLayoutManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                logger.debug("target=" + target.getSize());
                Insets insets = target.getInsets();
                int x0 = insets.left;
                int y0 = insets.top;
                int x9 = target.getWidth() - insets.right;
                int y9 = target.getHeight() - insets.bottom;
                int w = Math.max(JSpread2x2Panel.this.pane[0][JSpread2x2Panel.this.fixCol].getPreferredSize().width, JSpread2x2Panel.this.pane[1][JSpread2x2Panel.this.fixCol].getPreferredSize().width);
                int h = Math.max(JSpread2x2Panel.this.pane[JSpread2x2Panel.this.fixRow][0].getPreferredSize().height, JSpread2x2Panel.this.pane[JSpread2x2Panel.this.fixRow][1].getPreferredSize().height);
                int x5 = JSpread2x2Panel.this.fixCol == 0 ? x0 + w : x9 - w;
                int y5 = JSpread2x2Panel.this.fixRow == 0 ? y0 + h : y9 - h;
                JSpread2x2Panel.this.pane[0][0].setBounds(x0, y0, x5 - x0, y5 - y0);
                JSpread2x2Panel.this.pane[0][1].setBounds(x5, y0, x9 - x5, y5 - y0);
                JSpread2x2Panel.this.pane[1][0].setBounds(x0, y5, x5 - x0, y9 - y5);
                JSpread2x2Panel.this.pane[1][1].setBounds(x5, y5, x9 - x5, y9 - y5);
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension d00 = JSpread2x2Panel.this.pane[0][0].getMinimumSize();
            Dimension d01 = JSpread2x2Panel.this.pane[0][1].getMinimumSize();
            Dimension d10 = JSpread2x2Panel.this.pane[1][0].getMinimumSize();
            Dimension d11 = JSpread2x2Panel.this.pane[1][1].getMinimumSize();
            return new Dimension(Math.max(d00.width, d10.width) + Math.max(d01.width, d11.width), Math.max(d00.height, d01.height) + Math.max(d10.height, d11.height));
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension d00 = JSpread2x2Panel.this.pane[0][0].getPreferredSize();
            Dimension d01 = JSpread2x2Panel.this.pane[0][1].getPreferredSize();
            Dimension d10 = JSpread2x2Panel.this.pane[1][0].getPreferredSize();
            Dimension d11 = JSpread2x2Panel.this.pane[1][1].getPreferredSize();
            return new Dimension(Math.max(d00.width, d10.width) + Math.max(d01.width, d11.width), Math.max(d00.height, d01.height) + Math.max(d10.height, d11.height));
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }
    }
}

