/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx.jspread;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import net.sourceforge.swingx.jspread.JSpread;
import net.sourceforge.swingx.jspread.JSpreadHeader;

public class JSpreadActions {

    static class CopyClipboardAction
    extends AbstractAction {
        private final JSpread spread;

        public CopyClipboardAction(JSpread spread) {
            super("\u30b3\u30d4\u30fc(C)");
            this.putValue("MnemonicKey", new Integer(67));
            this.putValue("ShortDescription", "\u9078\u629e\u3055\u308c\u305f\u7bc4\u56f2\u3092TAB\u533a\u5207\u308a\u3067\u30b3\u30d4\u30fc\u3057\u307e\u3059");
            this.putValue("LongDescription", "\u9078\u629e\u3055\u308c\u305f\u7bc4\u56f2\u3092TAB\u533a\u5207\u308a\u3067\u30b3\u30d4\u30fc\u3057\u307e\u3059");
            this.putValue("SmallIcon", spread.properties.getImageIcon("CUT_ICON"));
            this.spread = spread;
        }

        public void actionPerformed(ActionEvent ev) {
            System.out.println("JSpreadActions.CopyClipboardAction");
            int minRow = Integer.MAX_VALUE;
            int minCol = Integer.MAX_VALUE;
            int maxRow = Integer.MIN_VALUE;
            int maxCol = Integer.MIN_VALUE;
            JSpreadHeader rowHeader = this.spread.getHeader(1);
            JSpreadHeader colHeader = this.spread.getHeader(2);
            for (int r = 0; r < rowHeader.getViewCount(); ++r) {
                for (int c = 0; c < colHeader.getViewCount(); ++c) {
                    if (!this.spread.getCellSelection(r, c)) continue;
                    minRow = Math.min(minRow, r);
                    minCol = Math.min(minCol, c);
                    maxRow = Math.max(maxRow, r);
                    maxCol = Math.max(maxCol, c);
                }
            }
            StringBuffer sb = new StringBuffer();
            for (int r = minRow; r <= maxRow; ++r) {
                for (int c = minCol; c <= maxCol; ++c) {
                    if (this.spread.getCellSelection(r, c)) {
                        int cc = colHeader.getDataIndex(c);
                        int rr = rowHeader.getDataIndex(r);
                        Object val = this.spread.getValueAt(rr, cc);
                        if (val != null) {
                            sb.append(val);
                        }
                    }
                    sb.append("\t");
                }
                sb.append("\n");
            }
            StringSelection ss = new StringSelection(sb.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
        }
    }

    static class SelectAllAction
    extends AbstractAction {
        private final JSpread spread;

        public SelectAllAction(JSpread spread) {
            super("\u3059\u3079\u3066\u3092\u9078\u629e(A)");
            this.putValue("MnemonicKey", new Integer(65));
            this.putValue("ShortDescription", "\u3059\u3079\u3066\u3092\u9078\u629e");
            this.putValue("LongDescription", "\u3059\u3079\u3066\u3092\u9078\u629e");
            this.spread = spread;
        }

        public void actionPerformed(ActionEvent ev) {
            System.out.println("JSpreadActions.SelectAllAction");
            this.spread.sheet.setSelectionAll(true);
            this.spread.repaint();
        }
    }
}

