/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx.jspread;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import net.sourceforge.swingx.Logger;
import net.sourceforge.swingx.jspread.JSpread;
import net.sourceforge.swingx.jspread.JSpreadCellRenderer;

public interface JSpreadCellEditor {
    public void setSpread(JSpread var1);

    public JComponent getCellEditorComponent();

    public Object getCellValue();

    public void setCellValue(Object var1);

    public boolean isCellEditable(EventObject var1);

    public static abstract class ButtonEditor
    implements JSpreadCellRenderer,
    JSpreadCellEditor,
    ActionListener {
        protected JButton button;
        protected JSpread spread;
        protected Object value;
        static final /* synthetic */ boolean $assertionsDisabled;

        public ButtonEditor(JButton button) {
            if (!$assertionsDisabled && button == null) {
                throw new AssertionError();
            }
            this.button = button;
            button.addActionListener(this);
        }

        public JComponent getSpreadCellRendererComponent(JSpread spread, Object value, boolean isSelected, boolean hasFocus, int rowDataIndex, int colDataIndex) {
            return this.button;
        }

        public final void setSpread(JSpread spread) {
            if (!$assertionsDisabled && spread == null) {
                throw new AssertionError();
            }
            this.spread = spread;
        }

        public JComponent getCellEditorComponent() {
            return this.button;
        }

        public Object getCellValue() {
            return this.value;
        }

        public void setCellValue(Object value) {
            this.value = value;
        }

        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        public abstract void actionPerformed(ActionEvent var1);

        static {
            $assertionsDisabled = !(1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor == null ? (1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor = 1.class$("net.sourceforge.swingx.jspread.JSpreadCellEditor")) : 1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor).desiredAssertionStatus();
        }
    }

    public static abstract class ButtonedCellEditor
    extends JPanel
    implements JSpreadCellRenderer,
    JSpreadCellEditor,
    ActionListener {
        private static Logger logger;
        private static final int BUTTON_WIDTH = 15;
        protected JSpread spread;
        protected JComponent comp;
        protected JButton button;
        protected Object value;
        static final /* synthetic */ boolean $assertionsDisabled;

        public ButtonedCellEditor(JComponent comp) {
            if (!$assertionsDisabled && comp == null) {
                throw new AssertionError(comp);
            }
            this.comp = comp;
            this.button = new JButton("...");
            this.add(comp);
            this.add(this.button);
            this.setLayout(new ButtonedCellLayout());
            this.button.addActionListener(this);
        }

        public final void setSpread(JSpread spread) {
            if (!$assertionsDisabled && spread == null) {
                throw new AssertionError();
            }
            this.spread = spread;
        }

        public JComponent getSpreadCellRendererComponent(JSpread spread, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setCellValue(value);
            return this;
        }

        public JComponent getCellEditorComponent() {
            return this;
        }

        public Object getCellValue() {
            return this.value;
        }

        public void setCellValue(Object value) {
            logger.debug("setCellValue() value=" + value);
            this.value = value;
        }

        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        public abstract void actionPerformed(ActionEvent var1);

        static {
            $assertionsDisabled = !(1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor == null ? (1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor = 1.class$("net.sourceforge.swingx.jspread.JSpreadCellEditor")) : 1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor).desiredAssertionStatus();
            logger = Logger.getLogger(1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor$ButtonedCellEditor == null ? (1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor$ButtonedCellEditor = 1.class$("net.sourceforge.swingx.jspread.JSpreadCellEditor$ButtonedCellEditor")) : 1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor$ButtonedCellEditor);
        }

        private class ButtonedCellLayout
        implements LayoutManager {
            private ButtonedCellLayout() {
            }

            public void addLayoutComponent(String name, Component comp) {
            }

            public void removeLayoutComponent(Component comp) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void layoutContainer(Container parent) {
                Object object = parent.getTreeLock();
                synchronized (object) {
                    ButtonedCellEditor.this.comp.setBounds(0, 0, parent.getWidth() - 15, parent.getHeight());
                    ButtonedCellEditor.this.button.setBounds(parent.getWidth() - 15, 0, 15, parent.getHeight());
                }
            }

            public Dimension minimumLayoutSize(Container parent) {
                return parent.getMaximumSize();
            }

            public Dimension preferredLayoutSize(Container parent) {
                return parent.getPreferredSize();
            }
        }
    }

    public static class ComboBoxEditor
    implements JSpreadCellRenderer,
    JSpreadCellEditor,
    ItemListener {
        private static Logger logger;
        protected JSpread spread;
        protected JComboBox comboBox;
        protected Object[] keys;
        protected Object[] values;
        protected Map keyValueMap = new HashMap();
        protected Map valueKeyMap = new HashMap();
        static final /* synthetic */ boolean $assertionsDisabled;

        public ComboBoxEditor(Object[] keys, Object[] values) {
            if (!($assertionsDisabled || keys != null && keys.length > 0)) {
                throw new AssertionError(keys);
            }
            if (!($assertionsDisabled || values != null && values.length > 0)) {
                throw new AssertionError(values);
            }
            if (!$assertionsDisabled && keys.length != values.length) {
                throw new AssertionError((Object)("keys.length=" + keys.length + " values.length=" + values.length));
            }
            this.keys = keys;
            this.values = values;
            for (int i = 0; i < keys.length; ++i) {
                this.keyValueMap.put(keys[i], values[i]);
                this.valueKeyMap.put(values[i], keys[i]);
            }
            this.comboBox = new JComboBox<Object>(values);
            this.comboBox.addItemListener(this);
        }

        public final void setSpread(JSpread spread) {
            if (!$assertionsDisabled && spread == null) {
                throw new AssertionError();
            }
            this.spread = spread;
        }

        public JComponent getSpreadRendererComponent(JSpread spread, Object value, boolean isSelected, boolean hasFocus, int type, int row, int column) {
            this.setCellValue(value);
            return this.comboBox;
        }

        public JComponent getCellEditorComponent() {
            return this.comboBox;
        }

        public Object getCellValue() {
            Object value = this.comboBox.getSelectedItem();
            return this.valueKeyMap.get(value);
        }

        public void setCellValue(Object key) {
            this.comboBox.setSelectedItem(this.keyValueMap.get(key));
        }

        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        public void itemStateChanged(ItemEvent e) {
            logger.debug("itemStateChanged() e=" + e);
            if (this.spread != null && this.spread.isEditing() && this.spread.getEditorComponent() == this.comboBox) {
                this.spread.stopCellEditing();
            }
        }

        static {
            $assertionsDisabled = !(1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor == null ? (1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor = 1.class$("net.sourceforge.swingx.jspread.JSpreadCellEditor")) : 1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor).desiredAssertionStatus();
            logger = Logger.getLogger(1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor$ComboBoxEditor == null ? (1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor$ComboBoxEditor = 1.class$("net.sourceforge.swingx.jspread.JSpreadCellEditor$ComboBoxEditor")) : 1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor$ComboBoxEditor);
        }
    }

    public static class BooleanEditor
    extends CheckBoxEditor {
        public Object getCellValue() {
            return this.checkBox.isSelected();
        }
    }

    public static abstract class CheckBoxEditor
    implements JSpreadCellEditor,
    ActionListener {
        private static Logger logger;
        JCheckBox checkBox = new JCheckBox();
        JSpread spread;
        protected int clickCountToStart = 1;
        static final /* synthetic */ boolean $assertionsDisabled;

        public CheckBoxEditor() {
            this.checkBox.setHorizontalAlignment(0);
            this.checkBox.addActionListener(this);
        }

        public final void setSpread(JSpread spread) {
            if (!$assertionsDisabled && spread == null) {
                throw new AssertionError();
            }
            this.spread = spread;
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
            }
            return true;
        }

        public JComponent getCellEditorComponent() {
            return this.checkBox;
        }

        public void setCellValue(Object value) {
            boolean selected = false;
            if (value instanceof Boolean) {
                selected = (Boolean)value;
            } else if (value instanceof String) {
                selected = value.equals("true");
            }
            this.checkBox.setSelected(selected);
        }

        public abstract Object getCellValue();

        public void actionPerformed(ActionEvent e) {
            logger.debug("actionPerformed() " + e);
            this.spread.stopCellEditing();
        }

        static {
            $assertionsDisabled = !(1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor == null ? (1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor = 1.class$("net.sourceforge.swingx.jspread.JSpreadCellEditor")) : 1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor).desiredAssertionStatus();
            logger = Logger.getLogger(1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor$CheckBoxEditor == null ? (1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor$CheckBoxEditor = 1.class$("net.sourceforge.swingx.jspread.JSpreadCellEditor$CheckBoxEditor")) : 1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor$CheckBoxEditor);
        }
    }

    public static class DateEditor
    extends DefaultCellEditor {
        private static Logger logger;
        protected DateFormat formatter = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        public void setFormat(DateFormat formatter) {
            if (!$assertionsDisabled && formatter == null) {
                throw new AssertionError();
            }
            this.formatter = formatter;
        }

        public void setCellValue(Object value) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance();
            }
            this.textField.setText(value == null ? "" : this.formatter.format(value));
        }

        public Object getCellValue() {
            String s = this.textField.getText();
            try {
                this.value = this.formatter.parse(s);
            }
            catch (ParseException e) {
                logger.debug(s, e);
                this.textField.setBorder(new LineBorder(Color.red));
                return this.value;
            }
            return this.value;
        }

        static {
            $assertionsDisabled = !(1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor == null ? (1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor = 1.class$("net.sourceforge.swingx.jspread.JSpreadCellEditor")) : 1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor).desiredAssertionStatus();
            logger = Logger.getLogger(1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor$DateEditor == null ? (1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor$DateEditor = 1.class$("net.sourceforge.swingx.jspread.JSpreadCellEditor$DateEditor")) : 1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor$DateEditor);
        }
    }

    public static class NumberEditor
    extends DefaultCellEditor {
        public NumberEditor() {
            this.textField.setHorizontalAlignment(4);
        }
    }

    public static class DefaultCellEditor
    implements JSpreadCellEditor {
        private static final Logger logger;
        protected JSpread spread;
        protected Class[] argTypes = new Class[]{1.class$java$lang$String == null ? (1.class$java$lang$String = 1.class$("java.lang.String")) : 1.class$java$lang$String};
        protected Constructor constructor;
        protected Object value;
        protected JTextField textField = new JTextField();
        protected int clickCountToStart = 2;
        static final /* synthetic */ boolean $assertionsDisabled;

        public final void setSpread(JSpread spread) {
            if (!$assertionsDisabled && spread == null) {
                throw new AssertionError();
            }
            this.spread = spread;
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
            }
            return true;
        }

        public JComponent getCellEditorComponent() {
            return this.textField;
        }

        public void setCellValue(Object value) {
            this.textField.setBorder(new LineBorder(Color.black));
            try {
                Class type;
                Class clazz = type = value != null ? value.getClass() : (1.class$java$lang$String == null ? (1.class$java$lang$String = 1.class$("java.lang.String")) : 1.class$java$lang$String);
                if (type == (1.class$java$lang$Object == null ? (1.class$java$lang$Object = 1.class$("java.lang.Object")) : 1.class$java$lang$Object)) {
                    type = 1.class$java$lang$String == null ? (1.class$java$lang$String = 1.class$("java.lang.String")) : 1.class$java$lang$String;
                }
                this.constructor = type.getConstructor(this.argTypes);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.textField.setText(value != null ? "" + value : "");
            this.textField.selectAll();
        }

        public Object getCellValue() {
            String s = this.textField.getText();
            if ("".equals(s) && this.constructor.getDeclaringClass() == (1.class$java$lang$String == null ? (1.class$java$lang$String = 1.class$("java.lang.String")) : 1.class$java$lang$String)) {
                this.value = s;
            }
            try {
                this.value = this.constructor.newInstance(s);
            }
            catch (Exception e) {
                this.textField.setBorder(new LineBorder(Color.red));
                return this.value;
            }
            logger.debug("constructor=" + this.constructor + " value.class=" + this.value.getClass());
            return this.value;
        }

        static {
            $assertionsDisabled = !(1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor == null ? (1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor = 1.class$("net.sourceforge.swingx.jspread.JSpreadCellEditor")) : 1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor).desiredAssertionStatus();
            logger = Logger.getLogger(1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor$DefaultCellEditor == null ? (1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor$DefaultCellEditor = 1.class$("net.sourceforge.swingx.jspread.JSpreadCellEditor$DefaultCellEditor")) : 1.class$net$sourceforge$swingx$jspread$JSpreadCellEditor$DefaultCellEditor);
        }
    }
}

