/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx.jspread;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import net.sourceforge.swingx.Logger;
import net.sourceforge.swingx.jspread.JSpread;
import net.sourceforge.swingx.jspread.JSpreadCellPane;
import net.sourceforge.swingx.jspread.JSpreadSelectionEvent;
import net.sourceforge.swingx.jspread.JSpreadSheet;

public class JSpreadCellListener
implements KeyListener,
MouseInputListener {
    private static Logger logger = Logger.getLogger(JSpreadCellListener.class);
    final JSpread spread;
    transient JSpreadCellPane cellPane;
    private Component dispatchComponent;

    JSpreadCellListener(JSpread spread, JSpreadCellPane cellPane) {
        this.spread = spread;
        this.cellPane = cellPane;
    }

    public void mousePressed(MouseEvent e) {
        logger.debug("enter " + e);
        this.cellPane.requestFocusInWindow();
        JSpreadSheet sheet = this.spread.getSheet();
        int col = sheet.colHeader.getViewPositionAtPoint(e.getX());
        int row = sheet.rowHeader.getViewPositionAtPoint(e.getY());
        if (col != -1 && row != -1 && this.spread.editCellAt(row, col, e)) {
            this.setDispatchComponent(e);
            this.repostEvent(e);
        }
        if (e.getButton() == 1) {
            logger.debug("A");
            if (e.isControlDown()) {
                sheet.setSelection(sheet.focusRow, sheet.focusCol, sheet.curRow, sheet.curCol, true);
            } else {
                sheet.setSelectionAll(false);
                sheet.setHeaderSelectionAll(1, false);
                sheet.setHeaderSelectionAll(2, false);
                sheet.cornerSelection = false;
            }
            logger.debug("B");
            if (col != -1 && row != -1) {
                JSpreadSheet.CurrentFocus prev = sheet.getCurrentFocus();
                if (e.isShiftDown()) {
                    sheet.curRow = row;
                    sheet.curCol = col;
                } else {
                    sheet.focusRow = sheet.curRow = row;
                    sheet.focusCol = sheet.curCol = col;
                }
                JSpreadSheet.CurrentFocus next = sheet.getCurrentFocus();
                logger.debug("C");
                if (!prev.equals(next)) {
                    this.spread.fireSelectionListener(new JSpreadSelectionEvent(this, prev, next));
                }
                logger.debug("D");
            }
            e.consume();
            this.spread.\u518d\u63cf\u753b();
        }
        logger.debug("exit");
    }

    private void setDispatchComponent(MouseEvent e) {
        logger.debug("setDispatchComponent(e)");
        JComponent editorComponent = this.spread.getEditorComponent();
        Point p = e.getPoint();
        Point p2 = SwingUtilities.convertPoint(this.cellPane, p, editorComponent);
        this.dispatchComponent = SwingUtilities.getDeepestComponentAt(editorComponent, p2.x, p2.y);
    }

    private boolean repostEvent(MouseEvent e) {
        logger.debug("repostEvent(e) dispatchComponent=" + this.dispatchComponent);
        if (this.dispatchComponent == null || !this.spread.isEditing()) {
            return false;
        }
        MouseEvent e2 = SwingUtilities.convertMouseEvent(this.cellPane, e, this.dispatchComponent);
        this.dispatchComponent.dispatchEvent(e2);
        return true;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        logger.debug("enter " + e);
        this.repostEvent(e);
        this.dispatchComponent = null;
        logger.debug("exit");
    }

    public void mouseDragged(MouseEvent e) {
        logger.debug("enter " + e);
        JSpreadSheet sheet = this.spread.getSheet();
        int col = sheet.colHeader.getViewPositionAtPoint(e.getX());
        int row = sheet.rowHeader.getViewPositionAtPoint(e.getY());
        if (col != -1 && row != -1) {
            JSpreadSheet.CurrentFocus prev = sheet.getCurrentFocus();
            sheet.curRow = row;
            sheet.curCol = col;
            JSpreadSheet.CurrentFocus next = sheet.getCurrentFocus();
            if (!prev.equals(next)) {
                this.spread.fireSelectionListener(new JSpreadSelectionEvent(this, prev, next));
            }
            e.consume();
            this.spread.\u518d\u63cf\u753b();
        }
        logger.debug("exit");
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        JSpreadSheet.CurrentFocus next;
        logger.debug(e);
        JSpreadSheet sheet = this.spread.getSheet();
        JSpreadSheet.CurrentFocus prev = sheet.getCurrentFocus();
        switch (e.getKeyCode()) {
            case 37: {
                if (sheet.curCol <= 0) break;
                --sheet.curCol;
                e.consume();
                break;
            }
            case 39: {
                if (sheet.curCol >= sheet.colHeader.getViewCount() - 1) break;
                ++sheet.curCol;
                e.consume();
                break;
            }
            case 38: {
                if (sheet.curRow <= 0) break;
                --sheet.curRow;
                e.consume();
                break;
            }
            case 40: {
                if (sheet.curRow >= sheet.rowHeader.getViewCount() - 1) break;
                ++sheet.curRow;
                e.consume();
                break;
            }
            case 36: {
                sheet.curCol = 0;
                if (e.isControlDown()) {
                    sheet.curRow = 0;
                }
                e.consume();
                break;
            }
            case 35: {
                sheet.curCol = sheet.colHeader.getViewCount() - 1;
                if (e.isControlDown()) {
                    sheet.curRow = sheet.rowHeader.getViewCount() - 1;
                }
                e.consume();
                break;
            }
            default: {
                System.out.println(e);
                return;
            }
        }
        if (!e.isShiftDown()) {
            sheet.setSelectionAll(false);
            sheet.setHeaderSelectionAll(1, false);
            sheet.setHeaderSelectionAll(2, false);
            sheet.cornerSelection = false;
            sheet.focusRow = sheet.curRow;
            sheet.focusCol = sheet.curCol;
        }
        if (!prev.equals(next = sheet.getCurrentFocus())) {
            this.spread.fireSelectionListener(new JSpreadSelectionEvent(this, prev, next));
            this.spread.\u518d\u63cf\u753b();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

