/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx.jspread;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.sourceforge.swingx.Logger;
import net.sourceforge.swingx.jspread.JSpread;
import net.sourceforge.swingx.jspread.JSpreadCellListener;
import net.sourceforge.swingx.jspread.JSpreadCellRenderer;
import net.sourceforge.swingx.jspread.JSpreadSheet;

class JSpreadCellPane
extends JPanel {
    private static Logger logger;
    final transient JSpread spread;
    int rowPaneIndex;
    int colPaneIndex;
    CellRendererPane rendererPane = new CellRendererPane();
    static final /* synthetic */ boolean $assertionsDisabled;

    JSpreadCellPane(JSpread spread, int row, int col) {
        if (!$assertionsDisabled && spread == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && row != 0 && row != 1) {
            throw new AssertionError(row);
        }
        if (!$assertionsDisabled && col != 0 && col != 1) {
            throw new AssertionError(col);
        }
        this.spread = spread;
        this.rowPaneIndex = row;
        this.colPaneIndex = col;
        this.setLayout(null);
        this.add(this.rendererPane);
        JSpreadCellListener listener = new JSpreadCellListener(spread, this);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.enableEvents(8L);
        this.addKeyListener(listener);
        this.setFocusable(true);
        this.setCursor(spread.properties.getCursor("CELL_CURSOR"));
    }

    public Dimension getPreferredSize() {
        JSpreadSheet sheet = this.spread.getSheet();
        int totalW = sheet.colHeader.getTotalWidth();
        int totalH = sheet.rowHeader.getTotalWidth();
        return new Dimension(totalW, totalH);
    }

    public void paintComponent(Graphics g) {
        int total;
        logger.debug("enter");
        Graphics2D g2 = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        g2.setPaint(this.spread.properties.getColor("BACKGROUND_COLOR"));
        g2.fillRect(0, 0, width, height);
        Rectangle rect = g2.getClipBounds();
        JSpreadSheet sheet = this.spread.getSheet();
        int startCol = this.spread.getSheet().colHeader.getViewPositionAtPoint(rect.x);
        int startRow = this.spread.getSheet().rowHeader.getViewPositionAtPoint(rect.y);
        if (startCol == -1 || startRow == -1) {
            return;
        }
        int endCol = this.spread.getSheet().colHeader.getViewPositionAtPoint(rect.x + rect.width);
        int endRow = this.spread.getSheet().rowHeader.getViewPositionAtPoint(rect.y + rect.height);
        if (endRow == -1) {
            endRow = this.spread.getSheet().rowHeader.getViewCount() - 1;
        }
        if (endCol == -1) {
            endCol = this.spread.getSheet().colHeader.getViewCount() - 1;
        }
        Rectangle viewportRect = g.getClipBounds();
        Rectangle cellRect = new Rectangle();
        Color horizontalGridColor = this.spread.properties.getColor("HORIZONTAL_GRID_COLOR");
        Color verticalGridColor = this.spread.properties.getColor("VERTICAL_GRID_COLOR");
        cellRect.y = sheet.rowHeader.getPoint(startRow);
        for (int r = startRow; r <= endRow; ++r) {
            int rowDataIndex = sheet.rowHeader.getDataIndex(r);
            cellRect.height = sheet.rowHeader.getWidth(rowDataIndex);
            cellRect.x = sheet.colHeader.getPoint(startCol);
            for (int c = startCol; c <= endCol; ++c) {
                boolean hasFocus;
                int colDataIndex = sheet.colHeader.getDataIndex(c);
                cellRect.width = sheet.colHeader.getWidth(colDataIndex);
                Object value = this.spread.getValueAt(rowDataIndex, colDataIndex);
                boolean isSelected = sheet.getSelection(r, c);
                boolean bl = hasFocus = sheet.focusCol == c && sheet.focusRow == r;
                if (value instanceof JComponent) {
                    JComponent comp = (JComponent)value;
                    this.add(comp);
                    comp.setBounds(cellRect);
                } else {
                    JSpreadCellRenderer renderer = this.spread.getCellRenderer(value, rowDataIndex, colDataIndex);
                    JComponent comp = renderer.getSpreadRendererComponent(this.spread, value, isSelected, hasFocus, 0, rowDataIndex, colDataIndex);
                    this.rendererPane.paintComponent(g2, comp, this, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
                }
                cellRect.x = cellRect.x + (cellRect.width + (verticalGridColor != null ? 1 : 0));
            }
            cellRect.y = cellRect.y + (cellRect.height + (horizontalGridColor != null ? 1 : 0));
        }
        int max_cell_x = cellRect.x;
        int max_cell_y = cellRect.y;
        if (horizontalGridColor != null) {
            g2.setPaint(horizontalGridColor);
            total = sheet.rowHeader.getPoint(startRow) - 1;
            for (int r = startRow; r <= endRow; ++r) {
                int row_index = sheet.rowHeader.getDataIndex(r);
                g2.drawLine(0, total += sheet.rowHeader.getWidth(row_index) + 1, max_cell_x, total);
                if ((double)total > viewportRect.getMaxY()) break;
            }
        }
        if (verticalGridColor != null) {
            g2.setPaint(verticalGridColor);
            total = sheet.colHeader.getPoint(startCol) - 1;
            for (int c = startCol; c <= endCol; ++c) {
                int col_index = sheet.colHeader.getDataIndex(c);
                g2.drawLine(total += sheet.colHeader.getWidth(col_index) + 1, 0, total, max_cell_y);
                if ((double)total > viewportRect.getMaxX()) break;
            }
        }
        if (sheet.colHeader.getViewCount() != 0 && sheet.rowHeader.getViewCount() != 0) {
            int minRow = Math.min(sheet.focusRow, sheet.curRow);
            int maxRow = Math.max(sheet.focusRow, sheet.curRow);
            int minCol = Math.min(sheet.focusCol, sheet.curCol);
            int maxCol = Math.max(sheet.focusCol, sheet.curCol);
            if (sheet.curCol == -1) {
                minCol = 0;
                maxCol = sheet.colHeader.getViewCount() - 1;
            }
            if (sheet.curRow == -1) {
                minRow = 0;
                maxRow = sheet.rowHeader.getViewCount() - 1;
            }
            int x = sheet.colHeader.getPoint(minCol);
            int y = sheet.rowHeader.getPoint(minRow);
            int w = sheet.colHeader.getTailPoint(maxCol) - x;
            int h = sheet.rowHeader.getTailPoint(maxRow) - y;
            g2.setPaint(this.spread.properties.getColor("CELL_FOCUS_COLOR"));
            g2.setStroke(this.spread.properties.getStroke("CELL_FOCUS_STROKE"));
            g2.drawRect(x, y, w, h);
        }
        logger.debug("exit");
    }

    public String getToolTipText(MouseEvent event) {
        return this.spread.getToolTipText(this.getName(), event);
    }

    public void setSize(Dimension dim) {
        logger.debug("enter " + dim);
        super.setSize(dim);
        logger.debug("exit");
    }

    public void setSize(int w, int h) {
        logger.debug("enter " + w + " " + h);
        super.setSize(w, h);
        logger.debug("exit");
    }

    public void setBounds(int x, int y, int width, int height) {
        logger.debug("enter " + x + " " + y + " " + width + " " + height);
        super.setBounds(x, y, width, height);
        logger.debug("exit");
    }

    public void setBounds(Rectangle r) {
        logger.debug("enter " + r.x + " " + r.y + " " + r.width + " " + r.height);
        super.setBounds(r);
        logger.debug("exit");
    }

    static {
        $assertionsDisabled = !JSpreadCellPane.class.desiredAssertionStatus();
        logger = Logger.getLogger(JSpreadCellPane.class);
    }
}

