/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx.jspread;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.text.DateFormat;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.sourceforge.swingx.SxBevelBorder;
import net.sourceforge.swingx.jspread.JSpread;

public interface JSpreadCellRenderer {
    public JComponent getSpreadRendererComponent(JSpread var1, Object var2, boolean var3, boolean var4, int var5, int var6, int var7);

    static class 1 {
        static /* synthetic */ Class class$net$sourceforge$swingx$jspread$JSpreadCellRenderer;
    }

    public static class ColorRenderer
    extends DefaultCellRenderer {
        public static final int ICON_WIDTH = 15;
        public static final int ICON_HEIGHT = 15;

        public void setValue(Object value) {
            if (value instanceof Color) {
                Color color = (Color)value;
                this.setText("" + color.getRed() + " " + color.getGreen() + " " + color.getBlue());
                System.out.println("Font.size=" + this.getFont().getSize());
                this.setIcon(new ColorIcon(color, 15, this.getFont().getSize()));
            } else {
                this.setText("");
                this.setIcon(new ColorIcon(null, 15, this.getFont().getSize()));
            }
        }

        static class ColorIcon
        implements Icon {
            protected Color color;
            protected int width;
            protected int height;

            public ColorIcon(Color color, int w, int h) {
                this.color = color;
                this.width = w;
                this.height = h;
            }

            public int getIconWidth() {
                return this.width;
            }

            public int getIconHeight() {
                return this.height;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (this.color != null) {
                    g.setColor(this.color);
                    g.fillRect(x, y, this.width, this.height);
                    g.setColor(Color.BLACK);
                    g.drawRect(x, y, this.width, this.height);
                } else {
                    g.setColor(Color.white);
                    g.fillRect(x, y, this.width, this.height);
                    g.setColor(Color.black);
                    g.drawRect(x, y, this.width, this.height);
                }
            }
        }
    }

    public static class BooleanRenderer
    extends JCheckBox
    implements JSpreadCellRenderer {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setBorderPainted(true);
        }

        public JComponent getSpreadRendererComponent(JSpread spread, Object value, boolean isSelected, boolean hasFocus, int type, int rowDataIndex, int colDataIndex) {
            if (isSelected) {
                this.setForeground(spread.properties.getColor("CELL_SELECT_FOREGROUND_COLOR"));
                this.setBackground(spread.properties.getColor("CELL_SELECT_BACKGROUND_COLOR"));
            } else {
                this.setForeground(spread.properties.getColor("CELL_FOREGROUND_COLOR"));
                this.setBackground(spread.properties.getColor("CELL_BACKGROUND_COLOR"));
            }
            this.setSelected(value != null && (Boolean)value != false);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    public static class DateRenderer
    extends DefaultCellRenderer {
        protected DateFormat formatter = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        public void setFormat(DateFormat formatter) {
            if (!$assertionsDisabled && formatter == null) {
                throw new AssertionError();
            }
            this.formatter = formatter;
        }

        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance();
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }

        static {
            $assertionsDisabled = !(1.class$net$sourceforge$swingx$jspread$JSpreadCellRenderer == null ? (1.class$net$sourceforge$swingx$jspread$JSpreadCellRenderer = 1.class$("net.sourceforge.swingx.jspread.JSpreadCellRenderer")) : 1.class$net$sourceforge$swingx$jspread$JSpreadCellRenderer).desiredAssertionStatus();
        }
    }

    public static class IconRenderer
    extends DefaultCellRenderer {
        public JComponent getSpreadCellRendererComponent(JSpread spread, Object value, boolean isSelected, boolean hasFocus, int rowDataIndex, int colDataIndex) {
            JLabel comp = (JLabel)super.getSpreadCellRendererComponent(spread, value, isSelected, hasFocus, rowDataIndex, colDataIndex);
            comp.setHorizontalAlignment(0);
            return comp;
        }

        public void setValue(Object value) {
            this.setIcon(value instanceof Icon ? (Icon)value : null);
        }
    }

    public static class NumberRenderer
    extends DefaultCellRenderer {
        public JComponent getSpreadCellRendererComponent(JSpread spread, Object value, boolean isSelected, boolean hasFocus, int rowDataIndex, int colDataIndex) {
            JLabel comp = (JLabel)super.getSpreadCellRendererComponent(spread, value, isSelected, hasFocus, rowDataIndex, colDataIndex);
            comp.setHorizontalAlignment(4);
            return comp;
        }
    }

    public static class DefaultCellRenderer
    extends JLabel
    implements JSpreadCellRenderer {
        protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        protected static Border bevelBorder = new SxBevelBorder(0);

        public DefaultCellRenderer() {
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
        }

        public JComponent getSpreadRendererComponent(JSpread spread, Object value, boolean isSelected, boolean hasFocus, int type, int rowDataIndex, int colDataIndex) {
            switch (type) {
                case 0: {
                    return this.getSpreadCellRendererComponent(spread, value, isSelected, hasFocus, rowDataIndex, colDataIndex);
                }
                case 1: 
                case 2: 
                case 3: {
                    return this.getSpreadHeaderRendererComponent(spread, value, isSelected, hasFocus, type, rowDataIndex, colDataIndex);
                }
            }
            return this;
        }

        public JComponent getSpreadCellRendererComponent(JSpread spread, Object value, boolean isSelected, boolean hasFocus, int rowDataIndex, int colDataIndex) {
            if (isSelected) {
                super.setForeground(spread.properties.getColor("CELL_SELECT_FOREGROUND_COLOR"));
                super.setBackground(spread.properties.getColor("CELL_SELECT_BACKGROUND_COLOR"));
            } else {
                super.setForeground(spread.properties.getColor("CELL_FOREGROUND_COLOR"));
                super.setBackground(spread.properties.getColor("CELL_BACKGROUND_COLOR"));
            }
            this.setFont(spread.getFont());
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (!isSelected && spread.isCellEditable(rowDataIndex, colDataIndex)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        super.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        super.setBackground(col);
                    }
                }
            } else {
                this.setBorder(noFocusBorder);
            }
            this.setHorizontalAlignment(2);
            this.setValue(value);
            return this;
        }

        public JComponent getSpreadHeaderRendererComponent(JSpread spread, Object value, boolean isSelected, boolean hasFocus, int type, int rowDataIndex, int colDataIndex) {
            if (isSelected) {
                super.setForeground(spread.properties.getColor("HEADER_SELECT_FOREGROUND_COLOR"));
                super.setBackground(spread.properties.getColor("HEADER_SELECT_BACKGROUND_COLOR"));
            } else {
                super.setForeground(spread.properties.getColor("HEADER_FOREGROUND_COLOR"));
                super.setBackground(spread.properties.getColor("HEADER_BACKGROUND_COLOR"));
            }
            this.setFont(spread.getFont());
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (!isSelected && spread.isCellEditable(rowDataIndex, colDataIndex)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        super.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        super.setBackground(col);
                    }
                }
            } else {
                this.setBorder(bevelBorder);
            }
            this.setHorizontalAlignment(0);
            this.setValue(value);
            return this;
        }

        protected void setValue(Object value) {
            this.setText(value == null ? "" : value.toString());
        }
    }
}

