/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx.jspread;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sourceforge.swingx.Logger;
import net.sourceforge.swingx.jspread.JSpread;
import net.sourceforge.swingx.jspread.JSpread2x2Panel;
import net.sourceforge.swingx.jspread.JSpreadCellPane;
import net.sourceforge.swingx.jspread.JSpreadConstant;
import net.sourceforge.swingx.jspread.JSpreadHeaderPane;
import net.sourceforge.swingx.jspread.JSpreadSheet;

class JSpreadControllerBuilder
implements JSpreadConstant {
    private static Logger logger = Logger.getLogger(JSpreadControllerBuilder.class);
    private final JSpread spread;

    JSpreadControllerBuilder(JSpread spread) {
        this.spread = spread;
    }

    JPanel createView(JPanel panel) {
        panel.removeAll();
        JSpreadSheet sheet = this.spread.getSheet();
        if (sheet == null) {
            panel.add(new JLabel("JSpread"));
            return panel;
        }
        if (sheet.rowHeaderVisible && sheet.colHeaderVisible) {
            JSpreadCellPane cellPane = this.createCellPane(sheet, 0, 0);
            JSpreadHeaderPane rowHeaderPane = this.createRowHeaderPane(sheet);
            JSpreadHeaderPane colHeaderPane = this.createColHeaderPane(sheet);
            JSpreadHeaderPane cornerPane = new JSpreadHeaderPane(3, this.spread);
            JSpread2x2Panel pane = new JSpread2x2Panel(0, 0);
            pane.setPane(0, 0, cornerPane);
            pane.setPane(0, 1, colHeaderPane);
            pane.setPane(1, 0, rowHeaderPane);
            pane.setPane(1, 1, cellPane);
            pane.addComponentListener(new CellResizeListener(this.spread));
            panel.setLayout(new BorderLayout());
            panel.add((Component)pane, "Center");
            panel.invalidate();
            return panel;
        }
        if (sheet.rowHeaderVisible) {
            JSpreadCellPane cellPane = this.createCellPane(sheet, 0, 0);
            JSpreadHeaderPane rowHeaderPane = this.createRowHeaderPane(sheet);
            panel.setLayout(new BorderLayout());
            panel.add((Component)rowHeaderPane, "West");
            panel.add((Component)cellPane, "Center");
            panel.addComponentListener(new CellResizeListener(this.spread));
            panel.invalidate();
            return panel;
        }
        if (sheet.colHeaderVisible) {
            JSpreadCellPane cellPane = this.createCellPane(sheet, 0, 0);
            JSpreadHeaderPane colHeaderPane = this.createColHeaderPane(sheet);
            panel.setLayout(new BorderLayout());
            panel.add((Component)colHeaderPane, "North");
            panel.add((Component)cellPane, "Center");
            panel.addComponentListener(new CellResizeListener(this.spread));
            panel.invalidate();
            return panel;
        }
        JSpreadCellPane cellPane = this.createCellPane(sheet, 0, 0);
        return cellPane;
    }

    protected JPanel createScrollView(JPanel panel, int vsbPolicy, int hsbPolicy) {
        panel.removeAll();
        panel.setLayout(new BorderLayout());
        JSpreadSheet sheet = this.spread.getSheet();
        if (sheet.rowHeaderVisible && sheet.colHeaderVisible) {
            JSpreadCellPane cellPane = this.createCellPane(sheet, 0, 0);
            JSpreadHeaderPane rowHeaderPane = this.createRowHeaderPane(sheet);
            JSpreadHeaderPane colHeaderPane = this.createColHeaderPane(sheet);
            JSpreadHeaderPane cornerPane = new JSpreadHeaderPane(3, this.spread);
            cornerPane.setName("CornerPane");
            JScrollPane pane = new JScrollPane(vsbPolicy, hsbPolicy);
            pane.setViewportView(cellPane);
            pane.setColumnHeaderView(colHeaderPane);
            pane.setRowHeaderView(rowHeaderPane);
            pane.setCorner("UPPER_LEFT_CORNER", cornerPane);
            pane.setCorner("LOWER_RIGHT_CORNER", this.createUselessCorner());
            pane.addComponentListener(new CellResizeListener(this.spread));
            pane.invalidate();
            panel.add((Component)pane, "Center");
            return panel;
        }
        if (sheet.rowHeaderVisible) {
            JSpreadCellPane cellPane = this.createCellPane(sheet, 0, 0);
            JSpreadHeaderPane rowHeaderPane = this.createRowHeaderPane(sheet);
            JScrollPane pane = new JScrollPane(vsbPolicy, hsbPolicy);
            pane.setViewportView(cellPane);
            pane.setRowHeaderView(rowHeaderPane);
            pane.addComponentListener(new CellResizeListener(this.spread));
            pane.invalidate();
            panel.add((Component)pane, "Center");
            return panel;
        }
        if (sheet.colHeaderVisible) {
            JSpreadCellPane cellPane = this.createCellPane(sheet, 0, 0);
            JSpreadHeaderPane colHeaderPane = this.createColHeaderPane(sheet);
            JScrollPane pane = new JScrollPane(vsbPolicy, hsbPolicy);
            pane.setViewportView(cellPane);
            pane.setColumnHeaderView(colHeaderPane);
            pane.addComponentListener(new CellResizeListener(this.spread));
            pane.invalidate();
            panel.add((Component)pane, "Center");
            return panel;
        }
        JSpreadCellPane cellPane = this.createCellPane(sheet, 0, 0);
        JScrollPane pane = new JScrollPane(cellPane, vsbPolicy, hsbPolicy);
        panel.add((Component)pane, "Center");
        return panel;
    }

    protected JSpreadCellPane createCellPane(JSpreadSheet sheet, int r, int c) {
        JSpreadCellPane cellPane = new JSpreadCellPane(this.spread, r, c);
        cellPane.setName("CellPane");
        int totalW = sheet.colHeader.getTotalWidth();
        int totalH = sheet.rowHeader.getTotalWidth();
        logger.debug("totalW=" + totalW + " totalH=" + totalH);
        cellPane.setSize(totalW, totalH);
        return cellPane;
    }

    protected JSpreadHeaderPane createRowHeaderPane(JSpreadSheet sheet) {
        JSpreadHeaderPane rowHeaderPane = new JSpreadHeaderPane(1, this.spread);
        rowHeaderPane.setName("RowHeaderPane");
        return rowHeaderPane;
    }

    protected JSpreadHeaderPane createColHeaderPane(JSpreadSheet sheet) {
        JSpreadHeaderPane colHeaderPane = new JSpreadHeaderPane(2, this.spread);
        colHeaderPane.setName("ColumnHeaderPane");
        return colHeaderPane;
    }

    protected JComponent createUselessCorner() {
        Dimension dim = new Dimension(1, 1);
        Box.Filler uselessCornerPane = new Box.Filler(dim, dim, dim);
        uselessCornerPane.setName("UselessCorner");
        uselessCornerPane.setForeground(Color.RED);
        uselessCornerPane.setBackground(Color.BLUE);
        return uselessCornerPane;
    }

    class CellResizeListener
    extends ComponentAdapter {
        private final JSpread spread;
        static final /* synthetic */ boolean $assertionsDisabled;

        CellResizeListener(JSpread spread) {
            if (!$assertionsDisabled && spread == null) {
                throw new AssertionError();
            }
            this.spread = spread;
        }

        public void componentResized(ComponentEvent e) {
            this.spread.doLayout();
        }

        static {
            $assertionsDisabled = !(class$net$sourceforge$swingx$jspread$JSpreadControllerBuilder == null ? (class$net$sourceforge$swingx$jspread$JSpreadControllerBuilder = JSpreadControllerBuilder.class$("net.sourceforge.swingx.jspread.JSpreadControllerBuilder")) : class$net$sourceforge$swingx$jspread$JSpreadControllerBuilder).desiredAssertionStatus();
        }
    }
}

