/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx.jspread;

import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.JComponent;
import net.sourceforge.swingx.Logger;
import net.sourceforge.swingx.jspread.JSpread;
import net.sourceforge.swingx.jspread.JSpreadCellEditor;
import net.sourceforge.swingx.jspread.JSpreadCellPane;
import net.sourceforge.swingx.jspread.JSpreadSheet;

class JSpreadControllerCellEditor {
    static Logger logger;
    final JSpread spread;
    boolean atEdit = false;
    int editColumn = -1;
    int editRow = -1;
    private JComponent editorParent;
    Rectangle editorRect = null;
    JSpreadCellEditor editor = null;
    private PropertyChangeListener editorRemover = null;
    protected transient HashMap defaultEditorsByClass = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    JSpreadControllerCellEditor(JSpread spread) {
        this.spread = spread;
        this.createDefaultEditors();
    }

    protected void createDefaultEditors() {
        this.defaultEditorsByClass = new HashMap();
        this.defaultEditorsByClass.put(Object.class, new JSpreadCellEditor.DefaultCellEditor());
        this.defaultEditorsByClass.put(Number.class, new JSpreadCellEditor.NumberEditor());
        this.defaultEditorsByClass.put(Boolean.class, new JSpreadCellEditor.BooleanEditor());
        this.defaultEditorsByClass.put(Date.class, new JSpreadCellEditor.DateEditor());
    }

    private JSpreadCellEditor getDefaultCellEditorComponent(Object value, int row, int column) {
        if (value != null) {
            for (Class<?> cls = value.getClass(); cls != null; cls = cls.getSuperclass()) {
                JSpreadCellEditor editor = (JSpreadCellEditor)this.defaultEditorsByClass.get(cls);
                if (editor == null) continue;
                return editor;
            }
        }
        return (JSpreadCellEditor)this.defaultEditorsByClass.get(Object.class);
    }

    boolean isCellEditable(int rowDataIndex, int colDataIndex) {
        return false;
    }

    JSpreadCellEditor getCellEditor(Object value, int rowDataIndex, int colDataIndex) {
        JSpreadCellEditor editor = this.getDefaultCellEditorComponent(value, rowDataIndex, colDataIndex);
        logger.debug("getCellEditor(row=" + rowDataIndex + "col=" + colDataIndex + ") editor=" + editor.getClass());
        return editor;
    }

    boolean editCellAt(int rowViewIndex, int colViewIndex, EventObject event) {
        Object value;
        JSpreadCellEditor editor;
        logger.debug("editCellAt(row=" + rowViewIndex + ", column=" + colViewIndex + ", event=" + event + ")");
        if (this.editor != null && !this.spread.stopCellEditing()) {
            return false;
        }
        JSpreadSheet sheet = this.spread.getSheet();
        if (!($assertionsDisabled || 0 <= rowViewIndex && rowViewIndex < sheet.rowHeader.getViewCount())) {
            throw new AssertionError(rowViewIndex);
        }
        if (!($assertionsDisabled || 0 <= colViewIndex && colViewIndex < sheet.colHeader.getViewCount())) {
            throw new AssertionError(colViewIndex);
        }
        int colDataIndex = sheet.colHeader.getDataIndex(colViewIndex);
        int rowDataIndex = sheet.rowHeader.getDataIndex(rowViewIndex);
        if (!this.spread.isCellEditable(rowDataIndex, colDataIndex)) {
            return false;
        }
        if (this.editorRemover == null) {
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.editorRemover = new CellEditorRemover(fm);
            fm.addPropertyChangeListener("permanentFocusOwner", this.editorRemover);
        }
        if ((editor = this.spread.getCellEditor(value = this.spread.getValueAt(rowDataIndex, colDataIndex), rowDataIndex, colDataIndex)) == null) {
            return false;
        }
        editor.setSpread(this.spread);
        editor.setCellValue(value);
        if (!editor.isCellEditable(event)) {
            return false;
        }
        this.editor = editor;
        this.editorRect = new Rectangle(sheet.colHeader.getPoint(colViewIndex), sheet.rowHeader.getPoint(rowViewIndex), sheet.colHeader.getWidth(colDataIndex), sheet.rowHeader.getWidth(rowDataIndex));
        this.editRow = rowViewIndex;
        this.editColumn = colViewIndex;
        this.atEdit = true;
        JSpreadCellPane pane = (JSpreadCellPane)this.spread.getComponent("CellPane");
        JComponent comp = editor.getCellEditorComponent();
        pane.add(comp);
        this.editorParent = pane;
        comp.setBounds(this.editorRect);
        comp.validate();
        return true;
    }

    boolean stopCellEditing() {
        if (!$assertionsDisabled && this.editor == null) {
            throw new AssertionError((Object)"editor");
        }
        logger.debug("stopCellEditing()");
        Object value = this.editor.getCellValue();
        this.spread.setValueAt(value, this.editRow, this.editColumn);
        this.removeEditor();
        return true;
    }

    void cancelCellEditing() {
        logger.debug("cancelCellEditing()");
        this.removeEditor();
    }

    private void removeEditor() {
        logger.debug("removeEditor() editor=" + this.editor + " rect=" + this.editorRect);
        if (!$assertionsDisabled && this.editor == null) {
            throw new AssertionError(this.editor);
        }
        this.atEdit = false;
        JComponent comp = this.editor.getCellEditorComponent();
        this.editorParent.repaint(this.editorRect.x, this.editorRect.y, this.editorRect.width, this.editorRect.height);
        this.editorParent.remove(comp);
        this.editor = null;
        this.editColumn = -1;
        this.editRow = -1;
        this.editorRect = null;
    }

    boolean isEditing() {
        return this.atEdit;
    }

    public JComponent getEditorComponent() {
        return this.editor != null ? this.editor.getCellEditorComponent() : null;
    }

    static {
        $assertionsDisabled = !JSpreadControllerCellEditor.class.desiredAssertionStatus();
        logger = Logger.getLogger(JSpreadControllerCellEditor.class);
    }

    class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;

        public CellEditorRemover(KeyboardFocusManager fm) {
            this.focusManager = fm;
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (JSpreadControllerCellEditor.this.spread.isEditing() && ev.getPropertyName().equals("permanentFocusOwner") && ev.getOldValue() == JSpreadControllerCellEditor.this.editor) {
                logger.debug("@@@ \u30d5\u30a9\u30fc\u30ab\u30b9\u304c\u3069\u3053\u304b\u306b\u3044\u3063\u305f\u306e\u3067\u7de8\u96c6\u7d42\u4e86");
                if (!JSpreadControllerCellEditor.this.spread.stopCellEditing()) {
                    JSpreadControllerCellEditor.this.spread.cancelCellEditing();
                }
            }
        }
    }
}

