/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx.jspread;

import java.awt.Color;
import java.util.Date;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import net.sourceforge.swingx.jspread.JSpread;
import net.sourceforge.swingx.jspread.JSpreadCellRenderer;
import net.sourceforge.swingx.jspread.JSpreadConstant;

class JSpreadControllerCellRenderer
implements JSpreadConstant {
    private JSpread spread;
    protected transient HashMap defaultRenderersByClass = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    JSpreadControllerCellRenderer(JSpread spread) {
        if (!$assertionsDisabled && spread == null) {
            throw new AssertionError(spread);
        }
        this.spread = spread;
        this.createDefaultRenderers();
    }

    protected void createDefaultRenderers() {
        this.defaultRenderersByClass = new HashMap();
        this.defaultRenderersByClass.put(Object.class, new JSpreadCellRenderer.DefaultCellRenderer());
        this.defaultRenderersByClass.put(Number.class, new JSpreadCellRenderer.NumberRenderer());
        this.defaultRenderersByClass.put(Date.class, new JSpreadCellRenderer.DateRenderer());
        JSpreadCellRenderer.IconRenderer iconRenderer = new JSpreadCellRenderer.IconRenderer();
        this.defaultRenderersByClass.put(Icon.class, iconRenderer);
        this.defaultRenderersByClass.put(ImageIcon.class, iconRenderer);
        this.defaultRenderersByClass.put(Boolean.class, new JSpreadCellRenderer.BooleanRenderer());
        this.defaultRenderersByClass.put(Color.class, new JSpreadCellRenderer.ColorRenderer());
    }

    JSpreadCellRenderer getDefaultCellRenderer(Object value, int row, int column) {
        if (value != null) {
            for (Class<?> cls = value.getClass(); cls != null; cls = cls.getSuperclass()) {
                JSpreadCellRenderer renderer = (JSpreadCellRenderer)this.defaultRenderersByClass.get(cls);
                if (renderer == null) continue;
                return renderer;
            }
        }
        return (JSpreadCellRenderer)this.defaultRenderersByClass.get(Object.class);
    }

    JSpreadCellRenderer getDefaultHeaderRenderer(Object value, int header, int dataIndex) {
        if (value != null) {
            for (Class<?> cls = value.getClass(); cls != null; cls = cls.getSuperclass()) {
                JSpreadCellRenderer renderer = (JSpreadCellRenderer)this.defaultRenderersByClass.get(cls);
                if (renderer == null) continue;
                return renderer;
            }
        }
        return (JSpreadCellRenderer)this.defaultRenderersByClass.get(Object.class);
    }

    public JSpreadCellRenderer getCellRenderer(Object value, int rowDataIndex, int columnDataIndex) {
        JSpreadCellRenderer defaultRenderer = this.getDefaultCellRenderer(value, rowDataIndex, columnDataIndex);
        return defaultRenderer;
    }

    public JSpreadCellRenderer getHeaderRenderer(Object value, int header, int dataIndex) {
        if (!$assertionsDisabled && header != 1 && header != 2 && header != 3) {
            throw new AssertionError(header);
        }
        if (!$assertionsDisabled && 0 > dataIndex) {
            throw new AssertionError(dataIndex);
        }
        JSpreadCellRenderer defaultRenderer = this.getDefaultHeaderRenderer(value, header, dataIndex);
        return defaultRenderer;
    }

    static {
        $assertionsDisabled = !JSpreadControllerCellRenderer.class.desiredAssertionStatus();
    }
}

