/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx.jspread;

import javax.swing.JComponent;
import javax.swing.JViewport;
import net.sourceforge.swingx.Logger;
import net.sourceforge.swingx.jspread.JSpread;
import net.sourceforge.swingx.jspread.JSpreadCellPane;
import net.sourceforge.swingx.jspread.JSpreadConstant;
import net.sourceforge.swingx.jspread.JSpreadHeader;
import net.sourceforge.swingx.jspread.JSpreadHeaderPane;
import net.sourceforge.swingx.jspread.JSpreadSheet;

public class JSpreadControllerResize
implements JSpreadConstant {
    static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    void doLayout(JSpread spread) {
        JSpreadHeaderPane colHeader;
        JSpreadCellPane cellPane;
        logger.debug("doLayout() enter");
        JSpreadSheet sheet = spread.sheet;
        JComponent viewport = cellPane = (JSpreadCellPane)spread.getComponent("CellPane");
        if (cellPane.getParent() != null && cellPane.getParent() instanceof JViewport) {
            viewport = (JComponent)cellPane.getParent();
        }
        if (sheet != null) {
            this.doHeaderLayout(viewport, sheet.rowHeader, 1);
            this.doHeaderLayout(viewport, sheet.colHeader, 2);
        }
        int w = sheet.colHeader.getTotalWidth();
        int h = sheet.rowHeader.getTotalWidth();
        JSpreadHeaderPane rowHeader = (JSpreadHeaderPane)spread.getComponent("RowHeaderPane");
        if (rowHeader != null) {
            rowHeader.setSize(sheet.rowHeader.thickness, h);
        }
        if ((colHeader = (JSpreadHeaderPane)spread.getComponent("ColumnHeaderPane")) != null) {
            colHeader.setSize(w, sheet.colHeader.thickness);
        }
        cellPane.setSize(w, h);
        logger.debug("doLayout() exit");
    }

    private void doHeaderLayout(JComponent viewport, JSpreadHeader header, int orientation) {
        if (header.autoResizeMode == 0) {
            return;
        }
        int index = -1;
        if (index == -1) {
            this.setWidthsFromPreferredWidths(viewport, header, false);
        } else {
            int delta = (orientation == 2 ? viewport.getWidth() : viewport.getHeight()) - header.getTotalWidth();
            this.accommodateDelta(header, index, delta);
            delta = (orientation == 2 ? viewport.getWidth() : viewport.getHeight()) - header.getTotalWidth();
            if (delta != 0) {
                int dataIndex = header.getDataIndex(index);
                int w = header.getWidth(dataIndex);
                header.setWidth(dataIndex, w + delta);
            }
            this.setWidthsFromPreferredWidths(viewport, header, true);
        }
    }

    private void setWidthsFromPreferredWidths(JComponent targetComponent, final JSpreadHeader header, final boolean inverse) {
        int totalWidth = targetComponent.getWidth();
        int totalPreferred = targetComponent.getPreferredSize().width;
        int target = !inverse ? totalWidth : totalPreferred;
        Resizable3 r = new Resizable3(){

            public int getElementCount() {
                return header.getViewCount();
            }

            public int getLowerBoundAt(int i) {
                return header.getMinWidth(header.getDataIndex(i));
            }

            public int getUpperBoundAt(int i) {
                return header.getMaxWidth(header.getDataIndex(i));
            }

            public int getMidPointAt(int i) {
                if (!inverse) {
                    return header.getPreferredWidth(header.getDataIndex(i));
                }
                return header.getWidth(header.getDataIndex(i));
            }

            public void setSizeAt(int s, int i) {
                if (!inverse) {
                    header.setWidth(header.getDataIndex(i), s);
                } else {
                    header.setPreferredWidth(header.getDataIndex(i), s);
                }
            }
        };
        this.adjustSizes(target, r, inverse);
    }

    private void accommodateDelta(final JSpreadHeader header, int resizingColumnIndex, int delta) {
        int columnCount = header.getViewCount();
        int from = resizingColumnIndex;
        int to = columnCount;
        switch (header.autoResizeMode) {
            case 1: {
                to = Math.min(++from + 1, columnCount);
                break;
            }
            case 3: {
                from = columnCount - 1;
                to = from + 1;
                break;
            }
            default: {
                return;
            }
        }
        final int start = from;
        final int end = to;
        Resizable3 r = new Resizable3(){

            public int getElementCount() {
                return end - start;
            }

            public int getLowerBoundAt(int i) {
                return header.getMinWidth(header.getDataIndex(i + start));
            }

            public int getUpperBoundAt(int i) {
                return header.getMaxWidth(header.getDataIndex(i + start));
            }

            public int getMidPointAt(int i) {
                return header.getWidth(header.getDataIndex(i + start));
            }

            public void setSizeAt(int s, int i) {
                header.setWidth(header.getDataIndex(i + start), s);
            }
        };
        int totalWidth = 0;
        for (int i = from; i < to; ++i) {
            totalWidth += header.getWidth(header.getDataIndex(i));
        }
        this.adjustSizes(totalWidth + delta, r, false);
    }

    private void adjustSizes(long target, Resizable2 r, boolean limitToRange) {
        int i;
        if (!$assertionsDisabled && target < 0L) {
            throw new AssertionError(target);
        }
        if (!$assertionsDisabled && r == null) {
            throw new AssertionError();
        }
        long totalLowerBound = 0L;
        long totalUpperBound = 0L;
        for (i = 0; i < r.getElementCount(); ++i) {
            totalLowerBound += (long)r.getLowerBoundAt(i);
            totalUpperBound += (long)r.getUpperBoundAt(i);
        }
        if (limitToRange) {
            target = Math.min(Math.max(totalLowerBound, target), totalUpperBound);
        }
        for (i = 0; i < r.getElementCount(); ++i) {
            int newSize;
            int lowerBound = r.getLowerBoundAt(i);
            int upperBound = r.getUpperBoundAt(i);
            if (totalLowerBound == totalUpperBound) {
                newSize = lowerBound;
            } else {
                double f = (double)(target - totalLowerBound) / (double)(totalUpperBound - totalLowerBound);
                newSize = (int)Math.round((double)lowerBound + f * (double)(upperBound - lowerBound));
            }
            r.setSizeAt(newSize, i);
            target -= (long)newSize;
            totalLowerBound -= (long)lowerBound;
            totalUpperBound -= (long)upperBound;
        }
    }

    static {
        $assertionsDisabled = !JSpreadControllerResize.class.desiredAssertionStatus();
        logger = Logger.getLogger(JSpread.class);
    }

    private static interface Resizable3
    extends Resizable2 {
        public int getMidPointAt(int var1);
    }

    private static interface Resizable2 {
        public int getElementCount();

        public int getLowerBoundAt(int var1);

        public int getUpperBoundAt(int var1);

        public void setSizeAt(int var1, int var2);
    }
}

