/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx.jspread;

import java.awt.Color;
import java.util.ArrayList;
import net.sourceforge.swingx.jspread.JSpread;
import net.sourceforge.swingx.jspread.JSpreadConstant;

public class JSpreadHeader
implements JSpreadConstant {
    final JSpread spread;
    final int orientation;
    int thickness;
    int defaultWidth;
    ArrayList infos = new ArrayList();
    int autoResizeMode;
    transient int[] dataIndexList;
    static final /* synthetic */ boolean $assertionsDisabled;

    JSpreadHeader(JSpread spread, int orientation, int count, int thickness, int defaultWidth) {
        if (!$assertionsDisabled && spread == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && orientation != 1 && orientation != 2) {
            throw new AssertionError(orientation);
        }
        if (!$assertionsDisabled && count < 0) {
            throw new AssertionError(count);
        }
        if (!$assertionsDisabled && thickness < 0) {
            throw new AssertionError(thickness);
        }
        if (!$assertionsDisabled && defaultWidth < 0) {
            throw new AssertionError(defaultWidth);
        }
        this.spread = spread;
        this.orientation = orientation;
        this.thickness = thickness;
        this.defaultWidth = defaultWidth;
        this.autoResizeMode = 0;
        for (int i = 0; i < count; ++i) {
            this.infos.add(new HeaderInfo(null, defaultWidth, i));
        }
        this.makeDataIndexList();
    }

    HeaderInfo getInfo(int dataIndex) {
        if (!($assertionsDisabled || 0 <= dataIndex && dataIndex < this.infos.size())) {
            throw new AssertionError(dataIndex);
        }
        return (HeaderInfo)this.infos.get(dataIndex);
    }

    public int getWidth(int dataIndex) {
        if (!($assertionsDisabled || 0 <= dataIndex && dataIndex < this.infos.size())) {
            throw new AssertionError(dataIndex);
        }
        return this.getInfo((int)dataIndex).width;
    }

    public void setWidth(int dataIndex, int width) {
        if (!($assertionsDisabled || 0 <= dataIndex && dataIndex < this.infos.size())) {
            throw new AssertionError(dataIndex);
        }
        this.getInfo(dataIndex).setWidth(width);
    }

    int getMinWidth(int dataIndex) {
        if (!($assertionsDisabled || 0 <= dataIndex && dataIndex < this.infos.size())) {
            throw new AssertionError(dataIndex);
        }
        return this.getInfo((int)dataIndex).minWidth;
    }

    int getMaxWidth(int dataIndex) {
        if (!($assertionsDisabled || 0 <= dataIndex && dataIndex < this.infos.size())) {
            throw new AssertionError(dataIndex);
        }
        return this.getInfo((int)dataIndex).maxWidth;
    }

    int getPreferredWidth(int dataIndex) {
        if (!($assertionsDisabled || 0 <= dataIndex && dataIndex < this.infos.size())) {
            throw new AssertionError(dataIndex);
        }
        return this.getInfo((int)dataIndex).preferredWidth;
    }

    public void setPreferredWidth(int dataIndex, int width) {
        if (!($assertionsDisabled || 0 <= dataIndex && dataIndex < this.infos.size())) {
            throw new AssertionError(dataIndex);
        }
        this.getInfo(dataIndex).setPreferredWidth(width);
    }

    Object getValueAt(int dataIndex) {
        if (!($assertionsDisabled || 0 <= dataIndex && dataIndex < this.infos.size())) {
            throw new AssertionError(dataIndex);
        }
        return this.getInfo((int)dataIndex).value;
    }

    public void setValueAt(int dataIndex, Object value) {
        if (!($assertionsDisabled || 0 <= dataIndex && dataIndex < this.infos.size())) {
            throw new AssertionError(dataIndex);
        }
        this.getInfo((int)dataIndex).value = value;
    }

    public int getCount() {
        return this.infos.size();
    }

    int getPoint(int viewIndex) {
        int viewCount = this.getViewCount();
        if (!($assertionsDisabled || 0 <= viewIndex && viewIndex <= viewCount)) {
            throw new AssertionError(viewIndex);
        }
        Color gridColor = this.orientation == 2 ? this.spread.properties.getColor("HORIZONTAL_GRID_COLOR") : this.spread.properties.getColor("VERTICAL_GRID_COLOR");
        int space = gridColor != null ? 1 : 0;
        int pos = 0;
        for (int i = 0; i < viewIndex; ++i) {
            int index = this.getDataIndex(i);
            pos += this.getWidth(index) + space;
        }
        return pos;
    }

    int getTailPoint(int viewIndex) {
        int index = this.getDataIndex(viewIndex);
        return this.getPoint(viewIndex) + this.getWidth(index);
    }

    int getViewPositionAtPoint(int x) {
        if (x < 0) {
            return -1;
        }
        int p = 0;
        Color gridColor = this.orientation == 2 ? this.spread.properties.getColor("HORIZONTAL_GRID_COLOR") : this.spread.properties.getColor("VERTICAL_GRID_COLOR");
        int space = gridColor != null ? 1 : 0;
        int viewCount = this.getViewCount();
        for (int i = 0; i < viewCount; ++i) {
            int index = this.getDataIndex(i);
            if (x >= (p += this.getWidth(index) + space)) continue;
            return i;
        }
        return -1;
    }

    int getTotalWidth() {
        return this.getPoint(this.getViewCount());
    }

    void makeDataIndexList() {
        this.dataIndexList = new int[this.getViewCount()];
        for (int i = 0; i < this.infos.size(); ++i) {
            if (this.getInfo((int)i).viewPosition == -1) continue;
            this.dataIndexList[this.getInfo((int)i).viewPosition] = i;
        }
    }

    public int getViewCount() {
        int viewCount = 0;
        for (int i = 0; i < this.infos.size(); ++i) {
            if (this.getInfo((int)i).viewPosition == -1) continue;
            ++viewCount;
        }
        return viewCount;
    }

    int getDataIndex(int viewIndex) {
        if (!($assertionsDisabled || 0 <= viewIndex && viewIndex < this.dataIndexList.length)) {
            throw new AssertionError(viewIndex);
        }
        return this.dataIndexList[viewIndex];
    }

    public int getAutoResizeMode() {
        return this.autoResizeMode;
    }

    public void setAutoResizeMode(int mode) {
        if (!$assertionsDisabled && mode != 0 && mode != 1 && mode != 3) {
            throw new AssertionError(mode);
        }
        this.autoResizeMode = mode;
    }

    static {
        $assertionsDisabled = !JSpreadHeader.class.desiredAssertionStatus();
    }

    static class HeaderInfo {
        Object value;
        int width;
        int minWidth;
        int maxWidth;
        int preferredWidth;
        int viewPosition;
        static final /* synthetic */ boolean $assertionsDisabled;

        HeaderInfo(Object value, int width, int viewPosition) {
            this.value = value;
            this.minWidth = 15;
            this.maxWidth = Integer.MAX_VALUE;
            this.width = Math.max(this.minWidth, Math.min(width, this.maxWidth));
            this.preferredWidth = width;
            this.viewPosition = viewPosition;
        }

        void setWidth(int newWidth) {
            this.width = newWidth;
        }

        void setPreferredWidth(int newWidth) {
            this.preferredWidth = newWidth;
        }

        void setMinWidth(int newWidth) {
            if (!$assertionsDisabled && newWidth > this.maxWidth) {
                throw new AssertionError(newWidth);
            }
            this.minWidth = newWidth;
        }

        void setMaxWidth(int newWidth) {
            if (!$assertionsDisabled && this.minWidth > newWidth) {
                throw new AssertionError(newWidth);
            }
            this.maxWidth = newWidth;
        }

        static {
            $assertionsDisabled = !(class$net$sourceforge$swingx$jspread$JSpreadHeader == null ? (class$net$sourceforge$swingx$jspread$JSpreadHeader = JSpreadHeader.class$("net.sourceforge.swingx.jspread.JSpreadHeader")) : class$net$sourceforge$swingx$jspread$JSpreadHeader).desiredAssertionStatus();
        }
    }
}

