/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx.jspread;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;
import net.sourceforge.swingx.Logger;
import net.sourceforge.swingx.jspread.JSpread;
import net.sourceforge.swingx.jspread.JSpreadHeaderPane;
import net.sourceforge.swingx.jspread.JSpreadHeaderResizeListener;
import net.sourceforge.swingx.jspread.JSpreadSelectionEvent;
import net.sourceforge.swingx.jspread.JSpreadSheet;

public class JSpreadHeaderListener
extends MouseInputAdapter {
    private static Logger logger;
    static final int RESIZE = 1;
    static final int SELECT = 0;
    final JSpreadHeaderPane pane;
    final JSpread spread;
    final JSpreadHeaderResizeListener resizeListener;
    int mode = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    JSpreadHeaderListener(JSpread spread, JSpreadHeaderPane pane) {
        if (!$assertionsDisabled && spread == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && pane == null) {
            throw new AssertionError();
        }
        this.spread = spread;
        this.pane = pane;
        this.resizeListener = new JSpreadHeaderResizeListener(spread, pane);
    }

    public void mousePressed(MouseEvent e) {
        logger.debug(e);
        if (this.resizeListener.isSensable(e.getX(), e.getY())) {
            this.mode = 1;
            this.resizeListener.mousePressed(e);
            return;
        }
        JSpreadSheet sheet = this.spread.getSheet();
        JSpreadSheet.CurrentFocus prev = sheet.getCurrentFocus();
        switch (this.pane.orientation) {
            case 1: {
                boolean startRow = false;
                this.mode = 0;
                int startCol = 0;
                int row = sheet.rowHeader.getViewPositionAtPoint(e.getY());
                if (e.getButton() != 1) break;
                if (e.isControlDown()) {
                    sheet.setSelection(sheet.focusRow, sheet.focusCol, sheet.curRow, sheet.curCol, true);
                } else {
                    sheet.setSelectionAll(false);
                    sheet.setHeaderSelectionAll(1, false);
                    sheet.setHeaderSelectionAll(2, false);
                    sheet.setCornerSelection(false);
                }
                if (row != -1) {
                    if (e.isShiftDown()) {
                        sheet.curRow = row;
                        sheet.curCol = -1;
                        JSpreadSheet.CurrentFocus next = sheet.getCurrentFocus();
                        if (!prev.equals(next)) {
                            this.spread.fireSelectionListener(new JSpreadSelectionEvent(this, prev, next));
                        }
                    } else {
                        sheet.focusRow = sheet.curRow = row;
                        sheet.focusCol = startCol;
                        sheet.curCol = -1;
                        JSpreadSheet.CurrentFocus next = sheet.getCurrentFocus();
                        if (!prev.equals(next)) {
                            this.spread.fireSelectionListener(new JSpreadSelectionEvent(this, prev, next));
                        }
                    }
                }
                this.spread.\u518d\u63cf\u753b();
                break;
            }
            case 2: {
                int startRow = 0;
                boolean startCol = false;
                this.mode = 0;
                int col = sheet.colHeader.getViewPositionAtPoint(e.getX());
                if (e.getButton() != 1) break;
                if (e.isControlDown()) {
                    sheet.setSelection(sheet.focusRow, sheet.focusCol, sheet.curRow, sheet.curCol, true);
                } else {
                    sheet.setSelectionAll(false);
                    sheet.setHeaderSelectionAll(1, false);
                    sheet.setHeaderSelectionAll(2, false);
                    sheet.setCornerSelection(false);
                }
                if (col != -1) {
                    if (e.isShiftDown()) {
                        sheet.curRow = -1;
                        sheet.curCol = col;
                        JSpreadSheet.CurrentFocus next = sheet.getCurrentFocus();
                        if (!prev.equals(next)) {
                            this.spread.fireSelectionListener(new JSpreadSelectionEvent(this, prev, next));
                        }
                    } else {
                        sheet.focusCol = sheet.curCol = col;
                        sheet.focusRow = startRow;
                        sheet.curRow = -1;
                        JSpreadSheet.CurrentFocus next = sheet.getCurrentFocus();
                        if (!prev.equals(next)) {
                            this.spread.fireSelectionListener(new JSpreadSelectionEvent(this, prev, next));
                        }
                    }
                }
                this.spread.\u518d\u63cf\u753b();
                break;
            }
            case 3: {
                this.mode = 0;
                sheet.setSelectionAll(true);
                sheet.setHeaderSelectionAll(1, true);
                sheet.setHeaderSelectionAll(2, true);
                sheet.cornerSelection = true;
                sheet.focusRow = 0;
                sheet.focusCol = 0;
                sheet.curRow = sheet.getHeader(1).getViewCount() - 1;
                sheet.curCol = sheet.getHeader(2).getViewCount() - 1;
                JSpreadSheet.CurrentFocus next = sheet.getCurrentFocus();
                if (!prev.equals(next)) {
                    this.spread.fireSelectionListener(new JSpreadSelectionEvent(this, prev, next));
                }
                this.spread.\u518d\u63cf\u753b();
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        logger.debug(e);
        JSpreadSheet sheet = this.spread.getSheet();
        if (this.mode == 0) {
            JSpreadSheet.CurrentFocus prev = sheet.getCurrentFocus();
            switch (this.pane.orientation) {
                case 1: {
                    JSpreadSheet.CurrentFocus next;
                    int row = sheet.rowHeader.getViewPositionAtPoint(e.getY());
                    if (row != -1) {
                        sheet.curRow = row;
                        sheet.curCol = -1;
                    }
                    if (!prev.equals(next = sheet.getCurrentFocus())) {
                        this.spread.fireSelectionListener(new JSpreadSelectionEvent(this, prev, next));
                    }
                    this.spread.\u518d\u63cf\u753b();
                    break;
                }
                case 2: {
                    JSpreadSheet.CurrentFocus next;
                    int col = sheet.colHeader.getViewPositionAtPoint(e.getX());
                    if (col != -1) {
                        sheet.curRow = -1;
                        sheet.curCol = col;
                    }
                    if (!prev.equals(next = sheet.getCurrentFocus())) {
                        this.spread.fireSelectionListener(new JSpreadSelectionEvent(this, prev, next));
                    }
                    this.spread.\u518d\u63cf\u753b();
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    } else {
                        break;
                    }
                }
            }
        } else {
            this.resizeListener.mouseDragged(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.mode == 1) {
            this.resizeListener.mouseReleased(e);
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.resizeListener.isSensable(e.getX(), e.getY())) {
            this.resizeListener.mouseMoved(e);
        } else {
            this.pane.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.resizeListener.isSensable(e.getX(), e.getY())) {
            this.resizeListener.mouseClicked(e);
        }
    }

    static {
        $assertionsDisabled = !JSpreadHeaderListener.class.desiredAssertionStatus();
        logger = Logger.getLogger(JSpreadHeaderListener.class);
    }
}

