/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx.jspread;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import net.sourceforge.swingx.Logger;
import net.sourceforge.swingx.jspread.JSpread;
import net.sourceforge.swingx.jspread.JSpreadCellRenderer;
import net.sourceforge.swingx.jspread.JSpreadHeaderListener;
import net.sourceforge.swingx.jspread.JSpreadSheet;

class JSpreadHeaderPane
extends JComponent {
    private static Logger logger;
    int orientation;
    transient JSpread spread;
    CellRendererPane rendererPane = new CellRendererPane();
    static final /* synthetic */ boolean $assertionsDisabled;

    JSpreadHeaderPane(int orientation, JSpread spread) {
        if (!$assertionsDisabled && orientation != 3 && orientation != 1 && orientation != 2) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && spread == null) {
            throw new AssertionError();
        }
        this.orientation = orientation;
        this.spread = spread;
        this.setFocusable(false);
        JSpreadHeaderListener listener = new JSpreadHeaderListener(spread, this);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.setBackground(spread.properties.getColor("BACKGROUND_COLOR"));
    }

    public void paintComponent(Graphics g) {
        int space;
        logger.debug("enter orientation=" + this.orientation);
        super.paintComponent(g);
        JSpreadSheet sheet = this.spread.getSheet();
        Graphics2D g2 = (Graphics2D)g;
        Rectangle rect = g2.getClipBounds();
        int width = this.getWidth();
        int height = this.getHeight();
        g2.setPaint(this.spread.properties.getColor("BACKGROUND_COLOR"));
        g2.fillRect(0, 0, width, height);
        Color gridColor = this.orientation == 2 ? this.spread.properties.getColor("HORIZONTAL_GRID_COLOR") : this.spread.properties.getColor("VERTICAL_GRID_COLOR");
        int n = space = gridColor != null ? 1 : 0;
        if (this.orientation == 2) {
            int startCol = this.spread.getSheet().colHeader.getViewPositionAtPoint(rect.x);
            if (startCol == -1) {
                return;
            }
            int endCol = this.spread.getSheet().colHeader.getViewPositionAtPoint(rect.x + rect.width);
            if (endCol == -1) {
                endCol = this.spread.getSheet().colHeader.getViewCount() - 1;
            }
            Rectangle cellRect = new Rectangle();
            int header_h = sheet.colHeader.thickness;
            cellRect.y = 0;
            cellRect.height = header_h;
            cellRect.x = sheet.colHeader.getPoint(startCol);
            for (int c = startCol; c <= endCol; ++c) {
                boolean hasFocus;
                int col_data_index = sheet.colHeader.getDataIndex(c);
                Object value = this.spread.getHeaderValueAt(2, col_data_index);
                cellRect.width = sheet.colHeader.getWidth(col_data_index) + space;
                boolean isSelected = sheet.getHeaderSelection(2, c);
                boolean bl = hasFocus = sheet.focusCol == c && sheet.focusRow == -1;
                if (value instanceof JComponent) {
                    JComponent comp = (JComponent)value;
                    this.add(comp);
                    comp.setBounds(cellRect);
                } else {
                    JSpreadCellRenderer renderer = this.spread.getHeaderRenderer(value, 2, col_data_index);
                    JComponent comp = renderer.getSpreadRendererComponent(this.spread, value, isSelected, hasFocus, 2, 0, col_data_index);
                    this.rendererPane.paintComponent(g2, comp, this, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
                }
                cellRect.x += cellRect.width;
            }
        } else if (this.orientation == 1) {
            int startRow = this.spread.getSheet().rowHeader.getViewPositionAtPoint(rect.y);
            if (startRow == -1) {
                return;
            }
            int endRow = this.spread.getSheet().rowHeader.getViewPositionAtPoint(rect.y + rect.height);
            if (endRow == -1) {
                endRow = this.spread.getSheet().rowHeader.getViewCount() - 1;
            }
            Rectangle cellRect = new Rectangle();
            int header_w = sheet.rowHeader.thickness;
            cellRect.x = 0;
            cellRect.width = header_w;
            cellRect.y = sheet.rowHeader.getPoint(startRow);
            for (int r = startRow; r <= endRow; ++r) {
                boolean hasFocus;
                int row_index = sheet.rowHeader.getDataIndex(r);
                Object value = this.spread.getHeaderValueAt(1, row_index);
                cellRect.height = sheet.rowHeader.getWidth(row_index) + space;
                boolean isSelected = sheet.getHeaderSelection(1, r);
                boolean bl = hasFocus = sheet.focusCol == -1 && sheet.focusRow == r;
                if (value instanceof JComponent) {
                    JComponent comp = (JComponent)value;
                    this.add(comp);
                    comp.setBounds(cellRect);
                } else {
                    JSpreadCellRenderer renderer = this.spread.getHeaderRenderer(value, 1, row_index);
                    JComponent comp = renderer.getSpreadRendererComponent(this.spread, value, isSelected, hasFocus, 1, row_index, 0);
                    this.rendererPane.paintComponent(g2, comp, this, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
                }
                cellRect.y += cellRect.height;
            }
        } else if (this.orientation == 3) {
            boolean hasFocus;
            Rectangle cellRect = new Rectangle();
            int header_w = sheet.rowHeader.thickness;
            int header_h = sheet.colHeader.thickness;
            cellRect.x = 0;
            cellRect.y = 0;
            cellRect.width = header_w;
            cellRect.height = header_h;
            Object value = this.spread.getCornerValue();
            boolean isSelected = this.spread.getSheet().getHeaderSelection(3, 0);
            boolean bl = hasFocus = sheet.focusCol == -1 && sheet.focusRow == -1;
            if (value instanceof JComponent) {
                JComponent comp = (JComponent)value;
                this.add(comp);
                comp.setBounds(cellRect);
            } else {
                JSpreadCellRenderer renderer = this.spread.getHeaderRenderer(value, 3, 0);
                JComponent comp = renderer.getSpreadRendererComponent(this.spread, value, isSelected, hasFocus, 3, 0, 0);
                this.rendererPane.paintComponent(g2, comp, this, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
            }
        }
        logger.debug("exit");
    }

    public Dimension getPreferredSize() {
        JSpreadSheet sheet = this.spread.getSheet();
        switch (this.orientation) {
            case 3: {
                return new Dimension(0, 0);
            }
            case 1: {
                return new Dimension(sheet.rowHeader.thickness, sheet.rowHeader.getTotalWidth());
            }
            case 2: {
                return new Dimension(sheet.colHeader.getTotalWidth(), sheet.colHeader.thickness);
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError(this.orientation);
        }
        return null;
    }

    public String getToolTipText(MouseEvent event) {
        return this.spread.getToolTipText(this.getName(), event);
    }

    static {
        $assertionsDisabled = !JSpreadHeaderPane.class.desiredAssertionStatus();
        logger = Logger.getLogger(JSpreadHeaderPane.class);
    }
}

