/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx.jspread;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import net.sourceforge.swingx.Logger;
import net.sourceforge.swingx.jspread.JSpread;
import net.sourceforge.swingx.jspread.JSpreadHeader;
import net.sourceforge.swingx.jspread.JSpreadHeaderPane;
import net.sourceforge.swingx.jspread.JSpreadSheet;

public class JSpreadHeaderResizeListener {
    private static Logger logger;
    final JSpreadHeaderPane pane;
    final JSpread spread;
    int resizingViewIndex;
    static final /* synthetic */ boolean $assertionsDisabled;

    JSpreadHeaderResizeListener(JSpread spread, JSpreadHeaderPane pane) {
        if (!$assertionsDisabled && spread == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && pane == null) {
            throw new AssertionError();
        }
        this.spread = spread;
        this.pane = pane;
    }

    void mousePressed(MouseEvent e) {
        switch (this.pane.orientation) {
            case 2: {
                this.resizingViewIndex = this.getResizePosition(this.spread.sheet.colHeader, e.getX());
                break;
            }
            case 1: {
                this.resizingViewIndex = this.getResizePosition(this.spread.sheet.rowHeader, e.getY());
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError(this.pane.orientation);
                }
                break;
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        logger.debug(e);
        if (e.isConsumed()) {
            return;
        }
    }

    private void changeWidth(JSpreadHeader header, int pos, int new_width) {
        switch (header.autoResizeMode) {
            case 0: {
                int index = header.getDataIndex(pos);
                header.getInfo(index).setWidth(new_width);
                break;
            }
            case 1: {
                if (pos == header.getViewCount() - 1) break;
                int index = header.getDataIndex(pos);
                header.getInfo(index).setWidth(new_width);
                break;
            }
            case 3: {
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError(header.autoResizeMode);
                }
                break;
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        int new_w;
        if (e.isConsumed()) {
            return;
        }
        JSpreadSheet sheet = this.spread.getSheet();
        int n = new_w = this.pane.orientation == 1 ? e.getY() - sheet.rowHeader.getPoint(this.resizingViewIndex) : e.getX() - sheet.colHeader.getPoint(this.resizingViewIndex);
        if (new_w < 0) {
            return;
        }
        System.out.println("new_w=" + new_w + " resizingViewIndex=" + this.resizingViewIndex);
        if (this.spread.getHeaderSelection(this.pane.orientation, this.resizingViewIndex)) {
            int[] viewIndexList = this.spread.getHeaderSelections(this.pane.orientation);
            int[] newWidthList = new int[viewIndexList.length];
            for (int i = 0; i < viewIndexList.length; ++i) {
                newWidthList[i] = new_w;
            }
            this.requestResize(viewIndexList, newWidthList);
        } else {
            this.requestResize(new int[]{this.resizingViewIndex}, new int[]{new_w});
        }
        this.spread.\u518d\u914d\u7f6e();
        e.consume();
    }

    public void mouseClicked(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        JSpreadSheet sheet = this.spread.getSheet();
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            logger.debug(e);
            switch (this.pane.orientation) {
                case 1: {
                    if (!sheet.allowAutoRowHeaderResize) {
                        return;
                    }
                    int pos = this.getResizePosition(sheet.rowHeader, e.getY());
                    if (pos == -1) break;
                    int rowDataIndex = sheet.rowHeader.getDataIndex(pos);
                    int width = this.spread.headerController.getPreferredWidth(this.pane.orientation, rowDataIndex);
                    if (sheet.getHeaderSelection(this.pane.orientation, pos)) {
                        int[] viewIndexList = this.spread.getHeaderSelections(this.pane.orientation);
                        int[] newWidthList = new int[viewIndexList.length];
                        for (int i = 0; i < newWidthList.length; ++i) {
                            newWidthList[i] = width;
                        }
                        this.requestResize(viewIndexList, newWidthList);
                    } else {
                        this.requestResize(new int[]{pos}, new int[]{width});
                    }
                    this.spread.\u518d\u914d\u7f6e();
                    e.consume();
                    break;
                }
                case 2: {
                    if (!sheet.allowAutoColHeaderResize) {
                        return;
                    }
                    int pos = this.getResizePosition(sheet.colHeader, e.getX());
                    if (pos == -1) break;
                    int colDataIndex = sheet.colHeader.getDataIndex(pos);
                    int width = this.spread.headerController.getPreferredWidth(this.pane.orientation, colDataIndex);
                    if (sheet.getHeaderSelection(this.pane.orientation, pos)) {
                        int[] viewIndexList = this.spread.getHeaderSelections(this.pane.orientation);
                        int[] newWidthList = new int[viewIndexList.length];
                        for (int i = 0; i < newWidthList.length; ++i) {
                            newWidthList[i] = width;
                        }
                        this.requestResize(viewIndexList, newWidthList);
                    } else {
                        this.requestResize(new int[]{pos}, new int[]{width});
                    }
                    this.spread.\u518d\u914d\u7f6e();
                    e.consume();
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }
    }

    public boolean requestResize(int[] viewIndexList, int[] newWidthList) {
        int i;
        int i2;
        if (!$assertionsDisabled && viewIndexList == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && newWidthList == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && viewIndexList.length != newWidthList.length) {
            throw new AssertionError((Object)("\u8981\u7d20\u6570\u304c\u9055\u3046 " + viewIndexList.length + " " + newWidthList.length));
        }
        if (!$assertionsDisabled && viewIndexList.length <= 0) {
            throw new AssertionError(viewIndexList.length);
        }
        JSpreadHeader header = this.pane.orientation == 1 ? this.spread.sheet.rowHeader : this.spread.sheet.colHeader;
        int[] newWidthList2 = new int[newWidthList.length];
        JSpreadHeader.HeaderInfo[] info_list = new JSpreadHeader.HeaderInfo[newWidthList.length];
        int newWidthList2total = 0;
        for (i2 = 0; i2 < newWidthList.length; ++i2) {
            int dataIndex = header.getDataIndex(viewIndexList[i2]);
            info_list[i2] = header.getInfo(dataIndex);
            newWidthList2[i2] = this.minmax(newWidthList[i2], info_list[i2].minWidth, info_list[i2].maxWidth);
            newWidthList2total += newWidthList2[i2];
        }
        if (header.autoResizeMode == 0) {
            for (i2 = 0; i2 < newWidthList.length; ++i2) {
                info_list[i2].width = newWidthList2[i2];
            }
            return true;
        }
        ArrayList<Integer> \u8abf\u6574IndexList = new ArrayList<Integer>();
        switch (header.autoResizeMode) {
            case 1: {
                int maxIndex = this.max(viewIndexList);
                if (maxIndex + 1 >= header.dataIndexList.length) break;
                \u8abf\u6574IndexList.add(new Integer(maxIndex + 1));
                break;
            }
            case 3: {
                int maxIndex = this.max(viewIndexList);
                if (maxIndex + 1 >= header.dataIndexList.length) break;
                \u8abf\u6574IndexList.add(new Integer(header.dataIndexList.length - 1));
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError(header.autoResizeMode);
                }
                break;
            }
        }
        if (\u8abf\u6574IndexList.size() == 0) {
            return false;
        }
        int totalWidth = this.pane.orientation == 2 ? this.pane.getWidth() : this.pane.getHeight();
        int delta = 0;
        for (int i3 = 0; i3 < info_list.length; ++i3) {
            delta += newWidthList2[i3] - info_list[i3].width;
        }
        System.out.println("\u5168\u4f53\u306e\u30b5\u30a4\u30ba=" + totalWidth + " \u5897\u5206=" + delta);
        long max_width = 0L;
        long min_width = 0L;
        long cur_width = 0L;
        for (i = 0; i < \u8abf\u6574IndexList.size(); ++i) {
            int dataIndex = (Integer)\u8abf\u6574IndexList.get(0);
            System.out.println(\u8abf\u6574IndexList.get(i));
            max_width += (long)header.getInfo((int)dataIndex).maxWidth;
            min_width += (long)header.getInfo((int)dataIndex).minWidth;
            cur_width += (long)header.getInfo((int)dataIndex).width;
        }
        System.out.println("\u53d7\u3051\u5165\u308c\u53ef\u80fd\u306a\u5e45=" + min_width + " " + max_width + " " + cur_width + " delta=" + delta);
        if (min_width > cur_width - (long)delta || cur_width - (long)delta > max_width) {
            return false;
        }
        System.out.println("\u53d7\u3051\u5165\u308c\u53ef\u80fd");
        if (\u8abf\u6574IndexList.size() == 1) {
            for (i = 0; i < newWidthList.length; ++i) {
                info_list[i].width = newWidthList2[i];
            }
            int dataIndex = (Integer)\u8abf\u6574IndexList.get(0);
            header.getInfo((int)dataIndex).width -= delta;
            return true;
        }
        return false;
    }

    private int minmax(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    private int max(int[] values) {
        int maxValue = values[0];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] <= maxValue) continue;
            maxValue = values[i];
        }
        return maxValue;
    }

    int getResizePosition(JSpreadHeader header, int x) {
        int pos2;
        int pos1 = header.getViewPositionAtPoint(x - 5);
        if (pos1 != (pos2 = header.getViewPositionAtPoint(x + 5)) && pos1 != -1) {
            return pos1;
        }
        return -1;
    }

    boolean isSensable(int x, int y) {
        switch (this.pane.orientation) {
            case 2: {
                if (!this.spread.sheet.allowAutoColHeaderResize) {
                    return false;
                }
                return this.getResizePosition(this.spread.sheet.colHeader, x) != -1;
            }
            case 1: {
                if (!this.spread.sheet.allowAutoRowHeaderResize) {
                    return false;
                }
                return this.getResizePosition(this.spread.sheet.rowHeader, y) != -1;
            }
        }
        return false;
    }

    void mouseMoved(MouseEvent e) {
        switch (this.pane.orientation) {
            case 2: {
                this.pane.setCursor(this.spread.properties.getCursor("HEADER_RESIZE_H_CURSOR"));
                break;
            }
            case 1: {
                this.pane.setCursor(this.spread.properties.getCursor("HEADER_RESIZE_V_CURSOR"));
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError(this.pane.orientation);
                }
                break;
            }
        }
    }

    Cursor getCursor() {
        switch (this.pane.orientation) {
            case 2: {
                return this.spread.properties.getCursor("HEADER_RESIZE_H_CURSOR");
            }
            case 1: {
                return this.spread.properties.getCursor("HEADER_RESIZE_V_CURSOR");
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError(this.pane.orientation);
        }
        return null;
    }

    static {
        $assertionsDisabled = !JSpreadHeaderResizeListener.class.desiredAssertionStatus();
        logger = Logger.getLogger(JSpreadHeaderResizeListener.class);
    }
}

