/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx.jspread;

import java.util.ArrayList;
import java.util.Arrays;
import net.sourceforge.swingx.jspread.JSpread;
import net.sourceforge.swingx.jspread.JSpreadConstant;
import net.sourceforge.swingx.jspread.JSpreadHeader;

public class JSpreadSheet
implements JSpreadConstant {
    Object[][] data;
    JSpreadHeader rowHeader;
    JSpreadHeader colHeader;
    Object cornerData;
    String name;
    int focusCol;
    int focusRow;
    int curCol;
    int curRow;
    boolean[][] cellSelection;
    boolean[] rowSelection;
    boolean[] colSelection;
    boolean cornerSelection;
    public boolean allowAutoRowHeaderResize = true;
    boolean allowAutoColHeaderResize = true;
    boolean allowRowHeaderReorder = true;
    boolean allowColHeaderReorder = true;
    boolean colHeaderVisible = true;
    boolean rowHeaderVisible = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    JSpreadSheet(JSpread spread, String name, int numRows, int numCols) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && numRows < 0) {
            throw new AssertionError(numRows);
        }
        if (!$assertionsDisabled && numCols < 0) {
            throw new AssertionError(numCols);
        }
        this.data = new Object[numRows][numCols];
        this.rowHeader = new JSpreadHeader(spread, 1, numRows, 32, 15);
        this.colHeader = new JSpreadHeader(spread, 2, numCols, 16, 72);
        this.cornerData = "";
        this.name = name;
        this.focusRow = 0;
        this.focusCol = 0;
        this.curRow = 0;
        this.curCol = 0;
        int numViewRows = this.rowHeader.getViewCount();
        int numViewCols = this.colHeader.getViewCount();
        this.cellSelection = new boolean[numViewRows][numViewCols];
        this.rowSelection = new boolean[numViewRows];
        this.colSelection = new boolean[numViewCols];
        this.cornerSelection = false;
    }

    public JSpreadHeader getHeader(int orientation) {
        if (!$assertionsDisabled && orientation != 1 && orientation != 2) {
            throw new AssertionError(orientation);
        }
        return orientation == 1 ? this.rowHeader : this.colHeader;
    }

    Object getValueAt(int rowDataIndex, int colDataIndex) {
        return this.data[rowDataIndex][colDataIndex];
    }

    void setValueAt(Object value, int rowDataIndex, int columnDataIndex) {
        this.data[rowDataIndex][columnDataIndex] = value;
    }

    Object getHeaderValueAt(int orientation, int dataIndex) {
        if (!$assertionsDisabled && orientation != 1 && orientation != 2 && orientation != 3) {
            throw new AssertionError(orientation);
        }
        switch (orientation) {
            case 1: {
                if (!($assertionsDisabled || 0 <= dataIndex && dataIndex < this.rowHeader.getCount())) {
                    throw new AssertionError(dataIndex);
                }
                return this.rowHeader.getValueAt(dataIndex);
            }
            case 2: {
                if (!($assertionsDisabled || 0 <= dataIndex && dataIndex < this.colHeader.getCount())) {
                    throw new AssertionError(dataIndex);
                }
                return this.colHeader.getValueAt(dataIndex);
            }
            case 3: {
                return this.cornerData;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError(orientation);
        }
        return null;
    }

    void setHeaderValueAt(Object value, int orientation, int dataIndex) {
        if (!$assertionsDisabled && orientation != 1 && orientation != 2) {
            throw new AssertionError(orientation);
        }
        if (orientation == 1) {
            if (!($assertionsDisabled || 0 <= dataIndex && dataIndex < this.rowHeader.getCount())) {
                throw new AssertionError(dataIndex);
            }
            this.rowHeader.setValueAt(dataIndex, value);
        } else {
            if (!($assertionsDisabled || 0 <= dataIndex && dataIndex < this.colHeader.getCount())) {
                throw new AssertionError(dataIndex);
            }
            this.colHeader.setValueAt(dataIndex, value);
        }
    }

    Object getCornerValue() {
        return this.cornerData;
    }

    void setCornerValue(Object value) {
        this.cornerData = value;
    }

    int getCellCount(int orientation) {
        if (!$assertionsDisabled && orientation != 1 && orientation != 2) {
            throw new AssertionError(orientation);
        }
        return orientation == 1 ? this.rowHeader.getCount() : this.colHeader.getCount();
    }

    void setCellCount(int newRowCount, int newColCount, Object initValue) {
        JSpreadHeader.HeaderInfo info;
        int i;
        if (!$assertionsDisabled && newRowCount < 0) {
            throw new AssertionError(newRowCount);
        }
        if (!$assertionsDisabled && newColCount < 0) {
            throw new AssertionError(newColCount);
        }
        int oldRowCount = this.getCellCount(1);
        int oldColCount = this.getCellCount(2);
        if (newRowCount == oldRowCount && newColCount == oldColCount) {
            return;
        }
        Object[][] newData = new Object[newRowCount][newColCount];
        for (int r = 0; r < newRowCount; ++r) {
            for (int c = 0; c < newColCount; ++c) {
                newData[r][c] = r < this.getCellCount(1) && c < this.getCellCount(2) ? this.getValueAt(r, c) : initValue;
            }
        }
        this.data = newData;
        if (newRowCount != this.getCellCount(1)) {
            ArrayList<JSpreadHeader.HeaderInfo> headerInfos = new ArrayList<JSpreadHeader.HeaderInfo>();
            JSpreadHeader header = this.rowHeader;
            i = 0;
            while (i < newRowCount) {
                info = i < oldRowCount ? header.getInfo(i) : new JSpreadHeader.HeaderInfo(null, header.defaultWidth, i);
                info.viewPosition = i++;
                headerInfos.add(info);
            }
            header.infos = headerInfos;
            header.makeDataIndexList();
        }
        if (newColCount != this.getCellCount(2)) {
            ArrayList<JSpreadHeader.HeaderInfo> headerInfos = new ArrayList<JSpreadHeader.HeaderInfo>();
            JSpreadHeader header = this.colHeader;
            i = 0;
            while (i < newColCount) {
                info = i < oldColCount ? header.getInfo(i) : new JSpreadHeader.HeaderInfo(null, header.defaultWidth, i);
                info.viewPosition = i++;
                headerInfos.add(info);
            }
            header.infos = headerInfos;
            header.makeDataIndexList();
        }
        int numViewRows = this.rowHeader.getViewCount();
        int numViewCols = this.colHeader.getViewCount();
        this.cellSelection = new boolean[numViewRows][numViewCols];
        this.rowSelection = new boolean[numViewRows];
        this.colSelection = new boolean[numViewCols];
        this.cornerSelection = false;
        System.out.println(newRowCount + "->" + newRowCount + " viewCount=" + this.rowHeader.getViewCount());
    }

    void insertValueAt(Object value, int header, int dataIndex, int count, Object headerValue) {
        if (!$assertionsDisabled && header == 1 && header == 2) {
            throw new AssertionError(header);
        }
        if (!$assertionsDisabled && 0 > dataIndex && dataIndex != -1) {
            throw new AssertionError(dataIndex);
        }
        if (!$assertionsDisabled && 1 > count) {
            throw new AssertionError(count);
        }
        int rowCount = this.getCellCount(1);
        int colCount = this.getCellCount(2);
        if (header == 1) {
            Object[][] newData = new Object[rowCount + count][colCount];
            if (dataIndex != -1) {
                for (int r = 0; r < rowCount; ++r) {
                    if (r < dataIndex) {
                        newData[r] = this.data[r];
                        continue;
                    }
                    if (r < dataIndex + count) {
                        newData[r] = new Object[colCount];
                        Arrays.fill(newData[r], value);
                        continue;
                    }
                    newData[r] = this.data[r - count];
                }
            } else {
                System.arraycopy(this.data, 0, newData, 0, rowCount);
                for (int i = 0; i < count; ++i) {
                    newData[rowCount + i] = new Object[colCount];
                    Arrays.fill(newData[rowCount + i], value);
                }
            }
            this.data = newData;
        }
        int numViewRows = this.rowHeader.getViewCount();
        int numViewCols = this.colHeader.getViewCount();
        this.cellSelection = new boolean[numViewRows][numViewCols];
        this.rowSelection = new boolean[numViewRows];
        this.colSelection = new boolean[numViewCols];
        this.cornerSelection = false;
    }

    boolean getSelection(int viewRow, int viewCol) {
        if (!($assertionsDisabled || 0 <= viewRow && viewRow < this.rowHeader.getViewCount())) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || 0 <= viewCol && viewCol < this.colHeader.getViewCount())) {
            throw new AssertionError();
        }
        if (this.cellSelection[viewRow][viewCol]) {
            return true;
        }
        if (this.curRow == -1) {
            if (viewCol < this.curCol && viewCol < this.focusCol) {
                return false;
            }
            return viewCol <= this.curCol || viewCol <= this.focusCol;
        }
        if (this.curCol == -1) {
            if (viewRow < this.curRow && viewRow < this.focusRow) {
                return false;
            }
            return viewRow <= this.curRow || viewRow <= this.focusRow;
        }
        if (viewRow < this.curRow && viewRow < this.focusRow) {
            return false;
        }
        if (viewRow > this.curRow && viewRow > this.focusRow) {
            return false;
        }
        if (viewCol < this.curCol && viewCol < this.focusCol) {
            return false;
        }
        return viewCol <= this.curCol || viewCol <= this.focusCol;
    }

    public boolean[] getSelectionArray(int rowcol) {
        if (!$assertionsDisabled && rowcol != 1 && rowcol != 2) {
            throw new AssertionError(rowcol);
        }
        if (rowcol == 1) {
            boolean[] result = new boolean[this.rowHeader.getViewCount()];
            if (this.curRow == -1) {
                for (int r = 0; r < result.length; ++r) {
                    result[r] = true;
                }
                return result;
            }
            block1: for (int r = 0; r < result.length; ++r) {
                if (r < this.curRow && r < this.focusRow || r > this.curRow && r > this.focusRow) {
                    for (int c = 0; c < this.colHeader.getViewCount(); ++c) {
                        if (!this.cellSelection[r][c]) continue;
                        result[r] = true;
                        continue block1;
                    }
                    continue;
                }
                result[r] = true;
            }
            return result;
        }
        return null;
    }

    void setSelection(int viewRow, int viewCol, boolean value) {
        if (!($assertionsDisabled || 0 <= viewRow && viewRow < this.rowHeader.getViewCount())) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || 0 <= viewCol && viewCol < this.colHeader.getViewCount())) {
            throw new AssertionError();
        }
        this.cellSelection[viewRow][viewCol] = value;
    }

    public void setSelectionAll(boolean value) {
        for (int r = 0; r < this.cellSelection.length; ++r) {
            for (int c = 0; c < this.cellSelection[r].length; ++c) {
                this.cellSelection[r][c] = value;
            }
        }
    }

    void setSelection(int row1, int col1, int row2, int col2, boolean value) {
        if (!($assertionsDisabled || 0 <= row1 && row1 < this.rowHeader.getViewCount() || row1 == -1)) {
            throw new AssertionError(row1);
        }
        if (!($assertionsDisabled || 0 <= col1 && col1 < this.colHeader.getViewCount() || col1 == -1)) {
            throw new AssertionError(col1);
        }
        if (!($assertionsDisabled || 0 <= row2 && row2 < this.rowHeader.getViewCount() || row2 == -1)) {
            throw new AssertionError(row2);
        }
        if (!($assertionsDisabled || 0 <= col2 && col2 < this.colHeader.getViewCount() || col2 == -1)) {
            throw new AssertionError(col2);
        }
        int rowMin = Math.min(row1, row2);
        int rowMax = Math.max(row1, row2);
        int colMin = Math.min(col1, col2);
        int colMax = Math.max(col1, col2);
        if (col1 == -1 || col2 == -1) {
            colMin = 0;
            colMax = this.colHeader.getViewCount() - 1;
        }
        if (row1 == -1 || row2 == -1) {
            rowMin = 0;
            rowMax = this.rowHeader.getViewCount() - 1;
        }
        for (int r = rowMin; r <= rowMax; ++r) {
            for (int c = colMin; c <= colMax; ++c) {
                this.cellSelection[r][c] = value;
            }
        }
    }

    boolean getHeaderSelection(int orientation, int index) {
        if (!$assertionsDisabled && orientation != 1 && orientation != 2 && orientation != 3) {
            throw new AssertionError(orientation);
        }
        switch (orientation) {
            case 1: {
                if (this.rowSelection[index]) {
                    return true;
                }
                if (this.curCol != -1) {
                    return false;
                }
                int min = Math.min(this.curRow, this.focusRow);
                int max = Math.max(this.curRow, this.focusRow);
                return min <= index && index <= max;
            }
            case 2: {
                if (this.colSelection[index]) {
                    return true;
                }
                if (this.curRow != -1) {
                    return false;
                }
                int min = Math.min(this.curCol, this.focusCol);
                int max = Math.max(this.curCol, this.focusCol);
                return min <= index && index <= max;
            }
            case 3: {
                return this.cornerSelection;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return false;
    }

    void setHeaderSelectionAll(int orientation, boolean value) {
        if (!$assertionsDisabled && orientation != 1 && orientation != 2) {
            throw new AssertionError();
        }
        if (orientation == 1) {
            for (int i = 0; i < this.rowSelection.length; ++i) {
                this.rowSelection[i] = value;
            }
        } else {
            for (int i = 0; i < this.colSelection.length; ++i) {
                this.colSelection[i] = value;
            }
        }
    }

    void setCornerSelection(boolean value) {
        this.cornerSelection = value;
    }

    boolean inv() {
        if (!$assertionsDisabled && this.rowHeader == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.colHeader == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.name == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || 0 <= this.focusCol && this.focusCol < this.colHeader.getViewCount())) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || 0 <= this.focusRow && this.focusRow < this.rowHeader.getViewCount())) {
            throw new AssertionError();
        }
        return true;
    }

    public CurrentFocus getCurrentFocus() {
        return new CurrentFocus(this.focusCol, this.focusRow, this.curCol, this.curRow);
    }

    static {
        $assertionsDisabled = !JSpreadSheet.class.desiredAssertionStatus();
    }

    static class CurrentFocus {
        int focusCol;
        int focusRow;
        int curCol;
        int curRow;

        CurrentFocus(int focusCol, int focusRow, int curCol, int curRow) {
            this.focusCol = focusCol;
            this.focusRow = focusRow;
            this.curCol = curCol;
            this.curRow = curRow;
        }

        public boolean equals(Object obj) {
            CurrentFocus cf = (CurrentFocus)obj;
            return this.focusCol == cf.focusCol && this.focusRow == cf.focusRow && this.curCol == cf.curCol && this.curRow == cf.curRow;
        }
    }
}

