/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.swingx.jspread;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class JSpreadUtilities {
    static Graphics2D image_g2;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Rectangle2D.Float getTextRectangle(Graphics2D g2, String text, Font font) {
        if (!$assertionsDisabled && text == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && font == null) {
            throw new AssertionError();
        }
        if (g2 == null) {
            g2 = image_g2;
        }
        if (!($assertionsDisabled || text != null && text.length() > 0)) {
            throw new AssertionError((Object)text);
        }
        FontRenderContext frc = g2.getFontRenderContext();
        TextLayout tl = new TextLayout(text, font, frc);
        return new Rectangle2D.Float(0.0f, -tl.getAscent(), tl.getAdvance(), tl.getAscent() + tl.getDescent());
    }

    public static void drawText(Graphics2D g2, Rectangle rect, String text, Font font, float alignmentX, float alignmentY, boolean clipping) {
        if (!$assertionsDisabled && rect == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && text == null) {
            throw new AssertionError((Object)text);
        }
        if (!$assertionsDisabled && font == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || 0.0f <= alignmentX && alignmentX <= 1.0f)) {
            throw new AssertionError(alignmentX);
        }
        if (!($assertionsDisabled || 0.0f <= alignmentY && alignmentY <= 1.0f)) {
            throw new AssertionError(alignmentY);
        }
        if (text.length() == 0) {
            return;
        }
        Rectangle2D.Float textrect = JSpreadUtilities.getTextRectangle(g2, text, font);
        float x = (float)rect.x + ((float)rect.width - textrect.width) * alignmentX;
        float y = (float)rect.y + ((float)rect.height - textrect.height) * alignmentY;
        g2.drawString(text, x, y - textrect.y);
    }

    public static URL getUrl(String name) {
        return JSpreadUtilities.class.getResource(name);
    }

    public static Cursor getAutoResizeCursor(String resourcename, String cursorname, int x, int y) throws IOException {
        BufferedImage bi = ImageIO.read(JSpreadUtilities.getUrl(resourcename));
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(bi, new Point(x, y), cursorname);
        return cursor;
    }

    public static Cursor getCursor(String resourcename, String cursorname, int x, int y) throws IOException {
        BufferedImage image = ImageIO.read(JSpreadUtilities.getUrl(resourcename));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dim = toolkit.getBestCursorSize(image.getWidth(), image.getHeight());
        if (dim.width != image.getWidth() || dim.height != image.getHeight()) {
            BufferedImage newimage = new BufferedImage(dim.width, dim.height, 6);
            Graphics2D g2 = (Graphics2D)newimage.getGraphics();
            g2.drawImage(image, 0, 0, new Color(255, 0, 0, 0), null);
            image = newimage;
        }
        Cursor cursor = toolkit.createCustomCursor(image, new Point(x, y), cursorname);
        return cursor;
    }

    public static ImageIcon getImageIcon(String name) {
        URL url = JSpreadUtilities.class.getResource(name);
        return new ImageIcon(url);
    }

    public static JComponent getComponent(JComponent comp, String name) {
        if (name.equals(comp.getName())) {
            return comp;
        }
        for (int i = 0; i < comp.getComponentCount(); ++i) {
            JComponent c;
            JComponent result;
            if (!(comp.getComponent(i) instanceof JComponent) || (result = JSpreadUtilities.getComponent(c = (JComponent)comp.getComponent(i), name)) == null) continue;
            return result;
        }
        return null;
    }

    public static String toString(Rectangle rect) {
        return "Rectangle[x=" + rect.x + ", y=" + rect.y + ", width=" + rect.width + ", height=" + rect.height + "]";
    }

    static {
        $assertionsDisabled = !JSpreadUtilities.class.desiredAssertionStatus();
        image_g2 = new BufferedImage(1, 1, 6).createGraphics();
    }
}

