package asandatabasebrowser;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

import net.sourceforge.swingx.SxMessageBox;
import net.sourceforge.swingx.SxOptionPane;
import net.sourceforge.swingx.SxSprashFrame;
import net.sourceforge.swingx.SxTextUtilities;
import asandatabasebrowser.model.DbData;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.DbLargeObject;
import asandatabasebrowser.model.FavoriteSQL;
import asandatabasebrowser.model.FavoriteTable;
import asandatabasebrowser.model.ITableInfo;
import asandatabasebrowser.model.SchemaInfo;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.model.VvDocument;
import asandatabasebrowser.view.ConnectDialog;
import asandatabasebrowser.view.DbExecuteFrame;
import asandatabasebrowser.view.DbSqlFrame;
import asandatabasebrowser.view.DbTableFrame2;
import asandatabasebrowser.view.DbTextFrame;
import asandatabasebrowser.view.DbTreeFrame;
import asandatabasebrowser.view.DbTreeView;
import asandatabasebrowser.view.SqlLogView;



/** AvP[V. */
public class AsanDatabaseBrowser {
	public static final String TITLE = "AsanDatabaseBrowser";
	public static final String ASAN_DATABASE_BROWSER_FILE = "AsanDatabaseBrowser.xml";
	/** @deprecated ʌ݊̂ߎcĂ܂B */
	public static final String VERTICAL_VIEWER_FILE = "VerticalViewer.xml";
    
	 
	
	/** g */
	public static AsanDatabaseBrowser theApp;
	/** . */
	public static String[] args;
	/** c[t[ */
	DbTreeFrame treeFrame = null;
	/** ̃t[. */
	private ArrayList frameList = new ArrayList();	// <JFrame>
	public VvDocument doc = new VvDocument();
	public SqlLogView logView = null;
	private AsanDatabaseBrowser() {}

	public boolean initInstance(String[] args) {
		try {
			// vpeBǂݍށB
			File file = new File(ASAN_DATABASE_BROWSER_FILE);
			File file2 = new File(VERTICAL_VIEWER_FILE);
			if (file.exists()) {
				doc.loadXml(file);
			} else if (file2.exists()) {
				doc.loadVerticalViewerXml(file2);
			} else {
				doc.loadProperties();
			}
			return true;
		} catch (DbException e) {
			showMessage(treeFrame, 
					"ݒt@C̓ǂݍ݂Ɏs܂B", 
					e, SxOptionPane.OK_ONLY_OPTION, SxOptionPane.ERROR_MESSAGE);
			return false;
		}
	}
	public void exitInstance() {
		// ȂĂDBؒfB
		for (int i=0; i<doc.databaseList.size(); i++) {
			VvDatabase db = (VvDatabase) doc.databaseList.get(i);
			if (db.getConnection() != null) {
				try {
					db.disconnect();
				} catch (DbException e) {
					e.printStackTrace();
				}
			}
		}
		// ݒۑ
		try {
			// ݒۑBҏWꂽƂA邢͏߂Ă VerticalViewer ̈ڍsB
			File file = new File(ASAN_DATABASE_BROWSER_FILE);
			if (doc.isModified() || ! file.exists()) {
				// O̐ݒc߁Al[ĎcB
				if (file.exists()) {
					// "AsanDatabaseBrowser20080121.xml"
					SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd_HHmm");
					Date now = Calendar.getInstance().getTime();
					String bakname = TITLE+f.format(now)+ ".xml";
					file.renameTo(new File(bakname));
				}
				doc.storeXml(file);
			}
		} catch (DbException e) {
			e.printStackTrace();
		}
		System.exit(0);
	}
	/** w肳ꂽt[. */
	public void close(JFrame frame) {
		frameList.remove(frame);
	}
	public void openFrame(JFrame newFrame) {
		newFrame.setLocation(300, frameList.size()*20);
		frameList.add(newFrame);
		newFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				//System.out.println(e);
				close((JFrame) e.getWindow());
			}
		});
		newFrame.setVisible(true);
	}
	/** SQLt[J. */
	public void openSqlFrame(VvDatabase db, String sql) throws DbException {
		//System.out.println("openSqlFrame("+sql+")");
		DbSqlFrame newFrame = new DbSqlFrame(db);
		newFrame.addSqlTab(sql);
		DbData data = db.getRecordList(sql);
		newFrame.updateData(data);
		openFrame(newFrame);
	}
	/** SQLt[J. */
	public void openSqlFrame(VvDatabase db, FavoriteSQL sql) throws DbException {
		//System.out.println("openSqlFrame("+sql+")");
		DbSqlFrame newFrame = new DbSqlFrame(db);
		for (int i=0; i<sql.getCount(); i++) {
			newFrame.addSqlTab(sql.getSql(i));
		}
		if (sql.getCount() > 0) {
			DbData data = db.getRecordList(sql.getSql(0));
			newFrame.updateData(data);
			newFrame.textarea.setSelectedIndex(0);
		}
		openFrame(newFrame);
	}
	/** e[ut[J. */
	public void openTableFrame(TableInfo table) throws DbException {
		//System.out.println("openTableFrame("+table+")");
//		DbTableFrame newFrame = new DbTableFrame(table);
//		openFrame(newFrame);
		DbTableFrame2 newFrame2 = new DbTableFrame2(table);
		openFrame(newFrame2);
	}
	public void openTableFrame(FavoriteTable fav) throws DbException {
        // ڑ擾B
        VvDatabase db = null;
        for (int i=0; i<doc.databaseList.size(); i++) {
        	VvDatabase d = (VvDatabase) doc.databaseList.get(i);
        	if (d.name.equals(fav.dbName)) {
        		db = d;
        		break;
        	}
        }
        if (db == null) throw new DbException("ڑ悪݂܂:"+db.name);	// ڑ悪݂ȂIH
        // RlNV擾B
        Connection conn = db.getConnection();
        // ڑĂȂڑB
        if (conn == null) {
        	try {
        		// DBɐڑBKvȂ΃_CAO\ă[UpX[h͂B
				boolean rc = connect(db);
				if (!rc) return;
				conn = db.getConnection();
				assert conn != null;
				// Databasec[̎}𐶐B
		    	DbTreeView dbtree = treeFrame.getTree();
	        	DefaultMutableTreeNode dbnode = dbtree.getNodeByUserObject(db);
				dbtree.ڑ̂Ŏ}(dbnode, db);
			} catch (DbException e1) {
				throw new DbException("f[^x[X̐ڑɎs܂", e1);
			}
        }
        try {
            // YJ^O/XL[}擾B
            SchemaInfo schema = null;
            ArrayList list = db.getSchemaInfoList();
            for (int i=0; i<list.size(); i++) {
            	SchemaInfo s = (SchemaInfo) list.get(i);
            	if (SxTextUtilities.equalsString(fav.tableCatalog, s.getCatalogName()) &&
            			SxTextUtilities.equalsString(fav.tableSchema, s.getSchemaName()) ) {
            		schema = s;
            		break;
            	}
            }
            if (schema == null) {
            	throw new DbException("̂悤ȃJ^O/XL[}݂͑܂Bcatalog="+
                		fav.tableCatalog+" schema="+fav.tableSchema);
            }
            // Ye[u擾B
            TableInfo table = schema.getTableTypeInfo(fav.tableType).getTableInfo(fav.tableName);
            openTableFrame(table);
        }catch (DbException ex) {
        	throw new DbException("e[uJƂł܂", ex);
        }
	}
	public void openExecuteFrame(VvDatabase db) {
		//System.out.println("openExecuteFrame("+table+")");
		DbExecuteFrame newFrame = new DbExecuteFrame(db);
		openFrame(newFrame);
	}
	
	public void openTextFrame(String title, String text, boolean editable) throws DbException {
		DbTextFrame newFrame = new DbTextFrame(title, editable);
		newFrame.setText(text);
		openFrame(newFrame);
	}
	public void openBinaryFrame(String title, byte[] data) throws DbException {
		String text = SxTextUtilities.dump(data);
		DbTextFrame newFrame = new DbTextFrame(title, false);
		newFrame.setText(text);
		newFrame.setContent(data);
		openFrame(newFrame);
	}

	public void openLargeObject(Object data, ITableInfo tableInfo, Object[] rec, int row) 
					throws DbException {
		if (data instanceof DbLargeObject) {
			DbLargeObject lob = (DbLargeObject) data;
//			String typename = lob.type;
			String title = lob.title;
			data = lob.getValue();
			if (data == null) {
				if (tableInfo instanceof TableInfo) {
					AsanDatabaseBrowser.theApp.showMessage(treeFrame, 
							"ŝ߁Af[^͉܂B\nČ܂H", 
							null, SxOptionPane.OK_CANCEL_OPTION, SxOptionPane.QUESTION_MESSAGE);
					TableInfo table = (TableInfo) tableInfo;
					Object obj = table.db.getColumnValue(table, rec, row);
					if (obj == null) {
						AsanDatabaseBrowser.theApp.showMessage(treeFrame, 
								"NULL łB", 
								null, SxOptionPane.OK_ONLY_OPTION, SxOptionPane.INFORMATION_MESSAGE);
						return;
					}
					lob = (DbLargeObject) obj;
					data = lob.getValue();

				} else {
					AsanDatabaseBrowser.theApp.showMessage(treeFrame, 
							"ŝ߁Af[^͉܂B", 
							null, SxOptionPane.OK_ONLY_OPTION, SxOptionPane.ERROR_MESSAGE);
					return;
				}
			}

			try {
				// CLOB^̏ꍇAr[AJB
				if (data instanceof String) {
					AsanDatabaseBrowser.theApp.openTextFrame(title, (String) data, false);
				}
				// BLOB, byte[]^(OracleRAW^)̏ꍇAr[AJB
				else if ( data instanceof byte[]) {
					AsanDatabaseBrowser.theApp.openBinaryFrame(title, (byte[]) data);
				}
				// o킵ƂȂ̂ŁA悭ȂEEE
				else if (data instanceof Struct) {
					Struct struct = (Struct) data;
					System.out.println("SQLTypeName="+struct.getSQLTypeName());
					Object[] objs = struct.getAttributes();
					for (int i=0; i<objs.length; i++) {
						System.out.println("["+i+"]="+objs[i]);
						if (objs[i] != null && objs[i] instanceof java.sql.Array) {
							java.sql.Array ary = (java.sql.Array) objs[i];
							System.out.println("BaseTypeName="+ary.getBaseTypeName());
							System.out.println("getArray()="+ary.getArray());
							if (ary.getArray() instanceof Object[]) {
								Object[] o = (Object[]) ary.getArray();
								for (int j=0; j<o.length; j++) {
									System.out.println("o["+j+"]="+o[j]);
								}
							}
							                                          
						}
					}
				}
				else {
					System.out.println(data);
				}
			} catch (SQLException e) {
				throw new DbException("LargeObject̒l̎擾Ɏs܂B", e);
			}
		}
	}

    public boolean connect(VvDatabase db) throws DbException {
    	// ftHg̃[U
    	String user = db.user;
    	String pass = db.password;
    	// ڑɃ[UƃpX[h₢킹
    	if (db.isShowLoginDialog) {
        	ConnectDialog dialog = new ConnectDialog();
    		dialog.setDatabase(db);
            int ret = JOptionPane.showConfirmDialog(treeFrame, 
            	dialog,
                "f[^x[Xւ̐ڑ", 
                JOptionPane.OK_CANCEL_OPTION,
                JOptionPane.PLAIN_MESSAGE);
 	    	if (ret != JOptionPane.OK_OPTION) return false;
	    	user = dialog.getUser();
	    	pass = dialog.getPass();
    	}

    	// ڑ
    	try {
    		treeFrame.setCursor(new Cursor(Cursor.WAIT_CURSOR));
			db.connect(user, pass);
			return true;
		} finally {
			treeFrame.setCursor(Cursor.getDefaultCursor());
			treeFrame.updateMainFrame();
		}    	
    }

	public List getFrameList() {
		return frameList;
	}
	public DbTreeFrame getTreeFrame() {
		return treeFrame;
	}

	/**
	 * bZ[W{bNX\.
	 * @param	messageType	JOptionPane.ERROR_MESSAGE JOptionPane.INFORMATION_MESSAGE 
	 * 	JOptionPane.WARNING_MESSAGE JOptionPane.QUESTION_MESSAGE 
	 * JOptionPane.PLAIN_MESSAGE ̂ꂩ 
	 */
	public int showMessage(final Component parent, final String message, final Throwable t,
			final int optionType, final int messageType) {
		assert SwingUtilities.isEventDispatchThread();
		return SxMessageBox.show(parent, TITLE, message, t, optionType, messageType);
	}
	/**
	 * bZ[W{bNX\.
	 * @param	messageType	JOptionPane.ERROR_MESSAGE JOptionPane.INFORMATION_MESSAGE 
	 * 	JOptionPane.WARNING_MESSAGE JOptionPane.QUESTION_MESSAGE 
	 * JOptionPane.PLAIN_MESSAGE ̂ꂩ 
	 */
	public int showMessage(final Component parent, final String message, final Throwable t,
			final int messageType) {
		assert SwingUtilities.isEventDispatchThread();
		return showMessage(parent, message, t, SxOptionPane.OK_ONLY_OPTION, messageType);
	}
	/**
	 * bZ[W{bNX\B
	 * SwingCxgfBXpb`XbhȊOĂԂƂɂ́Agp邱ƁB
	 */
	public void invokeShowMessage(final Component parent, final String message, final Throwable t, 
			final int optionType, final int messageType) {
		try {
			SwingUtilities.invokeAndWait(new Runnable() {
				public void run() {
					SxMessageBox.show(parent, TITLE, message, t, optionType, messageType);
				}
			});
		} catch (InterruptedException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		}
	}
	/**
	 * JavaVM -Ddebug=trueݒ肷ƁAfobO[hŋN܂B 
	 * @param args	R}hC.
	 * @throws DbException
	 */
	public static void main(final String[] args) throws DbException {
		// XbLƂtHgɂB
		System.setProperty("swing.plaf.metal.controlFont", "Dialog-12");
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
//                SxSprashFrame sprash = new SxSprashFrame(TITLE, 
//                		Global.getImageIcon("/resources/AsanDatabaseBrowser.png"));
        		AsanDatabaseBrowser.args = args;
        		AsanDatabaseBrowser.theApp = new AsanDatabaseBrowser();
        		if (theApp.initInstance(args)) {
        			theApp.treeFrame = new DbTreeFrame(theApp);
        			theApp.treeFrame.updateMainFrame();
        			theApp.logView = new SqlLogView();
        		}
//        		sprash.invokeDispose(700);	// 0.7sec
            }
        });
	}

}
