package asandatabasebrowser.action;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;

import net.sourceforge.swingx.SxAboutDialog;
import net.sourceforge.swingx.SxOptionPane;
import net.sourceforge.swingx.SxUtilities;
import asandatabasebrowser.view.AnimationPanel;

public class AboutAction extends AbstractAction {
	final JFrame frame;
	public AboutAction(JFrame frame) {
		super("o[W(A) ...");
		putValue(MNEMONIC_KEY, new Integer('A'));
		putValue(SHORT_DESCRIPTION, "o[W...");
		putValue(LONG_DESCRIPTION, "o[W...");
		this.frame = frame;
	}

    public void actionPerformed(ActionEvent ev) {
    	JTextPane textpane = new JTextPane();
    	textpane.setContentType("text/html");
    	textpane.setText("<html>"+
    			"<font size=\"+5\" color=\"blue\">Asan Database Browser</font> version 0.00<br>"+
                "<br>"+
//                "e[u\`ŕ\r[ƁA<br>"+
//                "IꂽR[hvpeB̂悤ɏcɕ\r[<br>"+
//                "f[^x[XEr[A<br>"+
//                "<br>"+
                "Copyright (C) Yoshinori Watanabe(A-san). 2002-2009. All Rights Reserved.<br>"+
                "build: "+ getBuildDate()+
    			"</html>");
    	textpane.setEditable(false);
    	textpane.setOpaque(false);
    	SxUtilities.addPopupMenuMouseListener(textpane);
    	textpane.setBorder(new EmptyBorder(20,20,20,20));
    	JTabbedPane tab = new JTabbedPane();
    	//tab.addTab("A-san Database Browser", new JLabel(Global.asanDatabaseBrowserImage));
		AnimationPanel anime = new AnimationPanel();
		tab.addTab("Animation", anime);
		new Thread(anime).start();
 	
    	tab.addTab("o[W", textpane);
    	tab.addTab("SystemProperties", SxAboutDialog.createJavaVmPanel());
    	SxOptionPane.showMessageDialog(frame,
     			tab,
                "o[W(AsanDatabaseBrowser)",
                SxOptionPane.OK_ONLY_OPTION,
                SxOptionPane.PLAIN_MESSAGE, null);
    }
    /** rhꂽ擾B */
    String getBuildDate() {
    	// jart@C̒̃t@C擾B
    	java.net.URL url = AboutAction.class.getResource("/asandatabasebrowser/build.log");
        System.out.println("url="+url);
        if (url == null) return null;	    // 擾łȂB    
        // t@Crhꂽ擾B
        BufferedReader reader = null;
        try {
        	reader = new BufferedReader(new InputStreamReader(url.openStream()));
			String line = reader.readLine();
			return line;
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (reader != null) {
				try { reader.close(); } catch (IOException e) {}
			}
		}
     	return null;	    // 擾łȂB    
    }
}

