package asandatabasebrowser.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import net.sourceforge.swingx.SxOptionPane;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.FavoriteGroup;
import asandatabasebrowser.model.FavoriteTable;
import asandatabasebrowser.model.SchemaInfo;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.TableTypeInfo;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.DbCountDialog;
import asandatabasebrowser.view.DbTreeView;
import asandatabasebrowser.view.FavoriteTree;

/**
 * R[hꗗ
 * @author Yoshinori-Watanabe
 *
 */
public class CountListAction extends AbstractAction {
	AsanDatabaseBrowser tools;
	
	public CountListAction(AsanDatabaseBrowser tools) {
		super("R[h");
		putValue(SHORT_DESCRIPTION, 
				"Iꂽe[uA̓XL[}/J^OɂSe[ũR[h\܂");
		putValue(LONG_DESCRIPTION, 
				"Iꂽe[uA̓XL[}/J^OɂSe[ũR[h\܂");
		this.tools = tools;
	}

	public void actionPerformed(ActionEvent ev) {
		try {
			// IꂽTableInfoW߂B
	        ArrayList list = new ArrayList();	// ArrayList<TableInfo>
			if (tools.getTreeFrame().tab.getSelectedIndex() == 0) {
		        // Database^ûƂA
				DbTreeView tree = tools.getTreeFrame().getTree();
				TreePath[] paths = tree.getSelectionPaths();
				for (int i=0; i<paths.length; i++) {
					DefaultMutableTreeNode node = (DefaultMutableTreeNode) paths[i].getLastPathComponent();
					Object obj = node.getUserObject();
					if (obj instanceof SchemaInfo) {
						SchemaInfo schema = (SchemaInfo) node.getUserObject();
				        for (int j=0; j<schema.getCount(); j++) {
				        	TableTypeInfo type = schema.getTableTypeInfo(j);
				        	for (int t=0; t<type.getCount(); t++) {
				        		if (! list.contains(type.getTableInfo(t)))
				        			list.add(type.getTableInfo(t));
				        	}
				        }
					} else if (obj instanceof TableTypeInfo) {
			        	TableTypeInfo type = (TableTypeInfo) obj;
			        	for (int t=0; t<type.getCount(); t++) {
			        		if (! list.contains(type.getTableInfo(t)))
			        			list.add(type.getTableInfo(t));
			        	}
					} else if (obj instanceof TableInfo) {
		        		if (! list.contains(obj))
		        			list.add(obj);
					}
				}
			} else {
				// Cɓ^ûƂA
				FavoriteTree tree = tools.getTreeFrame().getFavTree();
				Object[] objs = tree.getSelectionNodeObjects();
				if (objs == null) return;
				ArrayList favlist = new ArrayList();
				// FavoriteTableW߂B
				for (int i=0; i<objs.length; i++) {
					if (objs[i] instanceof FavoriteTable) {
						favlist.add(objs[i]);
					}
				}
				// FavoriteTableȂ΁AFavoriteGroupFavoriteTableW߂B
				if (favlist.size() == 0) {
					for (int i=0; i<objs.length; i++) {
						if (objs[i] instanceof FavoriteGroup) {
							FavoriteGroup fg = (FavoriteGroup) objs[i];
							for (int g=0; g<fg.getCount(); g++) {
								favlist.add(fg.get(g));
							}
						}
					}
				}
				// TableInfoɕϊB
				for (int i=0; i<favlist.size(); i++) {
					FavoriteTable favtable = (FavoriteTable) favlist.get(i);
					VvDatabase db = tools.doc.getDatabaseFromFavorite(favtable);
					if (db == null) {
						tools.showMessage(tools.getTreeFrame(), 
									"w肳ꂽDB܂B:"+favtable.dbName, null, 
									SxOptionPane.OK_ONLY_OPTION, SxOptionPane.ERROR_MESSAGE);
						return;
					}
					if (db.getConnection() == null) {
						tools.showMessage(tools.getTreeFrame(), 
								"w肳ꂽDB͐ڑĂ܂B:"+favtable.dbName, null, 
								SxOptionPane.OK_ONLY_OPTION, SxOptionPane.ERROR_MESSAGE);
						return;
					}
					TableInfo t = tools.doc.getTableInfoFromFavorite(favtable);
					list.add(t);
				}
			}
						
			// Iꂽ TableInfo Ȃ_
			if (list.size() == 0) return;
			// TCYPȂ烁bZ[W{bNXŁA
			if (list.size() == 1) {
				TableInfo tableInfo = (TableInfo) list.get(0);
				int count = tableInfo.db.getRecordCount(tableInfo);
		        // _CAO\
				JOptionPane.showMessageDialog(tools.getTreeFrame(), 
						tableInfo.getSqlTableName() + "\n"+ count +" ",
							"count(*)", JOptionPane.INFORMATION_MESSAGE);
			} else {
				// ̎ɂ̓_CAO\
				DbCountDialog dialog = new DbCountDialog(tools.getTreeFrame(), list);
				dialog.pack();
				dialog.setVisible(true);				
			}
		}
		catch (DbException e) {
			tools.showMessage(tools.getTreeFrame(), 
					"R[h̎擾Ɏs܂", e, 
					SxOptionPane.OK_ONLY_OPTION, SxOptionPane.ERROR_MESSAGE);
		}
	}
	
}

