package asandatabasebrowser.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import net.sourceforge.swingx.SxOptionPane;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.FavoriteGroup;
import asandatabasebrowser.model.FavoriteTable;
import asandatabasebrowser.model.SchemaInfo;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.TableTypeInfo;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.util.SqlGenerator;
import asandatabasebrowser.view.DbTreeView;
import asandatabasebrowser.view.FavoriteTree;


public class CreateDdlAction extends AbstractAction {
	AsanDatabaseBrowser tools;
	
	public CreateDdlAction(AsanDatabaseBrowser tools) {
		super("DDL쐬");
		putValue(SHORT_DESCRIPTION,	"Iꂽe[uDDL쐬܂");
		putValue(LONG_DESCRIPTION, "Iꂽe[uDDL쐬܂");
		this.tools = tools;
	}

	public void actionPerformed(ActionEvent ev) {
		// IꂽTableInfoW߂B
        ArrayList list = new ArrayList();	// ArrayList<TableInfo>
		if (tools.getTreeFrame().tab.getSelectedIndex() == 0) {
	        // Database^ûƂA
			DbTreeView tree = tools.getTreeFrame().getTree();
			TreePath[] paths = tree.getSelectionPaths();
			for (int i=0; i<paths.length; i++) {
				DefaultMutableTreeNode node = (DefaultMutableTreeNode) paths[i].getLastPathComponent();
				Object obj = node.getUserObject();
				if (obj instanceof SchemaInfo) {
					SchemaInfo schema = (SchemaInfo) node.getUserObject();
			        for (int j=0; j<schema.getCount(); j++) {
			        	TableTypeInfo type = schema.getTableTypeInfo(j);
			        	for (int t=0; t<type.getCount(); t++) {
			        		if (! list.contains(type.getTableInfo(t)))
			        			list.add(type.getTableInfo(t));
			        	}
			        }
				} else if (obj instanceof TableTypeInfo) {
		        	TableTypeInfo type = (TableTypeInfo) obj;
		        	for (int t=0; t<type.getCount(); t++) {
		        		if (! list.contains(type.getTableInfo(t)))
		        			list.add(type.getTableInfo(t));
		        	}
				} else if (obj instanceof TableInfo) {
	        		if (! list.contains(obj))
	        			list.add(obj);
				}
			}
		} else {
			// Cɓ^ûƂA
			FavoriteTree tree = tools.getTreeFrame().getFavTree();
			Object[] objs = tree.getSelectionNodeObjects();
			if (objs == null) return;
			ArrayList favlist = new ArrayList();
			// FavoriteTableW߂B
			for (int i=0; i<objs.length; i++) {
				if (objs[i] instanceof FavoriteTable) {
					favlist.add(objs[i]);
				}
			}
			// FavoriteTableȂ΁AFavoriteGroupFavoriteTableW߂B
			if (favlist.size() == 0) {
				for (int i=0; i<objs.length; i++) {
					if (objs[i] instanceof FavoriteGroup) {
						FavoriteGroup fg = (FavoriteGroup) objs[i];
						for (int g=0; g<fg.getCount(); g++) {
							favlist.add(fg.get(g));
						}
					}
				}
			}
			// TableInfoɕϊB
			for (int i=0; i<favlist.size(); i++) {
				FavoriteTable favtable = (FavoriteTable) favlist.get(i);
				VvDatabase db = tools.doc.getDatabaseFromFavorite(favtable);
				if (db == null) {
					tools.showMessage(tools.getTreeFrame(), 
								"w肳ꂽDB܂B:"+favtable.dbName, null, 
								JOptionPane.ERROR);
					return;
				}
				if (db.getConnection() == null) {
					tools.showMessage(tools.getTreeFrame(), 
							"w肳ꂽDB͐ڑĂ܂B:"+favtable.dbName, null, 
							JOptionPane.ERROR);
					return;
				}
				TableInfo t = tools.doc.getTableInfoFromFavorite(favtable);
				list.add(t);
			}
		}

        if (list.size() == 0) {
        	tools.showMessage(tools.getTreeFrame(), "e[uIĂ܂", null, SxOptionPane.WARNING_MESSAGE);
        	return;
        }
        try { 
	        //  
			SqlGenerator generator = new SqlGenerator("templateDDL.xml");
			String ddl = generator.generate(list);
			System.out.println("DDL="+ddl);
			tools.openTextFrame("DDL쐬", ddl, true);
		}
		catch (Exception e) {
			tools.showMessage(tools.getTreeFrame(), "DDL̍쐬Ɏs܂", e, SxOptionPane.ERROR_MESSAGE);
		}
	}
}

