package asandatabasebrowser.action;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

import net.sourceforge.swingx.jspread.JSpread;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.ColumnInfo;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.DbResultSetView;
import asandatabasebrowser.view.DbTableView;


public class CreateInsertAction extends AbstractAction {
	final AsanDatabaseBrowser tools;
	final JComponent view;
	final VvDatabase db;
	public CreateInsertAction(AsanDatabaseBrowser tools, VvDatabase db, JComponent view) {
		super("IꂽR[hINSERTNbv{[hɍ쐬");
		putValue(SHORT_DESCRIPTION,	"IꂽR[hINSERTNbv{[hɍ쐬܂");
		putValue(LONG_DESCRIPTION, "IꂽR[hINSERTNbv{[hɍ쐬܂");
		this.tools = tools;
		this.db = db;
		this.view = view;
	}
	
	public void actionPerformed(ActionEvent ev) {
		//System.out.println(ev);
		try {
			// IꂽׂĂrowɑ΂āAinsertB
			StringBuffer sb = new StringBuffer();
			sb.append("-- ԈĂ邩Ȃ̂ŁA܂MpȂ悤ɁB\n");
			if (view instanceof DbResultSetView) {
				DbResultSetView view2 = (DbResultSetView) view;
				int[] rows = view2.getSelectedRows();
				TableInfo info = (TableInfo) view2.data.tableInfo;
				for (int i=0; i<rows.length; i++) {
					System.out.println(rows[i]);
					String sql = createInsert(info, view2.data.getRecord(rows[i]));
					sb.append(sql).append("\n");
				}
			} else {
				DbTableView view2 = (DbTableView) view;
				TableInfo info = (TableInfo) view2.data.tableInfo;
				boolean[] sel = view2.getSheet().getSelectionArray(JSpread.ROW);
				for (int i=0; i<sel.length; i++) {
					if (sel[i]) {
						String sql = createInsert(info, view2.data.getRecord(i));
						sb.append(sql).append("\n");
					}
				}
//				int[] rows = view2.getSelectedRecordIndex();
//				for (int i=0; i<rows.length; i++) {
//					String sql = createInsert(info, view2.data.getRecord(rows[i]));
//					sb.append(sql).append("\n");
//				}
			}
			// Nbv{[hɃRs[
			StringSelection ss = new StringSelection(sb.toString());
	        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss,ss);
			
		} catch (DbException e) {
			tools.showMessage(view, "INSERT̍쐬Ɏs܂B", e, JOptionPane.ERROR_MESSAGE);
		}
	}

	String createInsert(TableInfo info, Object[] data) throws DbException {
		StringBuffer sb = new StringBuffer();
		sb.append("insert into ");
		sb.append(info.getSqlTableName());
		for (int i=0; i<info.getColumnCount(); i++) {
			if (i != 0) {
				sb.append("\n    ,");
			} else {
				sb.append(" (\n    ");
			}
			ColumnInfo col = info.getColumnInfo(i);
			sb.append(col.columnName);
		}
		sb.append("\n) values (\n");
		for (int i=0; i<info.getColumnCount(); i++) {
			if (i != 0) {
				sb.append("\n    ,");
			} else {
				sb.append("    ");
			}
			ColumnInfo col = info.getColumnInfo(i);
			String sqlvalue = db.getValueStr(col, data[i]);
			sb.append(sqlvalue);
		}
		sb.append("\n);");
		System.out.println(sb.toString());
		return sb.toString();
	}
}

