package asandatabasebrowser.action;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

import net.sourceforge.swingx.jspread.JSpread;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.ColumnInfo;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.DbResultSetView;
import asandatabasebrowser.view.DbTableView;


public class CreateUpdateAction extends AbstractAction {
	final AsanDatabaseBrowser tools;
	final VvDatabase db;
	final JComponent view;
	
	public CreateUpdateAction(AsanDatabaseBrowser tools, VvDatabase db, JComponent view) {
		super("IꂽR[hUPDATENbv{[hɍ쐬");
		putValue(SHORT_DESCRIPTION,	"IꂽR[hUPDATENbv{[hɍ쐬܂");
		putValue(LONG_DESCRIPTION, "IꂽR[hUPDATENbv{[hɍ쐬܂");
		this.tools = tools;
		this.db = db;
		this.view = view;
	}
	
	/**
	 * ŏStringŎĂǁA6000𒴂ƎԂ肷̂ŁAStringBufferɂB
	 * ̏CłPCQbŏI悤ɂȂB
	 */
	public void actionPerformed(ActionEvent ev) {
		//System.out.println(ev);
		try {
			// IꂽׂĂrowɑ΂āAinsertB
			StringBuffer sb = new StringBuffer();
			sb.append("-- ԈĂ邩Ȃ̂ŁA܂MpȂ悤ɁB\n");
			if (view instanceof DbResultSetView) {
				DbResultSetView view2 = (DbResultSetView) view;
				int[] rows = view2.getSelectedRows();
				TableInfo info = (TableInfo) view2.data.tableInfo;
				for (int i=0; i<rows.length; i++) {
					System.out.println(rows[i]);
					String sql = createUpdate(info, view2.data.getRecord(rows[i]));
					sb.append(sql).append("\n");
				}
			} else {
				DbTableView view2 = (DbTableView) view;
				TableInfo info = (TableInfo) view2.data.tableInfo;
				boolean[] sel = view2.getSheet().getSelectionArray(JSpread.ROW);
				for (int i=0; i<sel.length; i++) {
					if (sel[i]) {
						String sql = createUpdate(info, view2.data.getRecord(i));
						sb.append(sql).append("\n");
					}
				}
//				int[] rows = view2.getSelectedRecordIndex();
//				for (int i=0; i<rows.length; i++) {
//					String sql = createUpdate(info, view2.data.getRecord(rows[i]));
//					sb.append(sql).append("\n");
//				}
			}
			
			// Nbv{[hɃRs[
			StringSelection ss = new StringSelection(sb.toString());
	        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss,ss);
			
		} catch (DbException e) {
			tools.showMessage(view, "UPDATE̍쐬Ɏs܂B", e, JOptionPane.ERROR_MESSAGE);
		}
	}

	String createUpdate(TableInfo info, Object[] data) throws DbException {
		StringBuffer sb = new StringBuffer();
		sb.append("update ");
		sb.append(info.getSqlTableName());
		sb.append(" set \n    ");
		for (int i=0; i<info.getColumnCount(); i++) {
			if (i != 0) {
				sb.append("\n    ,");
			}
			ColumnInfo col = info.getColumnInfo(i);
			String sqlvalue = db.getValueStr(col, data[i]);
			sb.append(col.columnName+"="+sqlvalue);
		}
		sb.append("\nwhere ");
		// PKƂ́APKɂB
		if (info.pkList != null && info.pkList.size() > 0) {
			for (int i=0; i<info.pkList.size(); i++) {
				if (i != 0) {
					sb.append("\n    and ");
				}
				String pk = (String) info.pkList.get(i);
				int index = info.getColumnIndexByName(pk);
				assert index != -1: index;
				ColumnInfo col = info.getColumnInfo(index);
				if (data[index] != null) {
					String sqlvalue = db.getValueStr(col, data[index]);
					sb.append(col.columnName+"="+sqlvalue);
				} else {
					sb.append(col.columnName+" is null");
				}
			}
		} else {
			// PKȂƂ́AׂĂ̒lL[ɂ
			for (int i=0; i<info.getColumnCount(); i++) {
				if (i != 0) {
					sb.append("\n    and ");
				}
				ColumnInfo col = info.getColumnInfo(i);
				if (data[i] != null) {
					String sqlvalue = db.getValueStr(col, data[i]);
					sb.append(col.columnName+"="+sqlvalue);
				} else {
					sb.append(col.columnName+" is null");
				}
			}
		}
		sb.append(";");
		System.out.println(sb.toString());
		return sb.toString();
	}
}

