/*
 * 쐬: 2005/10/02
 */
package asandatabasebrowser.action;

import java.awt.*;
import java.awt.event.ActionEvent;

import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.*;

import net.sourceforge.swingx.SxHeavyAction;
import net.sourceforge.swingx.SxOptionPane;
import net.sourceforge.swingx.SxProgressDialog;


/**
 * f[^x[XɐڑB
 * @author Asan
 */
public class DatabaseConnectAction extends SxHeavyAction {
	AsanDatabaseBrowser tools;
	SxProgressDialog progressDialog;
	public DatabaseConnectAction(AsanDatabaseBrowser tools) {
		super("ڑ(C)");
		putValue(MNEMONIC_KEY, new Integer('C'));
		putValue(SHORT_DESCRIPTION, "f[^x[Xɐڑ");
		putValue(LONG_DESCRIPTION, "f[^x[Xɐڑ");
		this.tools = tools;
	}

    public void actionPerformed(ActionEvent ev) {
    	// IĂc[擾
    	DbTreeFrame treeFrame = tools.getTreeFrame();
    	DbTreeView tree = tools.getTreeFrame().getTree();
    	VvDatabase db = tree.getSelectedDatabase(false);
    	if (db == null) return;	// DBIĂȂB
    	// łɐڑĂ邩H
    	if (db.getConnection() != null) return;

    	// ftHg̃[U
    	String user = db.user;
    	String pass = db.password;
    	// ڑɃ[UƃpX[h₢킹邩H
    	if (db.isShowLoginDialog) {
        	ConnectDialog dialog = new ConnectDialog();
    		dialog.setDatabase(db);
            int ret = JOptionPane.showConfirmDialog(treeFrame, 
            	dialog,
                "f[^x[Xւ̐ڑ", 
                JOptionPane.OK_CANCEL_OPTION,
                JOptionPane.PLAIN_MESSAGE);
 	    	if (ret != JOptionPane.OK_OPTION) return;	// LZ
	    	user = dialog.getUser();
	    	pass = dialog.getPass();
    	}
    	// ڑʃXbhōsB
    	ConnectThread thread = new ConnectThread(db, user, pass);
		progressDialog = new SxProgressDialog(treeFrame, 
    			"f[^x[Xւ̐ڑ", thread);
    	progressDialog.setProgress(10,
    			"<html><center>ڑ...<br>f[^x[X: "+db.name+
    			"<br>[U: "+user+"</center></html>");
    	progressDialog.start();		
    }
    
    class ConnectThread extends Thread {
    	VvDatabase db;
    	String user;
    	String pass;
    	ConnectThread(VvDatabase db, String user, String pass) {
    		this.db = db;
    		this.user = user;
    		this.pass = pass;
    	}
    	
    	public void run() {
        	final DbTreeFrame treeFrame = tools.getTreeFrame();
        	setMouseCursor(treeFrame, new Cursor(Cursor.WAIT_CURSOR));

        	try {
        		// [U瑼̑삪sȂ悤ɁA_CAO[_ŊJB
        		// ̃_CAOCxgfBXpb`XbhĂԂƂ͂łȂB
        		// ȂȂACxgfBXpb`XbhŃ[_ŊJƁA
        		// ̃_CAOȂȀɍsȂB

				// ڑ
				db.connect(user, pass);

		    	progressDialog.setProgress(80, "ڑ");
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						try {
							DbTreeView tree = treeFrame.getTree();
				        	DefaultMutableTreeNode node = (DefaultMutableTreeNode) tree.getSelectionPath().getLastPathComponent();
				        	tree.ڑ̂Ŏ}(node, db);
							treeFrame.updateMainFrame();
						} catch(DbException e) {
							tools.showMessage(treeFrame, 
									"f[^x[X̐ڑɎs܂:"+db.name, e, 
									SxOptionPane.OK_ONLY_OPTION, SxOptionPane.ERROR_MESSAGE);
						}
					}
				});
			} catch (DbException e) {
				tools.invokeShowMessage(treeFrame, 
						"f[^x[X̐ڑɎs܂:"+db.name, e, 
						SxOptionPane.OK_ONLY_OPTION, SxOptionPane.ERROR_MESSAGE);
				e.printStackTrace();
			} finally {
				if (progressDialog != null) progressDialog.dispose();
			}
			setMouseCursor(treeFrame, Cursor.getDefaultCursor());
    	}
    }
	public void updateStatus() {
	}
}

