package asandatabasebrowser.action;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import net.sourceforge.swingx.SxOptionPane;

import asandatabasebrowser.Global;
import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.model.VvDocument;
import asandatabasebrowser.view.DbTreeFrame;
import asandatabasebrowser.view.DbTreeView;



public class DatabaseDeleteAction extends AbstractAction {
	AsanDatabaseBrowser tools;
	public DatabaseDeleteAction(AsanDatabaseBrowser tools) {
		super("f[^x[Xڑ폜(D) ...");
		putValue(MNEMONIC_KEY, new Integer('D'));
		putValue(SHORT_DESCRIPTION, "f[^x[Xڑ폜");
		putValue(LONG_DESCRIPTION, "f[^x[Xڑ폜");
		putValue(SMALL_ICON, Global.getImageIcon("/resources/database_delete.png"));
		this.tools = tools;
	}

    public void actionPerformed(ActionEvent ev) {
		DbTreeFrame parent = tools.getTreeFrame();
    	// IĂc[擾
		DbTreeView tree = tools.getTreeFrame().getTree();
//		VvDatabase db = tree.getSelectedDatabase(true);
		TreePath path = tree.getSelectionPath();
        if (path == null) return;
        if (path.getPathCount() < DbTreeView.NODE_DEPTH_DB) return;	// 2Kwڈȍ~IĂ邱
        DefaultMutableTreeNode node = (DefaultMutableTreeNode) path.getPathComponent(DbTreeView.NODE_DEPTH_DB-1);
        VvDatabase db = (VvDatabase) node.getUserObject();
    	// łɐڑĂ邩H
    	if (db.getConnection() != null) {
			tools.showMessage(parent, 
					"f[^x[XؒfĂsĂB", null,
					SxOptionPane.WARNING_MESSAGE);
    		return;
    	}

		// ₢킹
		int rc = tools.showMessage(parent, 
			"f[^x[Xڑ폜܂B\n낵łH\n"+db.name, null,
			SxOptionPane.YES_NO_OPTION, SxOptionPane.QUESTION_MESSAGE);
	    if (rc != SxOptionPane.YES) return;
	    VvDocument doc = AsanDatabaseBrowser.theApp.doc;
	    doc.databaseList.remove(db);
	    doc.setModified(true);
        System.out.println(doc.databaseList.size());
        tree.ca폜(node);
    }
}

