/*
 * 쐬: 2005/10/02
 */
package asandatabasebrowser.action;

import java.awt.Cursor;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import net.sourceforge.swingx.SxOptionPane;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.DbTreeView;



public class DatabaseDisconnectAction extends AbstractAction {
	AsanDatabaseBrowser tools;
	public DatabaseDisconnectAction(AsanDatabaseBrowser tools) {
		super("ؒf(D)");
		putValue(MNEMONIC_KEY, new Integer('D'));
		putValue(SHORT_DESCRIPTION, "f[^x[Xؒf");
		putValue(LONG_DESCRIPTION, "f[^x[Xؒf");
		this.tools = tools;
	}

    public void actionPerformed(ActionEvent ev) {
    	// IĂc[擾
    	DbTreeView tree = tools.getTreeFrame().getTree();
    	VvDatabase db = tree.getSelectedDatabase(true);
    	if (db == null) return;
    	// łɐؒfĂ邩H
    	if (db.getConnection() == null) return;
    	// ؒf
    	try {
			tools.getTreeFrame().setCursor(new Cursor(Cursor.WAIT_CURSOR));
			db.disconnect();
		} catch (DbException e) {
			tools.showMessage(tree, "f[^x[X̐ؒfɎs܂", e, SxOptionPane.ERROR_MESSAGE);
		}
		finally {
	        // m[hB
			TreePath path = tree.getSelectionPath();
	        DefaultMutableTreeNode node = (DefaultMutableTreeNode) path.getPathComponent(DbTreeView.NODE_DEPTH_DB-1);
	        tree.ؒf̂Ŏ}폜(node);
	        // J[\Aj[XVB
	        tools.getTreeFrame().setCursor(Cursor.getDefaultCursor());
        	tools.getTreeFrame().updateMainFrame();
		}
    }
}

