package asandatabasebrowser.action;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

import asandatabasebrowser.*;
import asandatabasebrowser.model.*;
import asandatabasebrowser.view.*;



public class DatabaseMetadataAction extends AbstractAction {
	AsanDatabaseBrowser tools;
	public DatabaseMetadataAction(AsanDatabaseBrowser tools) {
		super("^f[^̕\(M)");
		putValue(MNEMONIC_KEY, new Integer('M'));
		putValue(SHORT_DESCRIPTION, "^f[^̕\");
		putValue(LONG_DESCRIPTION, "^f[^̕\");
		this.tools = tools;
	}

	public void actionPerformed(ActionEvent ev) {
		DbTreeFrame parent = tools.getTreeFrame();
		DbTreeView tree = parent.getTree();
		Object[][] prop = null;
		VvDatabase db = tree.getSelectedDatabase(true);
		if (db == null) return;
		parent.setCursor(new Cursor(Cursor.WAIT_CURSOR));	// v
		try {
			prop = db.getMetaDataProperties();
			String text = "";
			for (int i=0; i<prop.length; i++) {
				text += prop[i][0] + " = " + prop[i][1] + "\n";
			}
			tools.openTextFrame(db.name+" ^f[^", text, false);
		}
		catch (DbException e) {
			e.printStackTrace();
		}
		finally {
			parent.setCursor(Cursor.getDefaultCursor());
		}
	}
}

