/*
 * 쐬: 2007/07/06
 */
package asandatabasebrowser.action;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import net.sourceforge.swingx.SxOptionPane;

import asandatabasebrowser.Global;
import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.DbTreeView;


public class DatabaseRefreshAction extends AbstractAction {
	AsanDatabaseBrowser tools;
	public DatabaseRefreshAction(AsanDatabaseBrowser tools) {
		super("f[^x[Xc[ŐV(R)");
		putValue(MNEMONIC_KEY, new Integer('R'));
		putValue(SHORT_DESCRIPTION, "f[^x[Xc[ŐVɂ܂");
		putValue(LONG_DESCRIPTION, "f[^x[Xc[ŐVɂ܂");
		putValue(SMALL_ICON, Global.getImageIcon("/resources/Update.png"));
		this.tools = tools;
	}
	public void actionPerformed(ActionEvent ev) {
    	// IĂc[擾
    	DbTreeView tree = tools.getTreeFrame().getTree();
    	VvDatabase db = tree.getSelectedDatabase(true);
    	if (db == null) return;
    	// łɐؒfĂ邩H
    	if (db.getConnection() == null) return;
    	// c[U폜B
        TreePath path = tree.getSelectionPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode) path.getPathComponent(DbTreeView.NODE_DEPTH_DB-1);
        tree.ؒf̂Ŏ}폜(node);
        try {
            db.createSchemaList();
			tree.ڑ̂Ŏ}(node, db);
		} catch (DbException ex) {
			tools.showMessage(tree, "f[^x[X̍č\zɎs܂", ex, SxOptionPane.ERROR_MESSAGE);
		}
    	tools.getTreeFrame().updateMainFrame();
	}
}
